/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.plumber;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.metamx.common.IAE;
import com.metamx.common.ISE;
import com.metamx.common.logger.Logger;
import io.druid.data.input.InputRow;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexSchema;
import io.druid.segment.realtime.FireHydrant;
import io.druid.segment.realtime.Schema;
import io.druid.timeline.DataSegment;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import org.joda.time.Interval;

public class Sink
implements Iterable<FireHydrant> {
    private static final Logger log = new Logger(Sink.class);
    private volatile FireHydrant currIndex;
    private final Interval interval;
    private final Schema schema;
    private final String version;
    private final CopyOnWriteArrayList<FireHydrant> hydrants = new CopyOnWriteArrayList();

    public Sink(Interval interval, Schema schema, String version) {
        this.schema = schema;
        this.interval = interval;
        this.version = version;
        this.makeNewCurrIndex(interval.getStartMillis(), schema);
    }

    public Sink(Interval interval, Schema schema, String version, List<FireHydrant> hydrants) {
        this.schema = schema;
        this.interval = interval;
        this.version = version;
        for (int i = 0; i < hydrants.size(); ++i) {
            FireHydrant hydrant = hydrants.get(i);
            if (hydrant.getCount() == i) continue;
            throw new ISE("hydrant[%s] not the right count[%s]", new Object[]{hydrant, i});
        }
        this.hydrants.addAll(hydrants);
        this.makeNewCurrIndex(interval.getStartMillis(), schema);
    }

    public String getVersion() {
        return this.version;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public FireHydrant getCurrIndex() {
        return this.currIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int add(InputRow row) {
        if (this.currIndex == null) {
            throw new IAE("No currIndex but given row[%s]", new Object[]{row});
        }
        FireHydrant fireHydrant = this.currIndex;
        synchronized (fireHydrant) {
            return this.currIndex.getIndex().add(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        FireHydrant fireHydrant = this.currIndex;
        synchronized (fireHydrant) {
            return this.hydrants.size() == 1 && this.currIndex.getIndex().isEmpty();
        }
    }

    public FireHydrant swap() {
        return this.makeNewCurrIndex(this.interval.getStartMillis(), this.schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean swappable() {
        FireHydrant fireHydrant = this.currIndex;
        synchronized (fireHydrant) {
            return this.currIndex.getIndex() != null && this.currIndex.getIndex().size() != 0;
        }
    }

    public DataSegment getSegment() {
        return new DataSegment(this.schema.getDataSource(), this.interval, this.version, (Map)ImmutableMap.of(), (List)Lists.newArrayList(), Lists.transform(Arrays.asList(this.schema.getAggregators()), (Function)new Function<AggregatorFactory, String>(){

            public String apply(@Nullable AggregatorFactory input) {
                return input.getName();
            }
        }), this.schema.getShardSpec(), null, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FireHydrant makeNewCurrIndex(long minTimestamp, Schema schema) {
        FireHydrant old;
        IncrementalIndex newIndex = new IncrementalIndex(new IncrementalIndexSchema.Builder().withMinTimestamp(minTimestamp).withQueryGranularity(schema.getIndexGranularity()).withSpatialDimensions(schema.getSpatialDimensions()).withMetrics(schema.getAggregators()).build());
        if (this.currIndex == null) {
            old = this.currIndex;
            this.currIndex = new FireHydrant(newIndex, this.hydrants.size(), this.getSegment().getIdentifier());
            this.hydrants.add(this.currIndex);
        } else {
            FireHydrant fireHydrant = this.currIndex;
            synchronized (fireHydrant) {
                old = this.currIndex;
                this.currIndex = new FireHydrant(newIndex, this.hydrants.size(), this.getSegment().getIdentifier());
                this.hydrants.add(this.currIndex);
            }
        }
        return old;
    }

    @Override
    public Iterator<FireHydrant> iterator() {
        return Iterators.filter(this.hydrants.iterator(), (Predicate)new Predicate<FireHydrant>(){

            public boolean apply(@Nullable FireHydrant input) {
                IncrementalIndex index = input.getIndex();
                return index == null || index.size() != 0;
            }
        });
    }

    public String toString() {
        return "Sink{interval=" + this.interval + ", schema=" + this.schema + '}';
    }
}

