/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.plumber;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.metamx.emitter.EmittingLogger;
import com.metamx.emitter.service.ServiceEmitter;
import io.druid.client.ServerView;
import io.druid.guice.annotations.Processing;
import io.druid.query.QueryRunnerFactoryConglomerate;
import io.druid.segment.IndexGranularity;
import io.druid.segment.loading.DataSegmentPusher;
import io.druid.segment.realtime.FireDepartmentMetrics;
import io.druid.segment.realtime.Schema;
import io.druid.segment.realtime.SegmentPublisher;
import io.druid.segment.realtime.plumber.IntervalStartVersioningPolicy;
import io.druid.segment.realtime.plumber.Plumber;
import io.druid.segment.realtime.plumber.PlumberSchool;
import io.druid.segment.realtime.plumber.RealtimePlumber;
import io.druid.segment.realtime.plumber.RejectionPolicy;
import io.druid.segment.realtime.plumber.RejectionPolicyFactory;
import io.druid.segment.realtime.plumber.ServerTimeRejectionPolicyFactory;
import io.druid.segment.realtime.plumber.VersioningPolicy;
import io.druid.server.coordination.DataSegmentAnnouncer;
import java.io.File;
import java.util.concurrent.ExecutorService;
import javax.validation.constraints.NotNull;
import org.joda.time.Period;

public class RealtimePlumberSchool
implements PlumberSchool {
    public static final int DEFAULT_MAX_PENDING_PERSISTS = 2;
    private static final EmittingLogger log = new EmittingLogger(RealtimePlumberSchool.class);
    private final Period windowPeriod;
    private final File basePersistDirectory;
    private final IndexGranularity segmentGranularity;
    @JacksonInject
    @NotNull
    private volatile ServiceEmitter emitter;
    @JacksonInject
    @NotNull
    private volatile QueryRunnerFactoryConglomerate conglomerate = null;
    @JacksonInject
    @NotNull
    private volatile DataSegmentPusher dataSegmentPusher = null;
    @JacksonInject
    @NotNull
    private volatile DataSegmentAnnouncer segmentAnnouncer = null;
    @JacksonInject
    @NotNull
    private volatile SegmentPublisher segmentPublisher = null;
    @JacksonInject
    @NotNull
    private volatile ServerView serverView = null;
    @JacksonInject
    @NotNull
    @Processing
    private volatile ExecutorService queryExecutorService = null;
    private volatile int maxPendingPersists;
    private volatile VersioningPolicy versioningPolicy = null;
    private volatile RejectionPolicyFactory rejectionPolicyFactory = null;

    @JsonCreator
    public RealtimePlumberSchool(@JsonProperty(value="windowPeriod") Period windowPeriod, @JsonProperty(value="basePersistDirectory") File basePersistDirectory, @JsonProperty(value="segmentGranularity") IndexGranularity segmentGranularity) {
        this.windowPeriod = windowPeriod;
        this.basePersistDirectory = basePersistDirectory;
        this.segmentGranularity = segmentGranularity;
        this.versioningPolicy = new IntervalStartVersioningPolicy();
        this.rejectionPolicyFactory = new ServerTimeRejectionPolicyFactory();
        this.maxPendingPersists = 2;
        Preconditions.checkNotNull((Object)windowPeriod, (Object)"RealtimePlumberSchool requires a windowPeriod.");
        Preconditions.checkNotNull((Object)basePersistDirectory, (Object)"RealtimePlumberSchool requires a basePersistDirectory.");
        Preconditions.checkNotNull((Object)segmentGranularity, (Object)"RealtimePlumberSchool requires a segmentGranularity.");
    }

    @JsonProperty(value="versioningPolicy")
    public void setVersioningPolicy(VersioningPolicy versioningPolicy) {
        this.versioningPolicy = versioningPolicy;
    }

    @JsonProperty(value="rejectionPolicy")
    public void setRejectionPolicyFactory(RejectionPolicyFactory factory) {
        this.rejectionPolicyFactory = factory;
    }

    public void setEmitter(ServiceEmitter emitter) {
        this.emitter = emitter;
    }

    public void setConglomerate(QueryRunnerFactoryConglomerate conglomerate) {
        this.conglomerate = conglomerate;
    }

    public void setDataSegmentPusher(DataSegmentPusher dataSegmentPusher) {
        this.dataSegmentPusher = dataSegmentPusher;
    }

    public void setSegmentAnnouncer(DataSegmentAnnouncer segmentAnnouncer) {
        this.segmentAnnouncer = segmentAnnouncer;
    }

    public void setSegmentPublisher(SegmentPublisher segmentPublisher) {
        this.segmentPublisher = segmentPublisher;
    }

    public void setServerView(ServerView serverView) {
        this.serverView = serverView;
    }

    public void setQueryExecutorService(ExecutorService executorService) {
        this.queryExecutorService = executorService;
    }

    public void setDefaultMaxPendingPersists(int maxPendingPersists) {
        this.maxPendingPersists = maxPendingPersists;
    }

    @Override
    public Plumber findPlumber(Schema schema, FireDepartmentMetrics metrics) {
        this.verifyState();
        RejectionPolicy rejectionPolicy = this.rejectionPolicyFactory.create(this.windowPeriod);
        log.info("Creating plumber using rejectionPolicy[%s]", new Object[]{rejectionPolicy});
        return new RealtimePlumber(this.windowPeriod, this.basePersistDirectory, this.segmentGranularity, schema, metrics, rejectionPolicy, this.emitter, this.conglomerate, this.segmentAnnouncer, this.queryExecutorService, this.versioningPolicy, this.dataSegmentPusher, this.segmentPublisher, this.serverView, this.maxPendingPersists);
    }

    private void verifyState() {
        Preconditions.checkNotNull((Object)this.conglomerate, (Object)"must specify a queryRunnerFactoryConglomerate to do this action.");
        Preconditions.checkNotNull((Object)this.dataSegmentPusher, (Object)"must specify a segmentPusher to do this action.");
        Preconditions.checkNotNull((Object)this.segmentAnnouncer, (Object)"must specify a segmentAnnouncer to do this action.");
        Preconditions.checkNotNull((Object)this.segmentPublisher, (Object)"must specify a segmentPublisher to do this action.");
        Preconditions.checkNotNull((Object)this.serverView, (Object)"must specify a serverView to do this action.");
        Preconditions.checkNotNull((Object)this.emitter, (Object)"must specify a serviceEmitter to do this action.");
    }
}

