/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.plumber;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.metamx.common.Pair;
import com.metamx.common.concurrent.ScheduledExecutors;
import com.metamx.common.guava.FunctionalIterable;
import com.metamx.emitter.EmittingLogger;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.client.DruidServer;
import io.druid.client.ServerView;
import io.druid.common.guava.ThreadRenamingCallable;
import io.druid.common.guava.ThreadRenamingRunnable;
import io.druid.concurrent.Execs;
import io.druid.query.MetricsEmittingQueryRunner;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryRunnerFactory;
import io.druid.query.QueryRunnerFactoryConglomerate;
import io.druid.query.QueryToolChest;
import io.druid.query.SegmentDescriptor;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.spec.QuerySegmentSpec;
import io.druid.query.spec.SpecificSegmentQueryRunner;
import io.druid.query.spec.SpecificSegmentSpec;
import io.druid.segment.IndexGranularity;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexMerger;
import io.druid.segment.QueryableIndex;
import io.druid.segment.QueryableIndexSegment;
import io.druid.segment.Segment;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.loading.DataSegmentPusher;
import io.druid.segment.realtime.FireDepartmentMetrics;
import io.druid.segment.realtime.FireHydrant;
import io.druid.segment.realtime.Schema;
import io.druid.segment.realtime.SegmentPublisher;
import io.druid.segment.realtime.plumber.Plumber;
import io.druid.segment.realtime.plumber.RejectionPolicy;
import io.druid.segment.realtime.plumber.Sink;
import io.druid.segment.realtime.plumber.VersioningPolicy;
import io.druid.server.coordination.DataSegmentAnnouncer;
import io.druid.timeline.DataSegment;
import io.druid.timeline.TimelineObjectHolder;
import io.druid.timeline.VersionedIntervalTimeline;
import io.druid.timeline.partition.PartitionChunk;
import io.druid.timeline.partition.ShardSpec;
import io.druid.timeline.partition.SingleElementPartitionChunk;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;

public class RealtimePlumber
implements Plumber {
    private static final EmittingLogger log = new EmittingLogger(RealtimePlumber.class);
    private final Period windowPeriod;
    private final File basePersistDirectory;
    private final IndexGranularity segmentGranularity;
    private final Schema schema;
    private final FireDepartmentMetrics metrics;
    private final RejectionPolicy rejectionPolicy;
    private final ServiceEmitter emitter;
    private final QueryRunnerFactoryConglomerate conglomerate;
    private final DataSegmentAnnouncer segmentAnnouncer;
    private final ExecutorService queryExecutorService;
    private final VersioningPolicy versioningPolicy;
    private final DataSegmentPusher dataSegmentPusher;
    private final SegmentPublisher segmentPublisher;
    private final ServerView serverView;
    private final int maxPendingPersists;
    private final Object handoffCondition = new Object();
    private final Map<Long, Sink> sinks = Maps.newConcurrentMap();
    private final VersionedIntervalTimeline<String, Sink> sinkTimeline = new VersionedIntervalTimeline(String.CASE_INSENSITIVE_ORDER);
    private volatile boolean shuttingDown = false;
    private volatile boolean stopped = false;
    private volatile ExecutorService persistExecutor = null;
    private volatile ScheduledExecutorService scheduledExecutor = null;

    public RealtimePlumber(Period windowPeriod, File basePersistDirectory, IndexGranularity segmentGranularity, Schema schema, FireDepartmentMetrics metrics, RejectionPolicy rejectionPolicy, ServiceEmitter emitter, QueryRunnerFactoryConglomerate conglomerate, DataSegmentAnnouncer segmentAnnouncer, ExecutorService queryExecutorService, VersioningPolicy versioningPolicy, DataSegmentPusher dataSegmentPusher, SegmentPublisher segmentPublisher, ServerView serverView, int maxPendingPersists) {
        this.windowPeriod = windowPeriod;
        this.basePersistDirectory = basePersistDirectory;
        this.segmentGranularity = segmentGranularity;
        this.schema = schema;
        this.metrics = metrics;
        this.rejectionPolicy = rejectionPolicy;
        this.emitter = emitter;
        this.conglomerate = conglomerate;
        this.segmentAnnouncer = segmentAnnouncer;
        this.queryExecutorService = queryExecutorService;
        this.versioningPolicy = versioningPolicy;
        this.dataSegmentPusher = dataSegmentPusher;
        this.segmentPublisher = segmentPublisher;
        this.serverView = serverView;
        this.maxPendingPersists = maxPendingPersists;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Period getWindowPeriod() {
        return this.windowPeriod;
    }

    public IndexGranularity getSegmentGranularity() {
        return this.segmentGranularity;
    }

    public VersioningPolicy getVersioningPolicy() {
        return this.versioningPolicy;
    }

    public RejectionPolicy getRejectionPolicy() {
        return this.rejectionPolicy;
    }

    public Map<Long, Sink> getSinks() {
        return this.sinks;
    }

    @Override
    public void startJob() {
        this.computeBaseDir(this.schema).mkdirs();
        this.initializeExecutors();
        this.bootstrapSinksFromDisk();
        this.registerServerViewCallback();
        this.startPersistThread();
    }

    @Override
    public Sink getSink(long timestamp) {
        if (!this.rejectionPolicy.accept(timestamp)) {
            return null;
        }
        long truncatedTime = this.segmentGranularity.truncate(timestamp);
        Sink retVal = this.sinks.get(truncatedTime);
        if (retVal == null) {
            Interval sinkInterval = new Interval((ReadableInstant)new DateTime(truncatedTime), (ReadableInstant)this.segmentGranularity.increment(new DateTime(truncatedTime)));
            retVal = new Sink(sinkInterval, this.schema, this.versioningPolicy.getVersion(sinkInterval));
            try {
                this.segmentAnnouncer.announceSegment(retVal.getSegment());
                this.sinks.put(truncatedTime, retVal);
                this.sinkTimeline.add(retVal.getInterval(), (Object)retVal.getVersion(), (PartitionChunk)new SingleElementPartitionChunk((Object)retVal));
            }
            catch (IOException e) {
                log.makeAlert((Throwable)e, "Failed to announce new segment[%s]", new Object[]{this.schema.getDataSource()}).addData("interval", (Object)retVal.getInterval()).emit();
            }
        }
        return retVal;
    }

    @Override
    public <T> QueryRunner<T> getQueryRunner(final Query<T> query) {
        final QueryRunnerFactory factory = this.conglomerate.findFactory(query);
        final QueryToolChest toolchest = factory.getToolchest();
        final Function builderFn = new Function<Query<T>, ServiceMetricEvent.Builder>(){

            public ServiceMetricEvent.Builder apply(@Nullable Query<T> input) {
                return toolchest.makeMetricBuilder(query);
            }
        };
        ArrayList querySinks = Lists.newArrayList();
        for (Interval interval : query.getIntervals()) {
            querySinks.addAll(this.sinkTimeline.lookup(interval));
        }
        return toolchest.mergeResults(factory.mergeRunners(this.queryExecutorService, (Iterable)FunctionalIterable.create((Iterable)querySinks).transform(new Function<TimelineObjectHolder<String, Sink>, QueryRunner<T>>(){

            public QueryRunner<T> apply(TimelineObjectHolder<String, Sink> holder) {
                Sink theSink = (Sink)holder.getObject().getChunk(0).getObject();
                return new SpecificSegmentQueryRunner((QueryRunner)new MetricsEmittingQueryRunner(RealtimePlumber.this.emitter, builderFn, factory.mergeRunners((ExecutorService)MoreExecutors.sameThreadExecutor(), Iterables.transform((Iterable)theSink, (Function)new Function<FireHydrant, QueryRunner<T>>(){

                    public QueryRunner<T> apply(FireHydrant input) {
                        return factory.createRunner(input.getSegment());
                    }
                }))), (QuerySegmentSpec)new SpecificSegmentSpec(new SegmentDescriptor(holder.getInterval(), theSink.getSegment().getVersion(), theSink.getSegment().getShardSpec().getPartitionNum())));
            }
        })));
    }

    @Override
    public void persist(final Runnable commitRunnable) {
        final ArrayList indexesToPersist = Lists.newArrayList();
        for (Sink sink : this.sinks.values()) {
            if (!sink.swappable()) continue;
            indexesToPersist.add(Pair.of((Object)sink.swap(), (Object)sink.getInterval()));
        }
        log.info("Submitting persist runnable for dataSource[%s]", new Object[]{this.schema.getDataSource()});
        this.persistExecutor.execute((Runnable)new ThreadRenamingRunnable(String.format("%s-incremental-persist", this.schema.getDataSource())){

            public void doRun() {
                for (Pair pair : indexesToPersist) {
                    RealtimePlumber.this.metrics.incrementRowOutputCount(RealtimePlumber.this.persistHydrant((FireHydrant)pair.lhs, RealtimePlumber.this.schema, (Interval)pair.rhs));
                }
                commitRunnable.run();
            }
        });
    }

    private void persistAndMerge(final long truncatedTime, final Sink sink) {
        String threadName = String.format("%s-%s-persist-n-merge", this.schema.getDataSource(), new DateTime(truncatedTime));
        this.persistExecutor.execute((Runnable)new ThreadRenamingRunnable(threadName){

            public void doRun() {
                File mergedFile;
                block8: {
                    Interval interval = sink.getInterval();
                    for (FireHydrant hydrant : sink) {
                        if (hydrant.hasSwapped()) continue;
                        log.info("Hydrant[%s] hasn't swapped yet, swapping. Sink[%s]", new Object[]{hydrant, sink});
                        int rowCount = RealtimePlumber.this.persistHydrant(hydrant, RealtimePlumber.this.schema, interval);
                        RealtimePlumber.this.metrics.incrementRowOutputCount(rowCount);
                    }
                    File mergedTarget = new File(RealtimePlumber.this.computePersistDir(RealtimePlumber.this.schema, interval), "merged");
                    if (mergedTarget.exists()) {
                        log.info("Skipping already-merged sink: %s", new Object[]{sink});
                        return;
                    }
                    mergedFile = null;
                    try {
                        ArrayList indexes = Lists.newArrayList();
                        for (FireHydrant fireHydrant : sink) {
                            Segment segment = fireHydrant.getSegment();
                            QueryableIndex queryableIndex = segment.asQueryableIndex();
                            log.info("Adding hydrant[%s]", new Object[]{fireHydrant});
                            indexes.add(queryableIndex);
                        }
                        mergedFile = IndexMerger.mergeQueryableIndex((List)indexes, (AggregatorFactory[])RealtimePlumber.this.schema.getAggregators(), (File)mergedTarget);
                        QueryableIndex index = IndexIO.loadIndex((File)mergedFile);
                        DataSegment segment = RealtimePlumber.this.dataSegmentPusher.push(mergedFile, sink.getSegment().withDimensions((List)Lists.newArrayList((Iterable)index.getAvailableDimensions())));
                        RealtimePlumber.this.segmentPublisher.publishSegment(segment);
                    }
                    catch (IOException e) {
                        log.makeAlert((Throwable)e, "Failed to persist merged index[%s]", new Object[]{RealtimePlumber.this.schema.getDataSource()}).addData("interval", (Object)interval).emit();
                        if (!RealtimePlumber.this.shuttingDown) break block8;
                        RealtimePlumber.this.abandonSegment(truncatedTime, sink);
                    }
                }
                if (mergedFile != null) {
                    try {
                        log.info("Deleting Index File[%s]", new Object[]{mergedFile});
                        FileUtils.deleteDirectory((File)mergedFile);
                    }
                    catch (IOException e) {
                        log.warn((Throwable)e, "Error deleting directory[%s]", new Object[]{mergedFile});
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void finishJob() {
        log.info("Shutting down...", new Object[0]);
        this.shuttingDown = true;
        for (Map.Entry<Long, Sink> entry : this.sinks.entrySet()) {
            this.persistAndMerge(entry.getKey(), entry.getValue());
        }
        while (!this.sinks.isEmpty()) {
            try {
                log.info("Cannot shut down yet! Sinks remaining: %s", new Object[]{Joiner.on((String)", ").join(Iterables.transform(this.sinks.values(), (Function)new Function<Sink, String>(){

                    public String apply(Sink input) {
                        return input.getSegment().getIdentifier();
                    }
                }))});
                Object i$ = this.handoffCondition;
                synchronized (i$) {
                    while (!this.sinks.isEmpty()) {
                        this.handoffCondition.wait();
                    }
                }
            }
            catch (InterruptedException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        this.shutdownExecutors();
        this.stopped = true;
    }

    protected void initializeExecutors() {
        if (this.persistExecutor == null) {
            this.persistExecutor = Execs.newBlockingSingleThreaded((String)"plumber_persist_%d", (int)this.maxPendingPersists);
        }
        if (this.scheduledExecutor == null) {
            this.scheduledExecutor = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("plumber_scheduled_%d").build());
        }
    }

    protected void shutdownExecutors() {
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdown();
        }
    }

    protected void bootstrapSinksFromDisk() {
        File baseDir = this.computeBaseDir(this.schema);
        if (baseDir == null || !baseDir.exists()) {
            return;
        }
        File[] files = baseDir.listFiles();
        if (files == null) {
            return;
        }
        for (File sinkDir : files) {
            Interval sinkInterval = new Interval((Object)sinkDir.getName().replace("_", "/"));
            File[] sinkFiles = sinkDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String fileName) {
                    return Ints.tryParse((String)fileName) != null;
                }
            });
            Arrays.sort(sinkFiles, new Comparator<File>(){

                @Override
                public int compare(File o1, File o2) {
                    try {
                        return Ints.compare((int)Integer.parseInt(o1.getName()), (int)Integer.parseInt(o2.getName()));
                    }
                    catch (NumberFormatException e) {
                        log.error((Throwable)e, "Couldn't compare as numbers? [%s][%s]", new Object[]{o1, o2});
                        return o1.compareTo(o2);
                    }
                }
            });
            try {
                ArrayList hydrants = Lists.newArrayList();
                for (File segmentDir : sinkFiles) {
                    log.info("Loading previously persisted segment at [%s]", new Object[]{segmentDir});
                    if (Ints.tryParse((String)segmentDir.getName()) == null) continue;
                    hydrants.add(new FireHydrant((Segment)new QueryableIndexSegment(DataSegment.makeDataSegmentIdentifier((String)this.schema.getDataSource(), (DateTime)sinkInterval.getStart(), (DateTime)sinkInterval.getEnd(), (String)this.versioningPolicy.getVersion(sinkInterval), (ShardSpec)this.schema.getShardSpec()), IndexIO.loadIndex((File)segmentDir)), Integer.parseInt(segmentDir.getName())));
                }
                Sink currSink = new Sink(sinkInterval, this.schema, this.versioningPolicy.getVersion(sinkInterval), hydrants);
                this.sinks.put(sinkInterval.getStartMillis(), currSink);
                this.sinkTimeline.add(currSink.getInterval(), (Object)currSink.getVersion(), (PartitionChunk)new SingleElementPartitionChunk((Object)currSink));
                this.segmentAnnouncer.announceSegment(currSink.getSegment());
            }
            catch (IOException e) {
                log.makeAlert((Throwable)e, "Problem loading sink[%s] from disk.", new Object[]{this.schema.getDataSource()}).addData("interval", (Object)sinkInterval).emit();
            }
        }
    }

    protected void startPersistThread() {
        long truncatedNow = this.segmentGranularity.truncate(new DateTime()).getMillis();
        final long windowMillis = this.windowPeriod.toStandardDuration().getMillis();
        log.info("Expect to run at [%s]", new Object[]{new DateTime().plus((ReadableDuration)new Duration(System.currentTimeMillis(), this.segmentGranularity.increment(truncatedNow) + windowMillis))});
        ScheduledExecutors.scheduleAtFixedRate((ScheduledExecutorService)this.scheduledExecutor, (Duration)new Duration(System.currentTimeMillis(), this.segmentGranularity.increment(truncatedNow) + windowMillis), (Duration)new Duration(truncatedNow, this.segmentGranularity.increment(truncatedNow)), (Callable)new ThreadRenamingCallable<ScheduledExecutors.Signal>(String.format("%s-overseer-%d", this.schema.getDataSource(), this.schema.getShardSpec().getPartitionNum())){

            public ScheduledExecutors.Signal doCall() {
                if (RealtimePlumber.this.stopped) {
                    log.info("Stopping merge-n-push overseer thread", new Object[0]);
                    return ScheduledExecutors.Signal.STOP;
                }
                log.info("Starting merge and push.", new Object[0]);
                long minTimestamp = RealtimePlumber.this.segmentGranularity.truncate(RealtimePlumber.this.rejectionPolicy.getCurrMaxTime().minus(windowMillis)).getMillis();
                ArrayList sinksToPush = Lists.newArrayList();
                for (Map.Entry entry : RealtimePlumber.this.sinks.entrySet()) {
                    Long intervalStart = (Long)entry.getKey();
                    if (intervalStart >= minTimestamp) continue;
                    log.info("Adding entry[%s] for merge and push.", new Object[]{entry});
                    sinksToPush.add(entry);
                }
                for (Map.Entry entry : sinksToPush) {
                    RealtimePlumber.this.persistAndMerge((Long)entry.getKey(), (Sink)entry.getValue());
                }
                if (RealtimePlumber.this.stopped) {
                    log.info("Stopping merge-n-push overseer thread", new Object[0]);
                    return ScheduledExecutors.Signal.STOP;
                }
                return ScheduledExecutors.Signal.REPEAT;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void abandonSegment(long truncatedTime, Sink sink) {
        try {
            this.segmentAnnouncer.unannounceSegment(sink.getSegment());
            FileUtils.deleteDirectory((File)this.computePersistDir(this.schema, sink.getInterval()));
            log.info("Removing sinkKey %d for segment %s", new Object[]{truncatedTime, sink.getSegment().getIdentifier()});
            this.sinks.remove(truncatedTime);
            this.sinkTimeline.remove(sink.getInterval(), (Object)sink.getVersion(), (PartitionChunk)new SingleElementPartitionChunk((Object)sink));
            Object object = this.handoffCondition;
            synchronized (object) {
                this.handoffCondition.notifyAll();
            }
        }
        catch (IOException e) {
            log.makeAlert((Throwable)e, "Unable to abandon old segment for dataSource[%s]", new Object[]{this.schema.getDataSource()}).addData("interval", (Object)sink.getInterval()).emit();
        }
    }

    protected File computeBaseDir(Schema schema) {
        return new File(this.basePersistDirectory, schema.getDataSource());
    }

    protected File computePersistDir(Schema schema, Interval interval) {
        return new File(this.computeBaseDir(schema), interval.toString().replace("/", "_"));
    }

    protected int persistHydrant(FireHydrant indexToPersist, Schema schema, Interval interval) {
        if (indexToPersist.hasSwapped()) {
            log.info("DataSource[%s], Interval[%s], Hydrant[%s] already swapped. Ignoring request to persist.", new Object[]{schema.getDataSource(), interval, indexToPersist});
            return 0;
        }
        log.info("DataSource[%s], Interval[%s], persisting Hydrant[%s]", new Object[]{schema.getDataSource(), interval, indexToPersist});
        try {
            int numRows = indexToPersist.getIndex().size();
            File persistedFile = IndexMerger.persist((IncrementalIndex)indexToPersist.getIndex(), (File)new File(this.computePersistDir(schema, interval), String.valueOf(indexToPersist.getCount())));
            indexToPersist.swapSegment((Segment)new QueryableIndexSegment(indexToPersist.getSegment().getIdentifier(), IndexIO.loadIndex((File)persistedFile)));
            return numRows;
        }
        catch (IOException e) {
            log.makeAlert("dataSource[%s] -- incremental persist failed", new Object[]{schema.getDataSource()}).addData("interval", (Object)interval).addData("count", (Object)indexToPersist.getCount()).emit();
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void registerServerViewCallback() {
        this.serverView.registerSegmentCallback(this.persistExecutor, new ServerView.BaseSegmentCallback(){

            @Override
            public ServerView.CallbackAction segmentAdded(DruidServer server, DataSegment segment) {
                if (RealtimePlumber.this.stopped) {
                    log.info("Unregistering ServerViewCallback", new Object[0]);
                    RealtimePlumber.this.persistExecutor.shutdown();
                    return ServerView.CallbackAction.UNREGISTER;
                }
                if (!server.isAssignable()) {
                    return ServerView.CallbackAction.CONTINUE;
                }
                log.debug("Checking segment[%s] on server[%s]", new Object[]{segment, server});
                if (RealtimePlumber.this.schema.getDataSource().equals(segment.getDataSource())) {
                    Interval interval = segment.getInterval();
                    for (Map.Entry entry : RealtimePlumber.this.sinks.entrySet()) {
                        String sinkVersion;
                        Long sinkKey = (Long)entry.getKey();
                        if (!interval.contains(sinkKey.longValue())) continue;
                        Sink sink = (Sink)entry.getValue();
                        log.info("Segment[%s] matches sink[%s] on server[%s]", new Object[]{segment, sink, server});
                        String segmentVersion = segment.getVersion();
                        if (segmentVersion.compareTo(sinkVersion = sink.getSegment().getVersion()) < 0) continue;
                        log.info("Segment version[%s] >= sink version[%s]", new Object[]{segmentVersion, sinkVersion});
                        RealtimePlumber.this.abandonSegment(sinkKey, sink);
                    }
                }
                return ServerView.CallbackAction.CONTINUE;
            }
        });
    }
}

