/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.plumber;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.metamx.emitter.EmittingLogger;
import com.metamx.emitter.service.ServiceEmitter;
import io.druid.guice.annotations.Processing;
import io.druid.query.QueryRunnerFactoryConglomerate;
import io.druid.segment.IndexGranularity;
import io.druid.segment.realtime.FireDepartmentMetrics;
import io.druid.segment.realtime.Schema;
import io.druid.segment.realtime.plumber.FlushingPlumber;
import io.druid.segment.realtime.plumber.IntervalStartVersioningPolicy;
import io.druid.segment.realtime.plumber.Plumber;
import io.druid.segment.realtime.plumber.PlumberSchool;
import io.druid.segment.realtime.plumber.RejectionPolicy;
import io.druid.segment.realtime.plumber.RejectionPolicyFactory;
import io.druid.segment.realtime.plumber.ServerTimeRejectionPolicyFactory;
import io.druid.segment.realtime.plumber.VersioningPolicy;
import io.druid.server.coordination.DataSegmentAnnouncer;
import java.io.File;
import java.util.concurrent.ExecutorService;
import javax.validation.constraints.NotNull;
import org.joda.time.Duration;
import org.joda.time.Period;

public class FlushingPlumberSchool
implements PlumberSchool {
    private static final EmittingLogger log = new EmittingLogger(FlushingPlumberSchool.class);
    private final Duration flushDuration;
    private final Period windowPeriod;
    private final File basePersistDirectory;
    private final IndexGranularity segmentGranularity;
    private final int maxPendingPersists;
    @JacksonInject
    @NotNull
    private volatile ServiceEmitter emitter;
    @JacksonInject
    @NotNull
    private volatile QueryRunnerFactoryConglomerate conglomerate = null;
    @JacksonInject
    @NotNull
    private volatile DataSegmentAnnouncer segmentAnnouncer = null;
    @JacksonInject
    @NotNull
    @Processing
    private volatile ExecutorService queryExecutorService = null;
    private volatile VersioningPolicy versioningPolicy = null;
    private volatile RejectionPolicyFactory rejectionPolicyFactory = null;

    @JsonCreator
    public FlushingPlumberSchool(@JsonProperty(value="flushDuration") Duration flushDuration, @JsonProperty(value="windowPeriod") Period windowPeriod, @JsonProperty(value="basePersistDirectory") File basePersistDirectory, @JsonProperty(value="segmentGranularity") IndexGranularity segmentGranularity) {
        this.flushDuration = flushDuration;
        this.windowPeriod = windowPeriod;
        this.basePersistDirectory = basePersistDirectory;
        this.segmentGranularity = segmentGranularity;
        this.versioningPolicy = new IntervalStartVersioningPolicy();
        this.rejectionPolicyFactory = new ServerTimeRejectionPolicyFactory();
        this.maxPendingPersists = 2;
        Preconditions.checkNotNull((Object)flushDuration, (Object)"FlushingPlumberSchool requires a flushDuration.");
        Preconditions.checkNotNull((Object)windowPeriod, (Object)"FlushingPlumberSchool requires a windowPeriod.");
        Preconditions.checkNotNull((Object)basePersistDirectory, (Object)"FlushingPlumberSchool requires a basePersistDirectory.");
        Preconditions.checkNotNull((Object)segmentGranularity, (Object)"FlushingPlumberSchool requires a segmentGranularity.");
    }

    @Override
    public Plumber findPlumber(Schema schema, FireDepartmentMetrics metrics) {
        this.verifyState();
        RejectionPolicy rejectionPolicy = this.rejectionPolicyFactory.create(this.windowPeriod);
        log.info("Creating plumber using rejectionPolicy[%s]", new Object[]{rejectionPolicy});
        return new FlushingPlumber(this.flushDuration, this.windowPeriod, this.basePersistDirectory, this.segmentGranularity, schema, metrics, rejectionPolicy, this.emitter, this.conglomerate, this.segmentAnnouncer, this.queryExecutorService, this.versioningPolicy, this.maxPendingPersists);
    }

    private void verifyState() {
        Preconditions.checkNotNull((Object)this.conglomerate, (Object)"must specify a queryRunnerFactoryConglomerate to do this action.");
        Preconditions.checkNotNull((Object)this.segmentAnnouncer, (Object)"must specify a segmentAnnouncer to do this action.");
        Preconditions.checkNotNull((Object)this.emitter, (Object)"must specify a serviceEmitter to do this action.");
    }
}

