/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime.firehose;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Predicate;
import io.druid.data.input.Firehose;
import io.druid.data.input.FirehoseFactory;
import io.druid.data.input.InputRow;
import io.druid.segment.realtime.firehose.PredicateFirehose;
import java.io.IOException;
import org.joda.time.Interval;

public class ClippedFirehoseFactory
implements FirehoseFactory {
    private final FirehoseFactory delegate;
    private final Interval interval;

    @JsonCreator
    public ClippedFirehoseFactory(@JsonProperty(value="delegate") FirehoseFactory delegate, @JsonProperty(value="interval") Interval interval) {
        this.delegate = delegate;
        this.interval = interval;
    }

    @JsonProperty
    public FirehoseFactory getDelegate() {
        return this.delegate;
    }

    @JsonProperty
    public Interval getInterval() {
        return this.interval;
    }

    public Firehose connect() throws IOException {
        return new PredicateFirehose(this.delegate.connect(), new Predicate<InputRow>(){

            public boolean apply(InputRow input) {
                return ClippedFirehoseFactory.this.interval.contains(input.getTimestampFromEpoch());
            }
        });
    }
}

