/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import io.druid.data.input.impl.SpatialDimensionSchema;
import io.druid.granularity.QueryGranularity;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.timeline.partition.NoneShardSpec;
import io.druid.timeline.partition.ShardSpec;
import java.util.Arrays;
import java.util.List;

public class Schema {
    private final String dataSource;
    private final List<SpatialDimensionSchema> spatialDimensions;
    private final AggregatorFactory[] aggregators;
    private final QueryGranularity indexGranularity;
    private final ShardSpec shardSpec;

    @JsonCreator
    public Schema(@JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="spatialDimensions") List<SpatialDimensionSchema> spatialDimensions, @JsonProperty(value="aggregators") AggregatorFactory[] aggregators, @JsonProperty(value="indexGranularity") QueryGranularity indexGranularity, @JsonProperty(value="shardSpec") ShardSpec shardSpec) {
        this.dataSource = dataSource;
        this.spatialDimensions = spatialDimensions == null ? Lists.newArrayList() : spatialDimensions;
        this.aggregators = aggregators;
        this.indexGranularity = indexGranularity;
        this.shardSpec = shardSpec == null ? new NoneShardSpec() : shardSpec;
        Preconditions.checkNotNull((Object)dataSource, (Object)"dataSource");
        Preconditions.checkNotNull((Object)aggregators, (Object)"aggregators");
        Preconditions.checkNotNull((Object)indexGranularity, (Object)"indexGranularity");
    }

    @JsonProperty
    public String getDataSource() {
        return this.dataSource;
    }

    @JsonProperty(value="spatialDimensions")
    public List<SpatialDimensionSchema> getSpatialDimensions() {
        return this.spatialDimensions;
    }

    @JsonProperty
    public AggregatorFactory[] getAggregators() {
        return this.aggregators;
    }

    @JsonProperty
    public QueryGranularity getIndexGranularity() {
        return this.indexGranularity;
    }

    @JsonProperty
    public ShardSpec getShardSpec() {
        return this.shardSpec;
    }

    public String toString() {
        return "Schema{dataSource='" + this.dataSource + '\'' + ", spatialDimensions=" + this.spatialDimensions + ", aggregators=" + (this.aggregators == null ? null : Arrays.asList(this.aggregators)) + ", indexGranularity=" + this.indexGranularity + ", shardSpec=" + this.shardSpec + '}';
    }
}

