/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import com.metamx.metrics.AbstractMonitor;
import io.druid.segment.realtime.FireDepartment;
import io.druid.segment.realtime.FireDepartmentMetrics;
import java.util.List;
import java.util.Map;

public class RealtimeMetricsMonitor
extends AbstractMonitor {
    private final Map<FireDepartment, FireDepartmentMetrics> previousValues;
    private final List<FireDepartment> fireDepartments;

    @Inject
    public RealtimeMetricsMonitor(List<FireDepartment> fireDepartments) {
        this.fireDepartments = fireDepartments;
        this.previousValues = Maps.newHashMap();
    }

    public boolean doMonitor(ServiceEmitter emitter) {
        for (FireDepartment fireDepartment : this.fireDepartments) {
            FireDepartmentMetrics metrics = fireDepartment.getMetrics().snapshot();
            FireDepartmentMetrics previous = this.previousValues.get(fireDepartment);
            if (previous == null) {
                previous = new FireDepartmentMetrics();
            }
            ServiceMetricEvent.Builder builder = new ServiceMetricEvent.Builder().setUser2(fireDepartment.getSchema().getDataSource());
            emitter.emit(builder.build("events/thrownAway", (Number)(metrics.thrownAway() - previous.thrownAway())));
            emitter.emit(builder.build("events/unparseable", (Number)(metrics.unparseable() - previous.unparseable())));
            emitter.emit(builder.build("events/processed", (Number)(metrics.processed() - previous.processed())));
            emitter.emit(builder.build("rows/output", (Number)(metrics.rowOutput() - previous.rowOutput())));
            this.previousValues.put(fireDepartment, metrics);
        }
        return true;
    }
}

