/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime;

import java.util.concurrent.atomic.AtomicLong;

public class FireDepartmentMetrics {
    private final AtomicLong processedCount = new AtomicLong(0L);
    private final AtomicLong thrownAwayCount = new AtomicLong(0L);
    private final AtomicLong unparseableCount = new AtomicLong(0L);
    private final AtomicLong rowOutputCount = new AtomicLong(0L);

    public void incrementProcessed() {
        this.processedCount.incrementAndGet();
    }

    public void incrementThrownAway() {
        this.thrownAwayCount.incrementAndGet();
    }

    public void incrementUnparseable() {
        this.unparseableCount.incrementAndGet();
    }

    public void incrementRowOutputCount(long numRows) {
        this.rowOutputCount.addAndGet(numRows);
    }

    public long processed() {
        return this.processedCount.get();
    }

    public long thrownAway() {
        return this.thrownAwayCount.get();
    }

    public long unparseable() {
        return this.unparseableCount.get();
    }

    public long rowOutput() {
        return this.rowOutputCount.get();
    }

    public FireDepartmentMetrics snapshot() {
        FireDepartmentMetrics retVal = new FireDepartmentMetrics();
        retVal.processedCount.set(this.processedCount.get());
        retVal.thrownAwayCount.set(this.thrownAwayCount.get());
        retVal.unparseableCount.set(this.unparseableCount.get());
        retVal.rowOutputCount.set(this.rowOutputCount.get());
        return retVal;
    }
}

