/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.druid.data.input.Firehose;
import io.druid.data.input.FirehoseFactory;
import io.druid.segment.realtime.FireDepartmentConfig;
import io.druid.segment.realtime.FireDepartmentMetrics;
import io.druid.segment.realtime.Schema;
import io.druid.segment.realtime.plumber.Plumber;
import io.druid.segment.realtime.plumber.PlumberSchool;
import java.io.IOException;

public class FireDepartment {
    @JsonProperty(value="schema")
    private final Schema schema;
    @JsonProperty
    private final FireDepartmentConfig config;
    @JsonProperty
    private final FirehoseFactory firehoseFactory;
    @JsonProperty
    private final PlumberSchool plumberSchool;
    private final FireDepartmentMetrics metrics = new FireDepartmentMetrics();

    @JsonCreator
    public FireDepartment(@JsonProperty(value="schema") Schema schema, @JsonProperty(value="config") FireDepartmentConfig config, @JsonProperty(value="firehose") FirehoseFactory firehoseFactory, @JsonProperty(value="plumber") PlumberSchool plumberSchool) {
        this.schema = schema;
        this.config = config;
        this.firehoseFactory = firehoseFactory;
        this.plumberSchool = plumberSchool;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public FireDepartmentConfig getConfig() {
        return this.config;
    }

    public Plumber findPlumber() {
        return this.plumberSchool.findPlumber(this.schema, this.metrics);
    }

    public Firehose connect() throws IOException {
        return this.firehoseFactory.connect();
    }

    public FireDepartmentMetrics getMetrics() {
        return this.metrics;
    }
}

