/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.realtime;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.metamx.common.logger.Logger;
import io.druid.db.DbTablesConfig;
import io.druid.segment.realtime.SegmentPublisher;
import io.druid.timeline.DataSegment;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.tweak.HandleCallback;

public class DbSegmentPublisher
implements SegmentPublisher {
    private static final Logger log = new Logger(DbSegmentPublisher.class);
    private final ObjectMapper jsonMapper;
    private final DbTablesConfig config;
    private final IDBI dbi;

    @Inject
    public DbSegmentPublisher(ObjectMapper jsonMapper, DbTablesConfig config, IDBI dbi) {
        this.jsonMapper = jsonMapper;
        this.config = config;
        this.dbi = dbi;
    }

    @Override
    public void publishSegment(final DataSegment segment) throws IOException {
        try {
            List exists = (List)this.dbi.withHandle((HandleCallback)new HandleCallback<List<Map<String, Object>>>(){

                public List<Map<String, Object>> withHandle(Handle handle) throws Exception {
                    return ((Query)handle.createQuery(String.format("SELECT id FROM %s WHERE id=:id", DbSegmentPublisher.this.config.getSegmentsTable())).bind("id", segment.getIdentifier())).list();
                }
            });
            if (!exists.isEmpty()) {
                log.info("Found [%s] in DB, not updating DB", new Object[]{segment.getIdentifier()});
                return;
            }
            this.dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

                public Void withHandle(Handle handle) throws Exception {
                    String statement = !handle.getConnection().getMetaData().getDatabaseProductName().contains("PostgreSQL") ? String.format("INSERT INTO %s (id, dataSource, created_date, start, end, partitioned, version, used, payload) VALUES (:id, :dataSource, :created_date, :start, :end, :partitioned, :version, :used, :payload)", DbSegmentPublisher.this.config.getSegmentsTable()) : String.format("INSERT INTO %s (id, dataSource, created_date, start, \"end\", partitioned, version, used, payload) VALUES (:id, :dataSource, :created_date, :start, :end, :partitioned, :version, :used, :payload)", DbSegmentPublisher.this.config.getSegmentsTable());
                    ((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)((Update)handle.createStatement(statement).bind("id", segment.getIdentifier())).bind("dataSource", segment.getDataSource())).bind("created_date", new DateTime().toString())).bind("start", segment.getInterval().getStart().toString())).bind("end", segment.getInterval().getEnd().toString())).bind("partitioned", segment.getShardSpec().getPartitionNum())).bind("version", segment.getVersion())).bind("used", true)).bind("payload", DbSegmentPublisher.this.jsonMapper.writeValueAsString((Object)segment))).execute();
                    return null;
                }
            });
        }
        catch (Exception e) {
            log.error((Throwable)e, "Exception inserting into DB", new Object[0]);
            throw new RuntimeException(e);
        }
    }
}

