/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.loading;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import io.druid.segment.loading.StorageLocationConfig;
import java.io.File;
import java.util.List;
import org.hibernate.validator.constraints.NotEmpty;

public class SegmentLoaderConfig {
    @JsonProperty
    @NotEmpty
    private List<StorageLocationConfig> locations = null;
    @JsonProperty(value="deleteOnRemove")
    private boolean deleteOnRemove = true;
    @JsonProperty
    private File infoDir = null;

    public List<StorageLocationConfig> getLocations() {
        return this.locations;
    }

    public boolean isDeleteOnRemove() {
        return this.deleteOnRemove;
    }

    public File getInfoDir() {
        if (this.infoDir == null) {
            this.infoDir = new File(this.locations.get(0).getPath(), "info_dir");
        }
        return this.infoDir;
    }

    public SegmentLoaderConfig withLocations(List<StorageLocationConfig> locations) {
        SegmentLoaderConfig retVal = new SegmentLoaderConfig();
        retVal.locations = Lists.newArrayList(locations);
        retVal.deleteOnRemove = this.deleteOnRemove;
        retVal.infoDir = this.infoDir;
        return retVal;
    }

    public String toString() {
        return "SegmentLoaderConfig{locations=" + this.getLocations() + ", deleteOnRemove=" + this.isDeleteOnRemove() + ", infoDir=" + this.getInfoDir() + '}';
    }
}

