/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.loading;

import com.metamx.common.logger.Logger;
import io.druid.segment.IndexIO;
import io.druid.segment.QueryableIndex;
import io.druid.segment.loading.QueryableIndexFactory;
import io.druid.segment.loading.SegmentLoadingException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class MMappedQueryableIndexFactory
implements QueryableIndexFactory {
    private static final Logger log = new Logger(MMappedQueryableIndexFactory.class);

    @Override
    public QueryableIndex factorize(File parentDir) throws SegmentLoadingException {
        try {
            return IndexIO.loadIndex((File)parentDir);
        }
        catch (IOException e) {
            log.warn((Throwable)e, "Got exception!!!! Going to delete parentDir[%s]", new Object[]{parentDir});
            try {
                FileUtils.deleteDirectory((File)parentDir);
            }
            catch (IOException e2) {
                log.error((Throwable)e, "Problem deleting parentDir[%s]", new Object[]{parentDir});
            }
            throw new SegmentLoadingException((Throwable)e, "%s", new Object[]{e.getMessage()});
        }
    }
}

