/*
 * Decompiled with CFR 0.152.
 */
package io.druid.segment.loading;

import com.google.common.io.Files;
import com.metamx.common.MapUtils;
import com.metamx.common.logger.Logger;
import io.druid.segment.loading.DataSegmentPuller;
import io.druid.segment.loading.SegmentLoadingException;
import io.druid.timeline.DataSegment;
import io.druid.utils.CompressionUtils;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public class LocalDataSegmentPuller
implements DataSegmentPuller {
    private static final Logger log = new Logger(LocalDataSegmentPuller.class);

    public void getSegmentFiles(DataSegment segment, File dir) throws SegmentLoadingException {
        File path = this.getFile(segment);
        if (path.isDirectory()) {
            if (path.equals(dir)) {
                log.info("Asked to load [%s] into itself, done!", new Object[]{dir});
                return;
            }
            log.info("Copying files from [%s] to [%s]", new Object[]{path, dir});
            File file = null;
            try {
                File[] files = path.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    file = files[i];
                    Files.copy((File)file, (File)new File(dir, file.getName()));
                }
            }
            catch (IOException e) {
                throw new SegmentLoadingException((Throwable)e, "Unable to copy file[%s].", new Object[]{file});
            }
        }
        if (!path.getName().endsWith(".zip")) {
            throw new SegmentLoadingException("File is not a zip file[%s]", new Object[]{path});
        }
        log.info("Unzipping local file[%s] to [%s]", new Object[]{path, dir});
        try {
            CompressionUtils.unzip((File)path, (File)dir);
        }
        catch (IOException e) {
            throw new SegmentLoadingException((Throwable)e, "Unable to unzip file[%s]", new Object[]{path});
        }
    }

    public long getLastModified(DataSegment segment) throws SegmentLoadingException {
        File file = this.getFile(segment);
        long lastModified = Long.MAX_VALUE;
        if (file.isDirectory()) {
            for (File childFile : file.listFiles()) {
                lastModified = Math.min(childFile.lastModified(), lastModified);
            }
        } else {
            lastModified = file.lastModified();
        }
        return lastModified;
    }

    private File getFile(DataSegment segment) throws SegmentLoadingException {
        Map loadSpec = segment.getLoadSpec();
        File path = new File(MapUtils.getString((Map)loadSpec, (String)"path"));
        if (!path.exists()) {
            throw new SegmentLoadingException("Asked to load path[%s], but it doesn't exist.", new Object[]{path});
        }
        return path;
    }
}

