/*
 * Decompiled with CFR 0.152.
 */
package io.druid.initialization;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Binder;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.util.Modules;
import com.metamx.common.ISE;
import com.metamx.common.logger.Logger;
import io.druid.curator.CuratorModule;
import io.druid.curator.discovery.DiscoveryModule;
import io.druid.guice.AWSModule;
import io.druid.guice.AnnouncerModule;
import io.druid.guice.DataSegmentPusherPullerModule;
import io.druid.guice.DbConnectorModule;
import io.druid.guice.DruidGuiceExtensions;
import io.druid.guice.DruidProcessingModule;
import io.druid.guice.DruidSecondaryModule;
import io.druid.guice.FirehoseModule;
import io.druid.guice.HttpClientModule;
import io.druid.guice.IndexingServiceDiscoveryModule;
import io.druid.guice.JacksonConfigManagerModule;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LifecycleModule;
import io.druid.guice.QueryRunnerFactoryModule;
import io.druid.guice.QueryableModule;
import io.druid.guice.ServerModule;
import io.druid.guice.ServerViewModule;
import io.druid.guice.StorageNodeModule;
import io.druid.guice.annotations.Client;
import io.druid.guice.annotations.Json;
import io.druid.guice.annotations.Smile;
import io.druid.initialization.DruidModule;
import io.druid.jackson.JacksonModule;
import io.druid.server.initialization.ConfigModule;
import io.druid.server.initialization.EmitterModule;
import io.druid.server.initialization.ExtensionsConfig;
import io.druid.server.initialization.JettyServerModule;
import io.druid.server.initialization.PropertiesModule;
import io.druid.server.metrics.MetricsModule;
import io.tesla.aether.Repository;
import io.tesla.aether.TeslaAether;
import io.tesla.aether.internal.DefaultTeslaAether;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.util.filter.DependencyFilterUtils;

public class Initialization {
    private static final Logger log = new Logger(Initialization.class);
    private static final Map<String, URLClassLoader> loadersMap = Maps.newHashMap();
    private static final Set<String> exclusions = Sets.newHashSet((Object[])new String[]{"io.druid", "com.metamx.druid"});
    private static final Map<Class, Set> extensionsMap = Maps.newHashMap();

    public static <T> Set<T> getLoadedModules(Class<T> clazz) {
        Set retVal = extensionsMap.get(clazz);
        if (retVal == null) {
            return Sets.newHashSet();
        }
        return retVal;
    }

    public static synchronized <T> Collection<T> getFromExtensions(ExtensionsConfig config, Class<T> clazz) {
        DefaultTeslaAether aether = Initialization.getAetherClient(config);
        HashSet retVal = Sets.newHashSet();
        if (config.searchCurrentClassloader()) {
            for (String module : ServiceLoader.load(clazz, Initialization.class.getClassLoader())) {
                log.info("Adding local module[%s]", new Object[]{module.getClass()});
                retVal.add(module);
            }
        }
        for (String coordinate : config.getCoordinates()) {
            log.info("Loading extension[%s] for class[%s]", new Object[]{coordinate, clazz.getName()});
            try {
                URLClassLoader loader = Initialization.getClassLoaderForCoordinates((TeslaAether)aether, coordinate);
                ServiceLoader<T> serviceLoader = ServiceLoader.load(clazz, loader);
                for (T module : serviceLoader) {
                    log.info("Adding extension module[%s] for class[%s]", new Object[]{module.getClass(), clazz.getName()});
                    retVal.add(module);
                }
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        extensionsMap.put(clazz, retVal);
        return retVal;
    }

    public static URLClassLoader getClassLoaderForCoordinates(TeslaAether aether, String coordinate) throws DependencyResolutionException, MalformedURLException {
        URLClassLoader loader = loadersMap.get(coordinate);
        if (loader == null) {
            CollectRequest collectRequest = new CollectRequest();
            collectRequest.setRoot(new Dependency((Artifact)new DefaultArtifact(coordinate), "runtime"));
            DependencyRequest dependencyRequest = new DependencyRequest(collectRequest, DependencyFilterUtils.andFilter((DependencyFilter[])new DependencyFilter[]{DependencyFilterUtils.classpathFilter((String[])new String[]{"runtime"}), new DependencyFilter(){

                public boolean accept(DependencyNode node, List<DependencyNode> parents) {
                    if (this.accept(node.getArtifact())) {
                        return false;
                    }
                    for (DependencyNode parent : parents) {
                        if (!this.accept(parent.getArtifact())) continue;
                        return false;
                    }
                    return true;
                }

                private boolean accept(Artifact artifact) {
                    return exclusions.contains(artifact.getGroupId());
                }
            }}));
            List artifacts = aether.resolveArtifacts(dependencyRequest);
            ArrayList urls = Lists.newArrayListWithExpectedSize((int)artifacts.size());
            for (Artifact artifact : artifacts) {
                if (!exclusions.contains(artifact.getGroupId())) {
                    urls.add(artifact.getFile().toURI().toURL());
                    continue;
                }
                log.debug("Skipped Artifact[%s]", new Object[]{artifact});
            }
            for (URL url : urls) {
                log.info("Added URL[%s]", new Object[]{url});
            }
            loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), Initialization.class.getClassLoader());
            loadersMap.put(coordinate, loader);
        }
        return loader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DefaultTeslaAether getAetherClient(ExtensionsConfig config) {
        List<String> remoteUriList = config.getRemoteRepositories();
        ArrayList remoteRepositories = Lists.newArrayList();
        for (String uri : remoteUriList) {
            try {
                URI u = new URI(uri);
                Repository r = new Repository(uri);
                if (u.getUserInfo() != null) {
                    String[] auth = u.getUserInfo().split(":", 2);
                    if (auth.length == 2) {
                        r.setUsername(auth[0]);
                        r.setPassword(auth[1]);
                    } else {
                        log.warn("Invalid credentials in repository URI, expecting [<user>:<password>], got [%s] for [%s]", new Object[]{u.getUserInfo(), uri});
                    }
                }
                remoteRepositories.add(r);
            }
            catch (URISyntaxException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
        if (log.isTraceEnabled() || log.isDebugEnabled()) {
            return new DefaultTeslaAether(config.getLocalRepository(), remoteRepositories.toArray(new Repository[remoteRepositories.size()]));
        }
        PrintStream oldOut = System.out;
        try {
            System.setOut(new PrintStream(new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }

                @Override
                public void write(byte[] b) throws IOException {
                }

                @Override
                public void write(byte[] b, int off, int len) throws IOException {
                }
            }));
            DefaultTeslaAether defaultTeslaAether = new DefaultTeslaAether(config.getLocalRepository(), remoteRepositories.toArray(new Repository[remoteRepositories.size()]));
            return defaultTeslaAether;
        }
        finally {
            System.setOut(oldOut);
        }
    }

    public static Injector makeInjectorWithModules(Injector baseInjector, Iterable<Object> modules) {
        ModuleList defaultModules = new ModuleList(baseInjector);
        defaultModules.addModules(new Object[]{new LifecycleModule(), EmitterModule.class, HttpClientModule.global(), new HttpClientModule("druid.broker.http", Client.class), new CuratorModule(), new AnnouncerModule(), new DruidProcessingModule(), new AWSModule(), new MetricsModule(), new ServerModule(), new StorageNodeModule(), new JettyServerModule(), new QueryableModule(), new QueryRunnerFactoryModule(), new DiscoveryModule(), new ServerViewModule(), new DbConnectorModule(), new JacksonConfigManagerModule(), new IndexingServiceDiscoveryModule(), new DataSegmentPusherPullerModule(), new FirehoseModule()});
        ModuleList actualModules = new ModuleList(baseInjector);
        actualModules.addModule(DruidSecondaryModule.class);
        for (Object module : modules) {
            actualModules.addModule(module);
        }
        ExtensionsConfig config = (ExtensionsConfig)baseInjector.getInstance(ExtensionsConfig.class);
        for (DruidModule module : Initialization.getFromExtensions(config, DruidModule.class)) {
            actualModules.addModule(module);
        }
        return Guice.createInjector((Module[])new Module[]{Modules.override((Iterable)defaultModules.getModules()).with((Iterable)actualModules.getModules())});
    }

    public static Injector makeStartupInjector() {
        return Guice.createInjector((Module[])new Module[]{new DruidGuiceExtensions(), new JacksonModule(), new PropertiesModule("runtime.properties"), new ConfigModule(), new Module(){

            public void configure(Binder binder) {
                binder.bind(DruidSecondaryModule.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.extensions", ExtensionsConfig.class);
            }
        }});
    }

    private static class ModuleList {
        private final Injector baseInjector;
        private final ObjectMapper jsonMapper;
        private final ObjectMapper smileMapper;
        private final List<Module> modules;

        public ModuleList(Injector baseInjector) {
            this.baseInjector = baseInjector;
            this.jsonMapper = (ObjectMapper)baseInjector.getInstance(Key.get(ObjectMapper.class, Json.class));
            this.smileMapper = (ObjectMapper)baseInjector.getInstance(Key.get(ObjectMapper.class, Smile.class));
            this.modules = Lists.newArrayList();
        }

        private List<Module> getModules() {
            return Collections.unmodifiableList(this.modules);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void addModule(Object input) {
            if (input instanceof DruidModule) {
                this.baseInjector.injectMembers(input);
                this.modules.add((Module)this.registerJacksonModules((DruidModule)input));
                return;
            } else if (input instanceof Module) {
                this.baseInjector.injectMembers(input);
                this.modules.add((Module)input);
                return;
            } else {
                if (!(input instanceof Class)) throw new ISE("Unknown module type[%s]", new Object[]{input.getClass()});
                if (DruidModule.class.isAssignableFrom((Class)input)) {
                    this.modules.add((Module)this.registerJacksonModules((DruidModule)this.baseInjector.getInstance((Class)input)));
                    return;
                } else {
                    if (!Module.class.isAssignableFrom((Class)input)) throw new ISE("Class[%s] does not implement %s", new Object[]{input.getClass(), Module.class});
                    this.modules.add((Module)this.baseInjector.getInstance((Class)input));
                    return;
                }
            }
        }

        public void addModules(Object ... object) {
            for (Object o : object) {
                this.addModule(o);
            }
        }

        private DruidModule registerJacksonModules(DruidModule module) {
            for (com.fasterxml.jackson.databind.Module jacksonModule : module.getJacksonModules()) {
                this.jsonMapper.registerModule(jacksonModule);
                this.smileMapper.registerModule(jacksonModule);
            }
            return module;
        }
    }
}

