/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Supplier;
import com.google.inject.Binder;
import com.google.inject.Binding;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.TypeLiteral;
import com.metamx.common.lifecycle.Lifecycle;
import com.metamx.http.client.HttpClient;
import com.metamx.http.client.HttpClientConfig;
import com.metamx.http.client.HttpClientInit;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.annotations.Global;
import java.lang.annotation.Annotation;
import javax.net.ssl.SSLContext;
import javax.validation.constraints.Min;
import org.joda.time.Duration;
import org.joda.time.Period;

public class HttpClientModule
implements Module {
    private final String propertyPrefix;
    private Annotation annotation = null;
    private Class<? extends Annotation> annotationClazz = null;

    public static HttpClientModule global() {
        return new HttpClientModule("druid.global.http", Global.class);
    }

    public HttpClientModule(String propertyPrefix) {
        this.propertyPrefix = propertyPrefix;
    }

    public HttpClientModule(String propertyPrefix, Class<? extends Annotation> annotation) {
        this.propertyPrefix = propertyPrefix;
        this.annotationClazz = annotation;
    }

    public HttpClientModule(String propertyPrefix, Annotation annotation) {
        this.propertyPrefix = propertyPrefix;
        this.annotation = annotation;
    }

    public void configure(Binder binder) {
        if (this.annotation != null) {
            JsonConfigProvider.bind((Binder)binder, (String)this.propertyPrefix, DruidHttpClientConfig.class, (Annotation)this.annotation);
            binder.bind(HttpClient.class).annotatedWith(this.annotation).toProvider((Provider)new HttpClientProvider(this.annotation)).in(LazySingleton.class);
        } else if (this.annotationClazz != null) {
            JsonConfigProvider.bind((Binder)binder, (String)this.propertyPrefix, DruidHttpClientConfig.class, this.annotationClazz);
            binder.bind(HttpClient.class).annotatedWith(this.annotationClazz).toProvider((Provider)new HttpClientProvider(this.annotationClazz)).in(LazySingleton.class);
        } else {
            JsonConfigProvider.bind((Binder)binder, (String)this.propertyPrefix, DruidHttpClientConfig.class);
            binder.bind(HttpClient.class).toProvider((Provider)new HttpClientProvider()).in(LazySingleton.class);
        }
    }

    public static class HttpClientProvider
    implements Provider<HttpClient> {
        private final Key<Supplier<DruidHttpClientConfig>> configKey;
        private final Key<SSLContext> sslContextKey;
        private Provider<Supplier<DruidHttpClientConfig>> configProvider;
        private Provider<Lifecycle> lifecycleProvider;
        private Binding<SSLContext> sslContextBinding;

        public HttpClientProvider() {
            this.configKey = Key.get((TypeLiteral)new TypeLiteral<Supplier<DruidHttpClientConfig>>(){});
            this.sslContextKey = Key.get(SSLContext.class);
        }

        public HttpClientProvider(Annotation annotation) {
            this.configKey = Key.get((TypeLiteral)new TypeLiteral<Supplier<DruidHttpClientConfig>>(){}, (Annotation)annotation);
            this.sslContextKey = Key.get(SSLContext.class, (Annotation)annotation);
        }

        public HttpClientProvider(Class<? extends Annotation> annotation) {
            this.configKey = Key.get((TypeLiteral)new TypeLiteral<Supplier<DruidHttpClientConfig>>(){}, annotation);
            this.sslContextKey = Key.get(SSLContext.class, annotation);
        }

        @Inject
        public void configure(Injector injector) {
            this.configProvider = injector.getProvider(this.configKey);
            this.sslContextBinding = injector.getExistingBinding(this.sslContextKey);
            this.lifecycleProvider = injector.getProvider(Lifecycle.class);
        }

        public HttpClient get() {
            DruidHttpClientConfig config = (DruidHttpClientConfig)((Supplier)this.configProvider.get()).get();
            HttpClientConfig.Builder builder = HttpClientConfig.builder().withNumConnections(config.getNumConnections()).withReadTimeout(config.getReadTimeout());
            if (this.sslContextBinding != null) {
                builder.withSslContext((SSLContext)this.sslContextBinding.getProvider().get());
            }
            return HttpClientInit.createClient((HttpClientConfig)builder.build(), (Lifecycle)((Lifecycle)this.lifecycleProvider.get()));
        }
    }

    public static class DruidHttpClientConfig {
        @JsonProperty
        @Min(value=0L)
        private int numConnections = 5;
        @JsonProperty
        private Period readTimeout = new Period((Object)"PT15M");

        public int getNumConnections() {
            return this.numConnections;
        }

        public Duration getReadTimeout() {
            return this.readTimeout == null ? null : this.readTimeout.toStandardDuration();
        }
    }
}

