/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.metamx.common.concurrent.ExecutorServiceConfig;
import com.metamx.common.logger.Logger;
import com.metamx.emitter.service.ServiceEmitter;
import com.metamx.emitter.service.ServiceMetricEvent;
import io.druid.collections.StupidPool;
import io.druid.concurrent.Execs;
import io.druid.guice.ConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.ManageLifecycle;
import io.druid.guice.annotations.Global;
import io.druid.guice.annotations.Processing;
import io.druid.query.MetricsEmittingExecutorService;
import io.druid.server.DruidProcessingConfig;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicLong;

public class DruidProcessingModule
implements Module {
    private static final Logger log = new Logger(DruidProcessingModule.class);

    public void configure(Binder binder) {
        ConfigProvider.bind((Binder)binder, DruidProcessingConfig.class, (Map)ImmutableMap.of((Object)"base_path", (Object)"druid.processing"));
        binder.bind(ExecutorServiceConfig.class).to(DruidProcessingConfig.class);
    }

    @Provides
    @Processing
    @ManageLifecycle
    public ExecutorService getProcessingExecutorService(ExecutorServiceConfig config, ServiceEmitter emitter) {
        return new MetricsEmittingExecutorService(Executors.newFixedThreadPool(config.getNumThreads(), Execs.makeThreadFactory((String)config.getFormatString())), emitter, new ServiceMetricEvent.Builder());
    }

    @Provides
    @LazySingleton
    @Global
    public StupidPool<ByteBuffer> getIntermediateResultsPool(DruidProcessingConfig config) {
        try {
            Class<?> vmClass = Class.forName("sun.misc.VM");
            Object maxDirectMemoryObj = vmClass.getMethod("maxDirectMemory", new Class[0]).invoke(null, new Object[0]);
            if (maxDirectMemoryObj == null || !(maxDirectMemoryObj instanceof Number)) {
                log.info("Cannot determine maxDirectMemory from[%s]", new Object[]{maxDirectMemoryObj});
            } else {
                long memoryNeeded;
                long maxDirectMemory = ((Number)maxDirectMemoryObj).longValue();
                if (maxDirectMemory < (memoryNeeded = (long)config.intermediateComputeSizeBytes() * (long)(config.getNumThreads() + 1))) {
                    throw new ProvisionException(String.format("Not enough direct memory.  Please adjust -XX:MaxDirectMemorySize or druid.computation.buffer.size: maxDirectMemory[%,d], memoryNeeded[%,d], druid.computation.buffer.size[%,d], numThreads[%,d]", maxDirectMemory, memoryNeeded, config.intermediateComputeSizeBytes(), config.getNumThreads()));
                }
            }
        }
        catch (ClassNotFoundException e) {
            log.info("No VM class, cannot do memory check.", new Object[0]);
        }
        catch (NoSuchMethodException e) {
            log.info("VM.maxDirectMemory doesn't exist, cannot do memory check.", new Object[0]);
        }
        catch (InvocationTargetException e) {
            log.warn((Throwable)e, "static method shouldn't throw this", new Object[0]);
        }
        catch (IllegalAccessException e) {
            log.warn((Throwable)e, "public method, shouldn't throw this", new Object[0]);
        }
        return new IntermediateProcessingBufferPool(config.intermediateComputeSizeBytes());
    }

    private static class IntermediateProcessingBufferPool
    extends StupidPool<ByteBuffer> {
        private static final Logger log = new Logger(IntermediateProcessingBufferPool.class);

        public IntermediateProcessingBufferPool(final int computationBufferSize) {
            super((Supplier)new Supplier<ByteBuffer>(){
                final AtomicLong count = new AtomicLong(0L);

                public ByteBuffer get() {
                    log.info("Allocating new intermediate processing buffer[%,d] of size[%,d]", new Object[]{this.count.getAndIncrement(), computationBufferSize});
                    return ByteBuffer.allocateDirect(computationBufferSize);
                }
            });
        }
    }
}

