/*
 * Decompiled with CFR 0.152.
 */
package io.druid.guice;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;

public class AWSModule
implements Module {
    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)"druid.s3", AWSCredentialsConfig.class);
    }

    @Provides
    @LazySingleton
    public AWSCredentials getAWSCredentials(AWSCredentialsConfig config) {
        return new BasicAWSCredentials(config.getAccessKey(), config.getSecretKey());
    }

    @Provides
    @LazySingleton
    public AmazonEC2 getEc2Client(AWSCredentials credentials) {
        return new AmazonEC2Client(credentials);
    }

    public static class AWSCredentialsConfig {
        @JsonProperty
        private String accessKey = "";
        @JsonProperty
        private String secretKey = "";

        public String getAccessKey() {
            return this.accessKey;
        }

        public String getSecretKey() {
            return this.secretKey;
        }
    }
}

