/*
 * Decompiled with CFR 0.152.
 */
package io.druid.db;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Supplier;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.metamx.common.lifecycle.Lifecycle;
import io.druid.db.DatabaseSegmentManager;
import io.druid.db.DatabaseSegmentManagerConfig;
import io.druid.db.DbConnector;
import io.druid.db.DbTablesConfig;
import org.skife.jdbi.v2.IDBI;

public class DatabaseSegmentManagerProvider
implements Provider<DatabaseSegmentManager> {
    private final ObjectMapper jsonMapper;
    private final Supplier<DatabaseSegmentManagerConfig> config;
    private final Supplier<DbTablesConfig> dbTables;
    private final DbConnector dbConnector;
    private final Lifecycle lifecycle;

    @Inject
    public DatabaseSegmentManagerProvider(ObjectMapper jsonMapper, Supplier<DatabaseSegmentManagerConfig> config, Supplier<DbTablesConfig> dbTables, DbConnector dbConnector, Lifecycle lifecycle) {
        this.jsonMapper = jsonMapper;
        this.config = config;
        this.dbTables = dbTables;
        this.dbConnector = dbConnector;
        this.lifecycle = lifecycle;
    }

    public DatabaseSegmentManager get() {
        this.lifecycle.addHandler(new Lifecycle.Handler(){

            public void start() throws Exception {
                DatabaseSegmentManagerProvider.this.dbConnector.createSegmentTable();
            }

            public void stop() {
            }
        });
        return new DatabaseSegmentManager(this.jsonMapper, this.config, this.dbTables, (IDBI)this.dbConnector.getDBI());
    }
}

