/*
 * Decompiled with CFR 0.152.
 */
package io.druid.curator.inventory;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.common.logger.Logger;
import io.druid.curator.ShutdownNowIgnoringExecutorService;
import io.druid.curator.cache.PathChildrenCacheFactory;
import io.druid.curator.cache.SimplePathChildrenCacheFactory;
import io.druid.curator.inventory.CuratorInventoryManagerStrategy;
import io.druid.curator.inventory.InventoryManagerConfig;
import java.io.IOException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.utils.ZKPaths;

public class CuratorInventoryManager<ContainerClass, InventoryClass> {
    private static final Logger log = new Logger(CuratorInventoryManager.class);
    private final Object lock = new Object();
    private final CuratorFramework curatorFramework;
    private final InventoryManagerConfig config;
    private final CuratorInventoryManagerStrategy<ContainerClass, InventoryClass> strategy;
    private final ConcurrentMap<String, ContainerHolder> containers;
    private final PathChildrenCacheFactory cacheFactory;
    private volatile PathChildrenCache childrenCache;

    public CuratorInventoryManager(CuratorFramework curatorFramework, InventoryManagerConfig config, ExecutorService exec, CuratorInventoryManagerStrategy<ContainerClass, InventoryClass> strategy) {
        this.curatorFramework = curatorFramework;
        this.config = config;
        this.strategy = strategy;
        this.containers = new MapMaker().makeMap();
        this.cacheFactory = new SimplePathChildrenCacheFactory(true, true, new ShutdownNowIgnoringExecutorService(exec));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            if (this.childrenCache != null) {
                return;
            }
            this.childrenCache = this.cacheFactory.make(this.curatorFramework, this.config.getContainerPath());
        }
        this.childrenCache.getListenable().addListener((Object)new ContainerCacheListener());
        try {
            this.childrenCache.start();
        }
        catch (Exception e) {
            Object object2 = this.lock;
            synchronized (object2) {
                try {
                    this.stop();
                }
                catch (IOException e1) {
                    log.error((Throwable)e1, "Exception when stopping InventoryManager that couldn't start.", new Object[0]);
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.childrenCache == null) {
                return;
            }
            this.childrenCache.close();
            this.childrenCache = null;
        }
        for (String containerKey : Lists.newArrayList(this.containers.keySet())) {
            ContainerHolder containerHolder = (ContainerHolder)this.containers.remove(containerKey);
            if (containerHolder == null) {
                log.wtf("!?  Got key[%s] from keySet() but it didn't have a value!?", new Object[]{containerKey});
                continue;
            }
            containerHolder.getCache().close();
        }
    }

    public InventoryManagerConfig getConfig() {
        return this.config;
    }

    public ContainerClass getInventoryValue(String containerKey) {
        ContainerHolder containerHolder = (ContainerHolder)this.containers.get(containerKey);
        return (ContainerClass)(containerHolder == null ? null : containerHolder.getContainer());
    }

    public Iterable<ContainerClass> getInventory() {
        return Iterables.transform(this.containers.values(), (Function)new Function<ContainerHolder, ContainerClass>(){

            public ContainerClass apply(ContainerHolder input) {
                return input.getContainer();
            }
        });
    }

    private class ContainerCacheListener
    implements PathChildrenCacheListener {
        private ContainerCacheListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
            ChildData child = event.getData();
            if (child == null) {
                return;
            }
            String containerKey = ZKPaths.getNodeFromPath((String)child.getPath());
            switch (event.getType()) {
                case CHILD_ADDED: {
                    Object object = CuratorInventoryManager.this.lock;
                    synchronized (object) {
                        Object container = CuratorInventoryManager.this.strategy.deserializeContainer(child.getData());
                        if (CuratorInventoryManager.this.containers.containsKey(containerKey)) {
                            log.error("New node[%s] but there was already one.  That's not good, ignoring new one.", new Object[]{child.getPath()});
                        } else {
                            String inventoryPath = String.format("%s/%s", CuratorInventoryManager.this.config.getInventoryPath(), containerKey);
                            PathChildrenCache inventoryCache = CuratorInventoryManager.this.cacheFactory.make(CuratorInventoryManager.this.curatorFramework, inventoryPath);
                            inventoryCache.getListenable().addListener((Object)new InventoryCacheListener(containerKey, inventoryPath));
                            CuratorInventoryManager.this.containers.put(containerKey, new ContainerHolder(container, inventoryCache));
                            log.info("Starting inventory cache for %s, inventoryPath %s", new Object[]{containerKey, inventoryPath});
                            inventoryCache.start();
                            CuratorInventoryManager.this.strategy.newContainer(container);
                        }
                        break;
                    }
                }
                case CHILD_REMOVED: {
                    Object object = CuratorInventoryManager.this.lock;
                    synchronized (object) {
                        ContainerHolder removed = (ContainerHolder)CuratorInventoryManager.this.containers.remove(containerKey);
                        if (removed == null) {
                            log.warn("Container[%s] removed that wasn't a container!?", new Object[]{child.getPath()});
                            break;
                        }
                        log.info("Closing inventory cache for %s. Also removing listeners.", new Object[]{containerKey});
                        removed.getCache().getListenable().clear();
                        removed.getCache().close();
                        CuratorInventoryManager.this.strategy.deadContainer(removed.getContainer());
                        break;
                    }
                }
                case CHILD_UPDATED: {
                    Object object = CuratorInventoryManager.this.lock;
                    synchronized (object) {
                        Object container = CuratorInventoryManager.this.strategy.deserializeContainer(child.getData());
                        ContainerHolder oldContainer = (ContainerHolder)CuratorInventoryManager.this.containers.get(containerKey);
                        if (oldContainer == null) {
                            log.warn("Container update[%s], but the old container didn't exist!?  Ignoring.", new Object[]{child.getPath()});
                        } else {
                            ContainerHolder containerHolder = oldContainer;
                            synchronized (containerHolder) {
                                oldContainer.setContainer(CuratorInventoryManager.this.strategy.updateContainer(oldContainer.getContainer(), container));
                            }
                        }
                        break;
                    }
                }
            }
        }

        private class InventoryCacheListener
        implements PathChildrenCacheListener {
            private final String containerKey;
            private final String inventoryPath;

            public InventoryCacheListener(String containerKey, String inventoryPath) {
                this.containerKey = containerKey;
                this.inventoryPath = inventoryPath;
                log.info("Created new InventoryCacheListener for %s", new Object[]{inventoryPath});
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
                ChildData child = event.getData();
                if (child == null) {
                    return;
                }
                ContainerHolder holder = (ContainerHolder)CuratorInventoryManager.this.containers.get(this.containerKey);
                if (holder == null) {
                    return;
                }
                String inventoryKey = ZKPaths.getNodeFromPath((String)child.getPath());
                switch (event.getType()) {
                    case CHILD_ADDED: {
                        Object addedInventory = CuratorInventoryManager.this.strategy.deserializeInventory(child.getData());
                        ContainerHolder containerHolder = holder;
                        synchronized (containerHolder) {
                            holder.setContainer(CuratorInventoryManager.this.strategy.addInventory(holder.getContainer(), inventoryKey, addedInventory));
                            break;
                        }
                    }
                    case CHILD_UPDATED: {
                        Object updatedInventory = CuratorInventoryManager.this.strategy.deserializeInventory(child.getData());
                        ContainerHolder containerHolder = holder;
                        synchronized (containerHolder) {
                            holder.setContainer(CuratorInventoryManager.this.strategy.updateInventory(holder.getContainer(), inventoryKey, updatedInventory));
                            break;
                        }
                    }
                    case CHILD_REMOVED: {
                        ContainerHolder containerHolder = holder;
                        synchronized (containerHolder) {
                            holder.setContainer(CuratorInventoryManager.this.strategy.removeInventory(holder.getContainer(), inventoryKey));
                            break;
                        }
                    }
                }
            }
        }
    }

    private class ContainerHolder {
        private final AtomicReference<ContainerClass> container;
        private final PathChildrenCache cache;

        ContainerHolder(ContainerClass container, PathChildrenCache cache) {
            this.container = new AtomicReference(container);
            this.cache = cache;
        }

        private ContainerClass getContainer() {
            return this.container.get();
        }

        private void setContainer(ContainerClass newContainer) {
            this.container.set(newContainer);
        }

        private PathChildrenCache getCache() {
            return this.cache;
        }
    }
}

