/*
 * Decompiled with CFR 0.152.
 */
package io.druid.curator.discovery;

import com.google.inject.Inject;
import io.druid.curator.discovery.ServerDiscoverySelector;
import java.io.IOException;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.ServiceProvider;

public class ServerDiscoveryFactory {
    private final ServiceDiscovery<Void> serviceDiscovery;

    @Inject
    public ServerDiscoveryFactory(ServiceDiscovery<Void> serviceDiscovery) {
        this.serviceDiscovery = serviceDiscovery;
    }

    public ServerDiscoverySelector createSelector(String serviceName) {
        if (serviceName == null) {
            return new ServerDiscoverySelector(new NoopServiceProvider());
        }
        ServiceProvider serviceProvider = this.serviceDiscovery.serviceProviderBuilder().serviceName(serviceName).build();
        return new ServerDiscoverySelector(serviceProvider);
    }

    private static class NoopServiceProvider<T>
    implements ServiceProvider<T> {
        private NoopServiceProvider() {
        }

        public void start() throws Exception {
        }

        public ServiceInstance<T> getInstance() throws Exception {
            return null;
        }

        public void noteError(ServiceInstance<T> tServiceInstance) {
        }

        public void close() throws IOException {
        }
    }
}

