/*
 * Decompiled with CFR 0.152.
 */
package io.druid.curator.announcement;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.metamx.common.IAE;
import com.metamx.common.ISE;
import com.metamx.common.Pair;
import com.metamx.common.lifecycle.LifecycleStart;
import com.metamx.common.lifecycle.LifecycleStop;
import com.metamx.common.logger.Logger;
import io.druid.curator.ShutdownNowIgnoringExecutorService;
import io.druid.curator.cache.PathChildrenCacheFactory;
import io.druid.curator.cache.SimplePathChildrenCacheFactory;
import java.io.Closeable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.CreateBackgroundModeACLable;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.curator.framework.api.SetDataBackgroundVersionable;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

public class Announcer {
    private static final Logger log = new Logger(Announcer.class);
    private final CuratorFramework curator;
    private final PathChildrenCacheFactory factory;
    private final List<Pair<String, byte[]>> toAnnounce = Lists.newArrayList();
    private final List<Pair<String, byte[]>> toUpdate = Lists.newArrayList();
    private final ConcurrentMap<String, PathChildrenCache> listeners = new MapMaker().makeMap();
    private final ConcurrentMap<String, ConcurrentMap<String, byte[]>> announcements = new MapMaker().makeMap();
    private final List<String> parentsIBuilt = new CopyOnWriteArrayList<String>();
    private boolean started = false;

    public Announcer(CuratorFramework curator, ExecutorService exec) {
        this.curator = curator;
        this.factory = new SimplePathChildrenCacheFactory(false, true, new ShutdownNowIgnoringExecutorService(exec));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() {
        List<Pair<String, byte[]>> list = this.toAnnounce;
        synchronized (list) {
            if (this.started) {
                return;
            }
            this.started = true;
            for (Pair<String, byte[]> pair : this.toAnnounce) {
                this.announce((String)pair.lhs, (byte[])pair.rhs);
            }
            this.toAnnounce.clear();
            for (Pair<String, byte[]> pair : this.toUpdate) {
                this.update((String)pair.lhs, (byte[])pair.rhs);
            }
            this.toUpdate.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        List<Pair<String, byte[]>> list = this.toAnnounce;
        synchronized (list) {
            if (!this.started) {
                return;
            }
            this.started = false;
            for (Map.Entry entry : this.listeners.entrySet()) {
                Closeables.closeQuietly((Closeable)((Closeable)entry.getValue()));
            }
            for (Map.Entry entry : this.announcements.entrySet()) {
                String basePath = (String)entry.getKey();
                for (String announcementPath : ((ConcurrentMap)entry.getValue()).keySet()) {
                    this.unannounce(ZKPaths.makePath((String)basePath, (String)announcementPath));
                }
            }
            for (String parent : this.parentsIBuilt) {
                try {
                    this.curator.delete().forPath(parent);
                }
                catch (Exception e) {
                    log.info((Throwable)e, "Unable to delete parent[%s], boooo.", new Object[]{parent});
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void announce(String path, byte[] bytes) {
        Object object;
        List<Pair<String, byte[]>> list = this.toAnnounce;
        synchronized (list) {
            if (!this.started) {
                this.toAnnounce.add((Pair<String, byte[]>)Pair.of((Object)path, (Object)bytes));
                return;
            }
        }
        ZKPaths.PathAndNode pathAndNode = ZKPaths.getPathAndNode((String)path);
        final String parentPath = pathAndNode.getPath();
        boolean buildParentPath = false;
        ConcurrentMap subPaths = (ConcurrentMap)this.announcements.get(parentPath);
        if (subPaths == null) {
            try {
                if (this.curator.checkExists().forPath(parentPath) == null) {
                    buildParentPath = true;
                }
            }
            catch (Exception e) {
                log.debug((Throwable)e, "Problem checking if the parent existed, ignoring.", new Object[0]);
            }
            this.announcements.putIfAbsent(parentPath, new MapMaker().makeMap());
            final ConcurrentMap finalSubPaths = (ConcurrentMap)this.announcements.get(parentPath);
            object = finalSubPaths;
            synchronized (object) {
                if (!this.listeners.containsKey(parentPath)) {
                    final PathChildrenCache cache = this.factory.make(this.curator, parentPath);
                    cache.getListenable().addListener((Object)new PathChildrenCacheListener(){
                        private final AtomicReference<Set<String>> pathsLost = new AtomicReference<Object>(null);

                        public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
                            log.debug("Path[%s] got event[%s]", new Object[]{parentPath, event});
                            switch (event.getType()) {
                                case CHILD_REMOVED: {
                                    ChildData child = event.getData();
                                    ZKPaths.PathAndNode childPath = ZKPaths.getPathAndNode((String)child.getPath());
                                    byte[] value = (byte[])finalSubPaths.get(childPath.getNode());
                                    if (value == null) break;
                                    log.info("Node[%s] dropped, reinstating.", new Object[]{child.getPath()});
                                    Announcer.this.createAnnouncement(child.getPath(), value);
                                    break;
                                }
                                case CONNECTION_LOST: {
                                    HashSet pathsToReinstate = Sets.newHashSet();
                                    for (String node : finalSubPaths.keySet()) {
                                        pathsToReinstate.add(ZKPaths.makePath((String)parentPath, (String)node));
                                    }
                                    for (ChildData data : cache.getCurrentData()) {
                                        pathsToReinstate.remove(data.getPath());
                                    }
                                    if (pathsToReinstate.isEmpty() || this.pathsLost.compareAndSet(null, pathsToReinstate)) break;
                                    log.info("Already had a pathsLost set!?[%s]", new Object[]{parentPath});
                                    break;
                                }
                                case CONNECTION_RECONNECTED: {
                                    Set thePathsLost = this.pathsLost.getAndSet(null);
                                    if (thePathsLost == null) break;
                                    for (String path : thePathsLost) {
                                        log.info("Reinstating [%s]", new Object[]{path});
                                        ZKPaths.PathAndNode split = ZKPaths.getPathAndNode((String)path);
                                        Announcer.this.createAnnouncement(path, (byte[])((ConcurrentMap)Announcer.this.announcements.get(split.getPath())).get(split.getNode()));
                                    }
                                    break;
                                }
                            }
                        }
                    });
                    List<Pair<String, byte[]>> list2 = this.toAnnounce;
                    synchronized (list2) {
                        if (this.started) {
                            if (buildParentPath) {
                                this.createPath(parentPath);
                            }
                            this.startCache(cache);
                            this.listeners.put(parentPath, cache);
                        }
                    }
                }
            }
            subPaths = finalSubPaths;
        }
        boolean created = false;
        object = this.toAnnounce;
        synchronized (object) {
            if (this.started) {
                byte[] oldBytes = subPaths.putIfAbsent(pathAndNode.getNode(), bytes);
                if (oldBytes == null) {
                    created = true;
                } else if (!Arrays.equals(oldBytes, bytes)) {
                    throw new IAE("Cannot reannounce different values under the same path", new Object[0]);
                }
            }
        }
        if (created) {
            try {
                this.createAnnouncement(path, bytes);
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String path, byte[] bytes) {
        List<Pair<String, byte[]>> list = this.toAnnounce;
        synchronized (list) {
            if (!this.started) {
                this.toUpdate.add((Pair<String, byte[]>)Pair.of((Object)path, (Object)bytes));
                return;
            }
        }
        ZKPaths.PathAndNode pathAndNode = ZKPaths.getPathAndNode((String)path);
        String parentPath = pathAndNode.getPath();
        String nodePath = pathAndNode.getNode();
        ConcurrentMap subPaths = (ConcurrentMap)this.announcements.get(parentPath);
        if (subPaths == null || subPaths.get(nodePath) == null) {
            throw new ISE("Cannot update a path[%s] that hasn't been announced!", new Object[]{path});
        }
        List<Pair<String, byte[]>> list2 = this.toAnnounce;
        synchronized (list2) {
            try {
                byte[] oldBytes = (byte[])subPaths.get(nodePath);
                if (!Arrays.equals(oldBytes, bytes)) {
                    subPaths.put(nodePath, bytes);
                    this.updateAnnouncement(path, bytes);
                }
            }
            catch (Exception e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }

    private String createAnnouncement(String path, byte[] value) throws Exception {
        return (String)((PathAndBytesable)((ACLBackgroundPathAndBytesable)((CreateBackgroundModeACLable)this.curator.create().compressed()).withMode(CreateMode.EPHEMERAL)).inBackground()).forPath(path, value);
    }

    private Stat updateAnnouncement(String path, byte[] value) throws Exception {
        return (Stat)((PathAndBytesable)((SetDataBackgroundVersionable)this.curator.setData().compressed()).inBackground()).forPath(path, value);
    }

    public void unannounce(String path) {
        log.info("unannouncing [%s]", new Object[]{path});
        ZKPaths.PathAndNode pathAndNode = ZKPaths.getPathAndNode((String)path);
        String parentPath = pathAndNode.getPath();
        ConcurrentMap subPaths = (ConcurrentMap)this.announcements.get(parentPath);
        if (subPaths == null || subPaths.remove(pathAndNode.getNode()) == null) {
            log.error("Path[%s] not announced, cannot unannounce.", new Object[]{path});
            return;
        }
        try {
            this.curator.delete().guaranteed().forPath(path);
        }
        catch (KeeperException.NoNodeException e) {
            log.info("node[%s] didn't exist anyway...", new Object[]{path});
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void startCache(PathChildrenCache cache) {
        try {
            cache.start();
        }
        catch (Exception e) {
            Closeables.closeQuietly((Closeable)cache);
            throw Throwables.propagate((Throwable)e);
        }
    }

    private void createPath(String parentPath) {
        try {
            this.curator.create().creatingParentsIfNeeded().forPath(parentPath);
            this.parentsIBuilt.add(parentPath);
        }
        catch (Exception e) {
            log.info((Throwable)e, "Problem creating parentPath[%s], someone else created it first?", new Object[]{parentPath});
        }
    }
}

