/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client.selector;

import com.google.common.primitives.Ints;
import com.metamx.common.ISE;
import io.druid.client.selector.QueryableDruidServer;
import io.druid.client.selector.ServerSelectorStrategy;
import io.druid.timeline.DataSegment;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class ConnectionCountServerSelectorStrategy
implements ServerSelectorStrategy {
    private static final Comparator<QueryableDruidServer> comparator = new Comparator<QueryableDruidServer>(){

        @Override
        public int compare(QueryableDruidServer left, QueryableDruidServer right) {
            return Ints.compare((int)left.getClient().getNumOpenConnections(), (int)right.getClient().getNumOpenConnections());
        }
    };

    @Override
    public QueryableDruidServer pick(TreeMap<Integer, Set<QueryableDruidServer>> prioritizedServers, DataSegment segment) {
        Map.Entry<Integer, Set<QueryableDruidServer>> highestPriorityServers = prioritizedServers.pollLastEntry();
        if (highestPriorityServers == null) {
            return null;
        }
        Set<QueryableDruidServer> servers = highestPriorityServers.getValue();
        int size = servers.size();
        switch (size) {
            case 0: {
                throw new ISE("[%s] Something hella weird going on here. We should not be here", new Object[]{segment.getIdentifier()});
            }
            case 1: {
                return highestPriorityServers.getValue().iterator().next();
            }
        }
        return Collections.min(servers, comparator);
    }
}

