/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client.indexing;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.metamx.common.IAE;
import com.metamx.common.ISE;
import com.metamx.http.client.HttpClient;
import com.metamx.http.client.response.HttpResponseHandler;
import com.metamx.http.client.response.InputStreamResponseHandler;
import io.druid.client.indexing.ClientAppendQuery;
import io.druid.client.indexing.ClientConversionQuery;
import io.druid.client.indexing.ClientKillQuery;
import io.druid.client.indexing.IndexingService;
import io.druid.client.selector.Server;
import io.druid.curator.discovery.ServerDiscoverySelector;
import io.druid.guice.annotations.Global;
import io.druid.timeline.DataSegment;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import org.joda.time.Interval;

public class IndexingServiceClient {
    private static final InputStreamResponseHandler RESPONSE_HANDLER = new InputStreamResponseHandler();
    private final HttpClient client;
    private final ObjectMapper jsonMapper;
    private final ServerDiscoverySelector selector;

    @Inject
    public IndexingServiceClient(@Global HttpClient client, ObjectMapper jsonMapper, @IndexingService ServerDiscoverySelector selector) {
        this.client = client;
        this.jsonMapper = jsonMapper;
        this.selector = selector;
    }

    public void mergeSegments(List<DataSegment> segments) {
        Iterator<DataSegment> segmentsIter = segments.iterator();
        if (!segmentsIter.hasNext()) {
            return;
        }
        String dataSource = segmentsIter.next().getDataSource();
        while (segmentsIter.hasNext()) {
            DataSegment next = segmentsIter.next();
            if (dataSource.equals(next.getDataSource())) continue;
            throw new IAE("Cannot merge segments of different dataSources[%s] and [%s]", new Object[]{dataSource, next.getDataSource()});
        }
        this.runQuery(new ClientAppendQuery(dataSource, segments));
    }

    public void killSegments(String dataSource, Interval interval) {
        this.runQuery(new ClientKillQuery(dataSource, interval));
    }

    public void upgradeSegment(DataSegment dataSegment) {
        this.runQuery(new ClientConversionQuery(dataSegment));
    }

    public void upgradeSegments(String dataSource, Interval interval) {
        this.runQuery(new ClientConversionQuery(dataSource, interval));
    }

    private InputStream runQuery(Object queryObject) {
        try {
            return (InputStream)this.client.post(new URL(String.format("%s/task", this.baseUrl()))).setContent("application/json", this.jsonMapper.writeValueAsBytes(queryObject)).go((HttpResponseHandler)RESPONSE_HANDLER).get();
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private String baseUrl() {
        try {
            Server instance = this.selector.pick();
            if (instance == null) {
                throw new ISE("Cannot find instance of indexingService", new Object[0]);
            }
            return String.format("http://%s/druid/indexer/v1", instance.getHost());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

