/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client.cache;

import com.metamx.common.logger.Logger;
import java.nio.ByteBuffer;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

class ByteCountingLRUMap
extends LinkedHashMap<ByteBuffer, byte[]> {
    private static final Logger log = new Logger(ByteCountingLRUMap.class);
    private final boolean logEvictions;
    private final int logEvictionCount;
    private final long sizeInBytes;
    private volatile long numBytes;
    private volatile long evictionCount;

    public ByteCountingLRUMap(long sizeInBytes) {
        this(16, 0, sizeInBytes);
    }

    public ByteCountingLRUMap(int initialSize, int logEvictionCount, long sizeInBytes) {
        super(initialSize, 0.75f, true);
        this.logEvictionCount = logEvictionCount;
        this.sizeInBytes = sizeInBytes;
        this.logEvictions = logEvictionCount != 0;
        this.numBytes = 0L;
        this.evictionCount = 0L;
    }

    public long getNumBytes() {
        return this.numBytes;
    }

    public long getEvictionCount() {
        return this.evictionCount;
    }

    @Override
    public byte[] put(ByteBuffer key, byte[] value) {
        this.numBytes += (long)(key.remaining() + value.length);
        return super.put(key, value);
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<ByteBuffer, byte[]> eldest) {
        if (this.numBytes > this.sizeInBytes) {
            ++this.evictionCount;
            if (this.logEvictions && this.evictionCount % (long)this.logEvictionCount == 0L) {
                log.info("Evicting %,dth element.  Size[%,d], numBytes[%,d], averageSize[%,d]", new Object[]{this.evictionCount, this.size(), this.numBytes, this.numBytes / (long)this.size()});
            }
            this.numBytes -= (long)(eldest.getKey().remaining() + eldest.getValue().length);
            return true;
        }
        return false;
    }

    @Override
    public byte[] remove(Object key) {
        byte[] value = (byte[])super.remove(key);
        if (value != null) {
            this.numBytes -= (long)(((ByteBuffer)key).remaining() + value.length);
        }
        return value;
    }

    @Override
    public Set<ByteBuffer> keySet() {
        return super.keySet();
    }

    @Override
    public void clear() {
        this.numBytes = 0L;
        super.clear();
    }
}

