/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.metamx.emitter.EmittingLogger;
import io.druid.client.DruidServer;
import io.druid.client.ServerInventoryView;
import io.druid.guice.ManageLifecycle;
import io.druid.server.initialization.ZkPathsConfig;
import io.druid.timeline.DataSegment;
import org.apache.curator.framework.CuratorFramework;

@ManageLifecycle
public class SingleServerInventoryView
extends ServerInventoryView<DataSegment> {
    private static final EmittingLogger log = new EmittingLogger(SingleServerInventoryView.class);

    @Inject
    public SingleServerInventoryView(ZkPathsConfig zkPaths, CuratorFramework curator, ObjectMapper jsonMapper) {
        super(log, zkPaths.getAnnouncementsPath(), zkPaths.getServedSegmentsPath(), curator, jsonMapper, new TypeReference<DataSegment>(){});
    }

    @Override
    protected DruidServer addInnerInventory(DruidServer container, String inventoryKey, DataSegment inventory) {
        this.addSingleInventory(container, inventory);
        return container;
    }

    @Override
    protected DruidServer updateInnerInventory(DruidServer container, String inventoryKey, DataSegment inventory) {
        return this.addInnerInventory(container, inventoryKey, inventory);
    }

    @Override
    protected DruidServer removeInnerInventory(DruidServer container, String inventoryKey) {
        this.removeSingleInventory(container, inventoryKey);
        return container;
    }
}

