/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.inject.Inject;
import com.metamx.common.Pair;
import com.metamx.common.guava.BaseSequence;
import com.metamx.common.guava.LazySequence;
import com.metamx.common.guava.Sequence;
import com.metamx.common.guava.Sequences;
import com.metamx.emitter.EmittingLogger;
import io.druid.client.DruidServer;
import io.druid.client.ServerView;
import io.druid.client.TimelineServerView;
import io.druid.client.cache.Cache;
import io.druid.client.selector.QueryableDruidServer;
import io.druid.client.selector.ServerSelector;
import io.druid.guice.annotations.Smile;
import io.druid.query.BySegmentResultValueClass;
import io.druid.query.CacheStrategy;
import io.druid.query.Query;
import io.druid.query.QueryRunner;
import io.druid.query.QueryToolChest;
import io.druid.query.QueryToolChestWarehouse;
import io.druid.query.Result;
import io.druid.query.SegmentDescriptor;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.query.aggregation.MetricManipulationFn;
import io.druid.query.spec.MultipleSpecificSegmentSpec;
import io.druid.query.spec.QuerySegmentSpec;
import io.druid.timeline.DataSegment;
import io.druid.timeline.TimelineObjectHolder;
import io.druid.timeline.VersionedIntervalTimeline;
import io.druid.timeline.partition.PartitionChunk;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executors;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class CachingClusteredClient<T>
implements QueryRunner<T> {
    private static final EmittingLogger log = new EmittingLogger(CachingClusteredClient.class);
    private final QueryToolChestWarehouse warehouse;
    private final TimelineServerView serverView;
    private final Cache cache;
    private final ObjectMapper objectMapper;

    @Inject
    public CachingClusteredClient(QueryToolChestWarehouse warehouse, TimelineServerView serverView, Cache cache, @Smile ObjectMapper objectMapper) {
        this.warehouse = warehouse;
        this.serverView = serverView;
        this.cache = cache;
        this.objectMapper = objectMapper;
        serverView.registerSegmentCallback(Executors.newFixedThreadPool(1, new ThreadFactoryBuilder().setDaemon(true).setNameFormat("CCClient-ServerView-CB-%d").build()), new ServerView.BaseSegmentCallback(){

            @Override
            public ServerView.CallbackAction segmentRemoved(DruidServer server, DataSegment segment) {
                CachingClusteredClient.this.cache.close(segment.getIdentifier());
                return ServerView.CallbackAction.CONTINUE;
            }
        });
    }

    public Sequence<T> run(final Query<T> query) {
        final QueryToolChest toolChest = this.warehouse.getToolChest(query);
        final CacheStrategy strategy = toolChest.getCacheStrategy(query);
        final TreeMap serverSegments = Maps.newTreeMap();
        final ArrayList cachedResults = Lists.newArrayList();
        final HashMap cachePopulatorMap = Maps.newHashMap();
        boolean useCache = Boolean.parseBoolean(query.getContextValue("useCache", "true")) && strategy != null;
        final boolean populateCache = Boolean.parseBoolean(query.getContextValue("populateCache", "true")) && strategy != null;
        final boolean isBySegment = Boolean.parseBoolean(query.getContextValue("bySegment", "false"));
        ImmutableMap.Builder contextBuilder = new ImmutableMap.Builder();
        String priority = query.getContextValue("priority", "0");
        contextBuilder.put((Object)"priority", (Object)priority);
        if (populateCache) {
            contextBuilder.put((Object)"bySegment", (Object)"true");
        }
        contextBuilder.put((Object)"intermediate", (Object)"true");
        final Query rewrittenQuery = query.withOverriddenContext((Map)contextBuilder.build());
        VersionedIntervalTimeline<String, ServerSelector> timeline = this.serverView.getTimeline(query.getDataSource());
        if (timeline == null) {
            return Sequences.empty();
        }
        LinkedHashSet segments = Sets.newLinkedHashSet();
        LinkedList serversLookup = Lists.newLinkedList();
        for (Interval interval : rewrittenQuery.getIntervals()) {
            serversLookup.addAll(timeline.lookup(interval));
        }
        List filteredServersLookup = toolChest.filterSegments(query, (List)serversLookup);
        for (TimelineObjectHolder holder : filteredServersLookup) {
            for (PartitionChunk chunk : holder.getObject()) {
                ServerSelector selector = (ServerSelector)chunk.getObject();
                SegmentDescriptor descriptor = new SegmentDescriptor(holder.getInterval(), (String)holder.getVersion(), chunk.getChunkNumber());
                segments.add(Pair.of((Object)selector, (Object)descriptor));
            }
        }
        byte[] queryCacheKey = strategy != null ? strategy.computeCacheKey(query) : null;
        if (useCache && queryCacheKey != null) {
            HashMap cacheKeys = Maps.newHashMap();
            for (Pair e : segments) {
                cacheKeys.put(e, this.computeSegmentCacheKey(((ServerSelector)e.lhs).getSegment().getIdentifier(), (SegmentDescriptor)e.rhs, queryCacheKey));
            }
            Map<Cache.NamedKey, byte[]> cachedValues = this.cache.getBulk(cacheKeys.values());
            for (Map.Entry entry : cacheKeys.entrySet()) {
                Pair segment = (Pair)entry.getKey();
                Cache.NamedKey segmentCacheKey = (Cache.NamedKey)entry.getValue();
                ServerSelector selector = (ServerSelector)segment.lhs;
                SegmentDescriptor descriptor = (SegmentDescriptor)segment.rhs;
                Interval segmentQueryInterval = descriptor.getInterval();
                byte[] cachedValue = cachedValues.get(segmentCacheKey);
                if (cachedValue != null) {
                    cachedResults.add(Pair.of((Object)segmentQueryInterval.getStart(), (Object)cachedValue));
                    segments.remove(segment);
                    continue;
                }
                String segmentIdentifier = selector.getSegment().getIdentifier();
                cachePopulatorMap.put(String.format("%s_%s", segmentIdentifier, segmentQueryInterval), new CachePopulator(this.cache, this.objectMapper, segmentCacheKey));
            }
        }
        for (Pair segment : segments) {
            QueryableDruidServer queryableDruidServer = ((ServerSelector)segment.lhs).pick();
            if (queryableDruidServer == null) {
                log.error("No servers found for %s?! How can this be?!", new Object[]{segment.rhs});
                continue;
            }
            DruidServer server = queryableDruidServer.getServer();
            List descriptors = (List)serverSegments.get(server);
            if (descriptors == null) {
                descriptors = Lists.newArrayList();
                serverSegments.put(server, descriptors);
            }
            descriptors.add(segment.rhs);
        }
        return new LazySequence(new Supplier<Sequence<T>>(){

            public Sequence<T> get() {
                ArrayList listOfSequences = Lists.newArrayList();
                this.addSequencesFromServer(listOfSequences);
                this.addSequencesFromCache(listOfSequences);
                Collections.sort(listOfSequences, Ordering.natural().onResultOf(Pair.lhsFn()));
                Sequence seq = Sequences.simple((Iterable)Iterables.transform((Iterable)listOfSequences, (Function)Pair.rhsFn()));
                if (strategy == null) {
                    return toolChest.mergeSequences(seq);
                }
                return strategy.mergeSequences(seq);
            }

            private void addSequencesFromCache(ArrayList<Pair<DateTime, Sequence<T>>> listOfSequences) {
                if (strategy == null) {
                    return;
                }
                Function pullFromCacheFunction = strategy.pullFromCache();
                final TypeReference cacheObjectClazz = strategy.getCacheObjectClazz();
                for (Pair cachedResultPair : cachedResults) {
                    final byte[] cachedResult = (byte[])cachedResultPair.rhs;
                    BaseSequence cachedSequence = new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Object, Iterator<Object>>(){

                        public Iterator<Object> make() {
                            try {
                                if (cachedResult.length == 0) {
                                    return Iterators.emptyIterator();
                                }
                                return CachingClusteredClient.this.objectMapper.readValues(CachingClusteredClient.this.objectMapper.getFactory().createParser(cachedResult), cacheObjectClazz);
                            }
                            catch (IOException e) {
                                throw Throwables.propagate((Throwable)e);
                            }
                        }

                        public void cleanup(Iterator<Object> iterFromMake) {
                        }
                    });
                    listOfSequences.add(Pair.of((Object)cachedResultPair.lhs, (Object)Sequences.map((Sequence)cachedSequence, (Function)pullFromCacheFunction)));
                }
            }

            private void addSequencesFromServer(ArrayList<Pair<DateTime, Sequence<T>>> listOfSequences) {
                for (Map.Entry entry : serverSegments.entrySet()) {
                    DruidServer server = (DruidServer)entry.getKey();
                    List descriptors = (List)entry.getValue();
                    QueryRunner clientQueryable = CachingClusteredClient.this.serverView.getQueryRunner(server);
                    if (clientQueryable == null) {
                        log.makeAlert("WTF!? server[%s] doesn't have a client Queryable?", new Object[]{server}).emit();
                        continue;
                    }
                    MultipleSpecificSegmentSpec segmentSpec = new MultipleSpecificSegmentSpec(descriptors);
                    List intervals = segmentSpec.getIntervals();
                    Sequence resultSeqToAdd = !server.isAssignable() || !populateCache || isBySegment ? clientQueryable.run(query.withQuerySegmentSpec((QuerySegmentSpec)segmentSpec)) : toolChest.mergeSequences(Sequences.map((Sequence)clientQueryable.run(rewrittenQuery.withQuerySegmentSpec((QuerySegmentSpec)segmentSpec)), (Function)new Function<Object, Sequence<T>>(){
                        private final Function<T, Object> prepareForCache;
                        {
                            this.prepareForCache = strategy.prepareForCache();
                        }

                        public Sequence<T> apply(Object input) {
                            Result result = (Result)input;
                            BySegmentResultValueClass value = (BySegmentResultValueClass)result.getValue();
                            String segmentIdentifier = value.getSegmentId();
                            List segmentResults = value.getResults();
                            ((CachePopulator)cachePopulatorMap.get(String.format("%s_%s", segmentIdentifier, value.getInterval()))).populate(Iterables.transform((Iterable)segmentResults, this.prepareForCache));
                            return Sequences.simple((Iterable)Iterables.transform((Iterable)segmentResults, (Function)toolChest.makeMetricManipulatorFn(rewrittenQuery, new MetricManipulationFn(){

                                public Object manipulate(AggregatorFactory factory, Object object) {
                                    return factory.deserialize(object);
                                }
                            })));
                        }
                    }));
                    listOfSequences.add(Pair.of((Object)((Interval)intervals.get(0)).getStart(), (Object)resultSeqToAdd));
                }
            }
        });
    }

    private Cache.NamedKey computeSegmentCacheKey(String segmentIdentifier, SegmentDescriptor descriptor, byte[] queryCacheKey) {
        Interval segmentQueryInterval = descriptor.getInterval();
        byte[] versionBytes = descriptor.getVersion().getBytes();
        return new Cache.NamedKey(segmentIdentifier, ByteBuffer.allocate(16 + versionBytes.length + 4 + queryCacheKey.length).putLong(segmentQueryInterval.getStartMillis()).putLong(segmentQueryInterval.getEndMillis()).put(versionBytes).putInt(descriptor.getPartitionNumber()).put(queryCacheKey).array());
    }

    private static class CachePopulator {
        private final Cache cache;
        private final ObjectMapper mapper;
        private final Cache.NamedKey key;

        public CachePopulator(Cache cache, ObjectMapper mapper, Cache.NamedKey key) {
            this.cache = cache;
            this.mapper = mapper;
            this.key = key;
        }

        public void populate(Iterable<Object> results) {
            try {
                ArrayList bytes = Lists.newArrayList();
                int size = 0;
                for (Object result : results) {
                    byte[] array = this.mapper.writeValueAsBytes(result);
                    size += array.length;
                    bytes.add(array);
                }
                byte[] valueBytes = new byte[size];
                int offset = 0;
                for (byte[] array : bytes) {
                    System.arraycopy(array, 0, valueBytes, offset, array.length);
                    offset += array.length;
                }
                this.cache.put(this.key, valueBytes);
            }
            catch (IOException e) {
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

