/*
 * Decompiled with CFR 0.152.
 */
package io.druid.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.metamx.common.ISE;
import com.metamx.emitter.EmittingLogger;
import io.druid.client.DruidServer;
import io.druid.client.ServerInventoryView;
import io.druid.guice.ManageLifecycle;
import io.druid.server.initialization.ZkPathsConfig;
import io.druid.timeline.DataSegment;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.curator.framework.CuratorFramework;

@ManageLifecycle
public class BatchServerInventoryView
extends ServerInventoryView<Set<DataSegment>> {
    private static final EmittingLogger log = new EmittingLogger(BatchServerInventoryView.class);
    final ConcurrentMap<String, Set<DataSegment>> zNodes = new MapMaker().makeMap();

    @Inject
    public BatchServerInventoryView(ZkPathsConfig zkPaths, CuratorFramework curator, ObjectMapper jsonMapper) {
        super(log, zkPaths.getAnnouncementsPath(), zkPaths.getLiveSegmentsPath(), curator, jsonMapper, new TypeReference<Set<DataSegment>>(){});
    }

    @Override
    protected DruidServer addInnerInventory(DruidServer container, String inventoryKey, Set<DataSegment> inventory) {
        this.zNodes.put(inventoryKey, inventory);
        for (DataSegment segment : inventory) {
            this.addSingleInventory(container, segment);
        }
        return container;
    }

    @Override
    protected DruidServer updateInnerInventory(DruidServer container, String inventoryKey, Set<DataSegment> inventory) {
        Set existing = (Set)this.zNodes.get(inventoryKey);
        if (existing == null) {
            throw new ISE("Trying to update an inventoryKey[%s] that didn't exist?!", new Object[]{inventoryKey});
        }
        for (DataSegment segment : Sets.difference(inventory, (Set)existing)) {
            this.addSingleInventory(container, segment);
        }
        for (DataSegment segment : Sets.difference((Set)existing, inventory)) {
            this.removeSingleInventory(container, segment.getIdentifier());
        }
        this.zNodes.put(inventoryKey, inventory);
        return container;
    }

    @Override
    protected DruidServer removeInnerInventory(DruidServer container, String inventoryKey) {
        log.info("Server[%s] removed container[%s]", new Object[]{container.getName(), inventoryKey});
        Set segments = (Set)this.zNodes.remove(inventoryKey);
        if (segments == null) {
            log.warn("Told to remove container[%s], which didn't exist", new Object[]{inventoryKey});
            return container;
        }
        for (DataSegment segment : segments) {
            this.removeSingleInventory(container, segment.getIdentifier());
        }
        return container;
    }
}

