/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma3.mat.extendedset.utilities;

import it.uniroma3.mat.extendedset.ExtendedSet;
import it.uniroma3.mat.extendedset.intset.ConciseSet;
import it.uniroma3.mat.extendedset.wrappers.IntegerSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;

public class CollectionMap<K, I, C extends Collection<I>>
extends LinkedHashMap<K, C> {
    private static final long serialVersionUID = -2613391212228461025L;
    private final C emptySet;

    public CollectionMap(C emptySet) {
        this.emptySet = emptySet;
    }

    @Override
    public CollectionMap<K, I, C> clone() {
        CollectionMap<K, I, C> cloned = new CollectionMap<K, I, C>(this.emptySet);
        cloned.putAll(this);
        if (this.emptySet instanceof Cloneable) {
            for (Map.Entry entry : cloned.entrySet()) {
                try {
                    entry.setValue((Collection)((Collection)entry.getValue()).getClass().getMethod("clone", new Class[0]).invoke(entry.getValue(), new Object[0]));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        } else {
            for (Map.Entry entry : cloned.entrySet()) {
                C copy = this.cloneEmptySet();
                copy.addAll((Collection)entry.getValue());
                entry.setValue(copy);
            }
        }
        return cloned;
    }

    public CollectionMap<K, I, C> empty() {
        return new CollectionMap<K, I, C>(this.emptySet);
    }

    public static <KX, IX, CX extends Collection<IX>, EX extends CX> CollectionMap<KX, IX, CX> newCollectionMap(EX emptySet) {
        return new CollectionMap(emptySet);
    }

    public void mapValueToKeys(Map<I, K> map) {
        for (Map.Entry<I, K> e : map.entrySet()) {
            this.putItem(e.getValue(), e.getKey());
        }
    }

    private C cloneEmptySet() {
        try {
            if (this.emptySet instanceof Cloneable) {
                return (C)((Collection)this.emptySet.getClass().getMethod("clone", new Class[0]).invoke(this.emptySet, new Object[0]));
            }
            return (C)((Collection)this.emptySet.getClass().newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public boolean containsItem(I item) {
        for (Map.Entry e : this.entrySet()) {
            if (!((Collection)e.getValue()).contains(item)) continue;
            return true;
        }
        return false;
    }

    public C putItem(K key, I item) {
        Collection<Object> items = (Collection)this.get(key);
        if (items == null) {
            items = this.cloneEmptySet();
            this.put(key, items);
        }
        items.add(item);
        return (C)items;
    }

    public C putAllItems(K key, Collection<? extends I> c) {
        Collection<Object> items = (Collection)this.get(key);
        if (c == null) {
            items = this.cloneEmptySet();
            this.put(key, items);
        }
        items.addAll(c);
        return (C)items;
    }

    public C removeItem(K key, I item) {
        Collection items = (Collection)this.get(key);
        if (items == null) {
            return null;
        }
        items.remove(item);
        if (items.isEmpty()) {
            this.remove(key);
        }
        return (C)items;
    }

    public C removeAllItems(K key, Collection<? extends I> c) {
        Collection items = (Collection)this.get(key);
        if (items == null) {
            return null;
        }
        items.removeAll(c);
        if (items.isEmpty()) {
            this.remove(key);
        }
        return (C)items;
    }

    public void makeAllCollectionsUnmodifiable() {
        if (this.emptySet instanceof ExtendedSet) {
            for (Map.Entry entry : this.entrySet()) {
                entry.setValue(((ExtendedSet)entry.getValue()).unmodifiable());
            }
        } else if (this.emptySet instanceof List) {
            for (Map.Entry entry : this.entrySet()) {
                entry.setValue(Collections.unmodifiableList((List)entry.getValue()));
            }
        } else if (this.emptySet instanceof Set) {
            for (Map.Entry entry : this.entrySet()) {
                entry.setValue(Collections.unmodifiableSet((Set)entry.getValue()));
            }
        } else if (this.emptySet instanceof SortedSet) {
            for (Map.Entry entry : this.entrySet()) {
                entry.setValue(Collections.unmodifiableSortedSet((SortedSet)entry.getValue()));
            }
        } else {
            for (Map.Entry entry : this.entrySet()) {
                entry.setValue(Collections.unmodifiableCollection((Collection)entry.getValue()));
            }
        }
    }

    public static void main(String[] args) {
        CollectionMap map = CollectionMap.newCollectionMap(new IntegerSet(new ConciseSet()));
        System.out.println(map);
        map.putItem("A", 1);
        System.out.println(map);
        map.putItem("A", 2);
        System.out.println(map);
        map.putItem("B", 3);
        System.out.println(map);
        map.putAllItems("B", Arrays.asList(4, 5, 6));
        System.out.println(map);
        System.out.println(map.containsItem(1));
        System.out.println(map.containsItem(6));
        System.out.println(map.containsItem(7));
        map.removeItem("A", 2);
        System.out.println(map);
        map.removeItem("A", 3);
        System.out.println(map);
        map.removeAllItems("B", Arrays.asList(1, 2, 3, 4, 5));
        System.out.println(map);
    }
}

