/*
 * Decompiled with CFR 0.152.
 */
package it.uniroma3.mat.extendedset;

import it.uniroma3.mat.extendedset.ExtendedSet;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public abstract class AbstractExtendedSet<T>
extends AbstractSet<T>
implements ExtendedSet<T> {
    @Override
    public ExtendedSet<T> intersection(Collection<? extends T> other) {
        Object clone = this.clone();
        clone.retainAll(other);
        return clone;
    }

    @Override
    public ExtendedSet<T> union(Collection<? extends T> other) {
        Object clone = this.clone();
        clone.addAll(other);
        return clone;
    }

    @Override
    public ExtendedSet<T> difference(Collection<? extends T> other) {
        Object clone = this.clone();
        clone.removeAll(other);
        return clone;
    }

    @Override
    public ExtendedSet<T> symmetricDifference(Collection<? extends T> other) {
        ExtendedSet<T> res = this.union(other);
        res.removeAll(this.intersection(other));
        return res;
    }

    @Override
    public ExtendedSet<T> complemented() {
        Object clone = this.clone();
        clone.complement();
        return clone;
    }

    @Override
    public boolean containsAny(Collection<? extends T> other) {
        return other == null || other.isEmpty() || this.intersectionSize(other) > 0;
    }

    @Override
    public boolean containsAtLeast(Collection<? extends T> other, int minElements) {
        if (minElements < 1) {
            throw new IllegalArgumentException();
        }
        return this.intersectionSize(other) >= minElements;
    }

    @Override
    public int intersectionSize(Collection<? extends T> other) {
        if (other == null || other.isEmpty() || this.isEmpty()) {
            return 0;
        }
        return this.intersection(other).size();
    }

    @Override
    public int unionSize(Collection<? extends T> other) {
        return other == null ? this.size() : this.size() + other.size() - this.intersectionSize(other);
    }

    @Override
    public int symmetricDifferenceSize(Collection<? extends T> other) {
        return other == null ? this.size() : this.size() + other.size() - 2 * this.intersectionSize(other);
    }

    @Override
    public int differenceSize(Collection<? extends T> other) {
        return other == null ? this.size() : this.size() - this.intersectionSize(other);
    }

    @Override
    public int complementSize() {
        return this.complemented().size();
    }

    @Override
    public abstract ExtendedSet<T> empty();

    @Override
    public ExtendedSet<T> headSet(T toElement) {
        return new ExtendedSubSet(null, toElement);
    }

    @Override
    public ExtendedSet<T> subSet(T fromElement, T toElement) {
        return new ExtendedSubSet(fromElement, toElement);
    }

    @Override
    public ExtendedSet<T> tailSet(T fromElement) {
        return new ExtendedSubSet(fromElement, null);
    }

    @Override
    public T first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return (T)this.iterator().next();
    }

    @Override
    public T last() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return (T)this.descendingIterator().next();
    }

    @Override
    public ExtendedSet<T> clone() {
        try {
            return (ExtendedSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public abstract double bitmapCompressionRatio();

    @Override
    public abstract double collectionCompressionRatio();

    @Override
    public ExtendedSet.ExtendedIterator<T> descendingIterator() {
        Comparator tmpComp = this.comparator();
        if (tmpComp == null) {
            tmpComp = new Comparator<T>(){

                @Override
                public int compare(T o1, T o2) {
                    return ((Comparable)o1).compareTo(o2);
                }
            };
        }
        final Comparator comp = tmpComp;
        return new ExtendedSet.ExtendedIterator<T>(){
            private final ListIterator<T> itr;
            {
                this.itr = new ArrayList(AbstractExtendedSet.this).listIterator(AbstractExtendedSet.this.size());
            }

            @Override
            public boolean hasNext() {
                return this.itr.hasPrevious();
            }

            @Override
            public T next() {
                return this.itr.previous();
            }

            @Override
            public void skipAllBefore(T element) {
                while (this.itr.hasPrevious()) {
                    int res = comp.compare(this.itr.previous(), element);
                    if (res < 0) {
                        return;
                    }
                    if (res != 0) continue;
                    this.itr.next();
                    return;
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterable<T> descending() {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return AbstractExtendedSet.this.descendingIterator();
            }
        };
    }

    @Override
    public List<? extends ExtendedSet<T>> powerSet() {
        return this.powerSet(1, Integer.MAX_VALUE);
    }

    @Override
    public List<? extends ExtendedSet<T>> powerSet(int min, int max) {
        if (min < 1 || max < min) {
            throw new IllegalArgumentException();
        }
        ArrayList<Object> res = new ArrayList<Object>();
        if (this.size() < min) {
            return res;
        }
        if (this.size() == min) {
            res.add(this.clone());
            return res;
        }
        if (this.size() == min + 1) {
            for (T item : this.descending()) {
                Object set = this.clone();
                set.remove(item);
                res.add(set);
            }
            if (max > min) {
                res.add(this.clone());
            }
            return res;
        }
        ArrayList level = new ArrayList();
        level.add(new ArrayList());
        for (Object item : this) {
            ExtendedSet<T> single = this.empty();
            single.add(item);
            ((List)level.get(0)).add(single);
        }
        if (min == 1) {
            res.addAll((Collection)level.get(0));
        }
        for (int l = 2; !level.isEmpty() && l <= max; ++l) {
            ArrayList newLevel = new ArrayList();
            for (List list : level) {
                for (int i = 0; i < list.size() - 1; ++i) {
                    ArrayList newPrefix = new ArrayList();
                    for (int j = i + 1; j < list.size(); ++j) {
                        ExtendedSet x = ((ExtendedSet)list.get(i)).clone();
                        x.add(((ExtendedSet)list.get(j)).last());
                        newPrefix.add(x);
                        if (l < min) continue;
                        res.add(x);
                    }
                    if (newPrefix.size() <= 1) continue;
                    newLevel.add(newPrefix);
                }
            }
            level = newLevel;
        }
        return res;
    }

    @Override
    public int powerSetSize() {
        return this.isEmpty() ? 0 : (int)Math.pow(2.0, this.size()) - 1;
    }

    @Override
    public int powerSetSize(int min, int max) {
        int i;
        if (min < 1 || max < min) {
            throw new IllegalArgumentException();
        }
        int size = this.size();
        if (size < min) {
            return 0;
        }
        if (size == min) {
            return 1;
        }
        if ((max = Math.min(size, max)) == min && (max == 0 || max == size)) {
            return 1;
        }
        int[] b = new int[size + 1];
        for (i = 0; i <= size; ++i) {
            b[i] = 1;
        }
        for (i = 1; i <= size; ++i) {
            for (int j = i - 1; j > 0; --j) {
                int n = j;
                b[n] = b[n] + b[j - 1];
            }
        }
        int res = 0;
        for (int i2 = min; i2 <= max; ++i2) {
            res += b[i2];
        }
        return res;
    }

    @Override
    public int compareTo(ExtendedSet<T> o) {
        ExtendedSet.ExtendedIterator<T> thisIterator = this.descendingIterator();
        ExtendedSet.ExtendedIterator<T> otherIterator = o.descendingIterator();
        while (thisIterator.hasNext() && otherIterator.hasNext()) {
            Object otherItem;
            Object thisItem = thisIterator.next();
            int res = ((Comparable)thisItem).compareTo(otherItem = otherIterator.next());
            if (res == 0) continue;
            return res;
        }
        return thisIterator.hasNext() ? 1 : (otherIterator.hasNext() ? -1 : 0);
    }

    @Override
    public void fill(T from, T to) {
        ExtendedSet<T> toAdd = this.empty();
        toAdd.add(to);
        toAdd.complement();
        toAdd.add(to);
        ExtendedSet<T> toRemove = this.empty();
        toRemove.add(from);
        toRemove.complement();
        toAdd.removeAll(toRemove);
        this.addAll(toAdd);
    }

    @Override
    public void clear(T from, T to) {
        Iterator itr = this.iterator();
        itr.skipAllBefore(from);
        while (itr.hasNext()) {
            if (((Comparable)itr.next()).compareTo(to) >= 0) continue;
            itr.remove();
        }
    }

    @Override
    public void flip(T e) {
        if (!this.add(e)) {
            this.remove(e);
        }
    }

    @Override
    public T get(int i) {
        ExtendedSet.ExtendedIterator<T> itr;
        int size = this.size();
        if (i < 0 || i >= size) {
            throw new IndexOutOfBoundsException();
        }
        if (i < size / 2) {
            itr = this.iterator();
            for (int j = 0; j <= i - 1; ++j) {
                itr.next();
            }
        } else {
            itr = this.descendingIterator();
            for (int j = size - 1; j >= i + 1; --j) {
                itr.next();
            }
        }
        return (T)itr.next();
    }

    @Override
    public int indexOf(T e) {
        Iterator itr = this.iterator();
        int i = 0;
        while (itr.hasNext()) {
            if (itr.next().equals(e)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public ExtendedSet<T> unmodifiable() {
        return new UnmodifiableExtendedSet();
    }

    @Override
    public abstract ExtendedSet.ExtendedIterator<T> iterator();

    @Override
    public double jaccardSimilarity(ExtendedSet<T> other) {
        if (this.isEmpty() && other.isEmpty()) {
            return 1.0;
        }
        int inters = this.intersectionSize(other);
        return (double)inters / (double)(this.size() + other.size() - inters);
    }

    @Override
    public double jaccardDistance(ExtendedSet<T> other) {
        return 1.0 - this.jaccardSimilarity(other);
    }

    @Override
    public double weightedJaccardSimilarity(ExtendedSet<T> other) {
        if (this.isEmpty() && other.isEmpty()) {
            return 1.0;
        }
        ExtendedSet<T> inters = this.intersection(other);
        double intersSum = 0.0;
        for (Object t : inters) {
            if (t instanceof Integer) {
                intersSum += (double)((Integer)t).intValue();
                continue;
            }
            if (t instanceof Double) {
                intersSum += ((Double)t).doubleValue();
                continue;
            }
            if (t instanceof Float) {
                intersSum += (double)((Float)t).floatValue();
                continue;
            }
            if (t instanceof Byte) {
                intersSum += (double)((Byte)t).byteValue();
                continue;
            }
            if (t instanceof Long) {
                intersSum += (double)((Long)t).longValue();
                continue;
            }
            if (t instanceof Short) {
                intersSum += (double)((Short)t).shortValue();
                continue;
            }
            throw new IllegalArgumentException("A collection of numbers is required");
        }
        ExtendedSet<T> symmetricDiff = this.symmetricDifference(other);
        double symmetricDiffSum = 0.0;
        for (Object t : symmetricDiff) {
            if (t instanceof Integer) {
                symmetricDiffSum += (double)((Integer)t).intValue();
                continue;
            }
            if (t instanceof Double) {
                symmetricDiffSum += ((Double)t).doubleValue();
                continue;
            }
            if (t instanceof Float) {
                symmetricDiffSum += (double)((Float)t).floatValue();
                continue;
            }
            if (t instanceof Byte) {
                symmetricDiffSum += (double)((Byte)t).byteValue();
                continue;
            }
            if (t instanceof Long) {
                symmetricDiffSum += (double)((Long)t).longValue();
                continue;
            }
            if (t instanceof Short) {
                symmetricDiffSum += (double)((Short)t).shortValue();
                continue;
            }
            throw new IllegalArgumentException("A collection of numbers is required");
        }
        return intersSum / (intersSum + symmetricDiffSum);
    }

    @Override
    public double weightedJaccardDistance(ExtendedSet<T> other) {
        return 1.0 - this.weightedJaccardSimilarity(other);
    }

    @Override
    public ExtendedSet<T> convert(Object ... e) {
        if (e == null) {
            return this.empty();
        }
        return this.convert(Arrays.asList(e));
    }

    @Override
    public ExtendedSet<T> convert(Collection<?> c) {
        ExtendedSet<T> res = this.empty();
        res.addAll(c);
        return res;
    }

    @Override
    public String debugInfo() {
        return this.toString();
    }

    protected class ExtendedSubSet
    extends FilteredSet {
        private final T min;
        private final T max;
        private final ExtendedSet<T> range;
        private final Comparator<? super T> localComparator;

        public ExtendedSubSet(T min, T max) {
            Comparator c = AbstractExtendedSet.this.comparator();
            this.localComparator = c != null ? c : new Comparator<T>(){

                @Override
                public int compare(T o1, T o2) {
                    return ((Comparable)o1).compareTo(o2);
                }
            };
            if (min == null && max == null) {
                throw new IllegalArgumentException();
            }
            if (min != null && max != null && this.localComparator.compare(min, max) > 0) {
                throw new IllegalArgumentException("min > max");
            }
            this.min = min;
            this.max = max;
            this.range = AbstractExtendedSet.this.empty();
            if (min != null && max != null) {
                this.range.fill(min, max);
                this.range.remove(max);
            } else if (max != null) {
                this.range.add(max);
                this.range.complement();
            } else {
                this.range.add(min);
                this.range.complement();
            }
        }

        private boolean isInRange(ExtendedSet<T> other) {
            return other.isEmpty() || (this.max == null || this.localComparator.compare(other.last(), this.max) < 0) && (this.min == null || this.localComparator.compare(other.first(), this.min) >= 0);
        }

        private boolean isInRange(Object e) {
            return !(this.max != null && this.localComparator.compare(e, this.max) >= 0 || this.min != null && this.localComparator.compare(e, this.min) < 0);
        }

        private ExtendedSet<T> filter(ExtendedSet<T> toFilter) {
            if (this.isInRange(toFilter)) {
                return toFilter;
            }
            if (this.max != null) {
                return toFilter.intersection(this.range);
            }
            return toFilter.difference(this.range);
        }

        @Override
        protected ExtendedSet<T> raw() {
            return this.filter(AbstractExtendedSet.this);
        }

        @Override
        public ExtendedSet<T> headSet(T toElement) {
            if (this.localComparator.compare(toElement, this.max) > 0) {
                throw new IllegalArgumentException();
            }
            AbstractExtendedSet abstractExtendedSet = AbstractExtendedSet.this;
            abstractExtendedSet.getClass();
            return abstractExtendedSet.new ExtendedSubSet(this.min, toElement);
        }

        @Override
        public ExtendedSet<T> subSet(T fromElement, T toElement) {
            if (this.localComparator.compare(fromElement, this.min) < 0 || this.localComparator.compare(toElement, this.max) > 0) {
                throw new IllegalArgumentException();
            }
            AbstractExtendedSet abstractExtendedSet = AbstractExtendedSet.this;
            abstractExtendedSet.getClass();
            return abstractExtendedSet.new ExtendedSubSet(fromElement, toElement);
        }

        @Override
        public ExtendedSet<T> tailSet(T fromElement) {
            if (this.localComparator.compare(fromElement, this.min) < 0) {
                throw new IllegalArgumentException();
            }
            AbstractExtendedSet abstractExtendedSet = AbstractExtendedSet.this;
            abstractExtendedSet.getClass();
            return abstractExtendedSet.new ExtendedSubSet(fromElement, this.max);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            if (c == null) {
                return false;
            }
            ExtendedSet other = this.convert(c);
            if (!this.isInRange(other)) {
                throw new IllegalArgumentException();
            }
            return AbstractExtendedSet.this.addAll(other);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            if (c == null) {
                return false;
            }
            return AbstractExtendedSet.this.removeAll(this.filter(this.convert(c)));
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            if (c == null) {
                return false;
            }
            ExtendedSet other = this.convert(c);
            if (this.isInRange(AbstractExtendedSet.this)) {
                return AbstractExtendedSet.this.retainAll(other);
            }
            int sizeBefore = AbstractExtendedSet.this.size();
            ExtendedSet res = AbstractExtendedSet.this.intersection(other);
            this.clear();
            AbstractExtendedSet.this.addAll(res);
            return AbstractExtendedSet.this.size() != sizeBefore;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            if (c == null) {
                return false;
            }
            ExtendedSet other = this.convert(c);
            return this.isInRange(other) && AbstractExtendedSet.this.containsAll(other);
        }

        @Override
        public boolean add(T e) {
            if (!this.isInRange(e)) {
                throw new IllegalArgumentException();
            }
            return AbstractExtendedSet.this.add(e);
        }

        @Override
        public void clear() {
            if (this.isInRange(AbstractExtendedSet.this)) {
                AbstractExtendedSet.this.clear();
            } else if (this.max != null) {
                AbstractExtendedSet.this.removeAll(this.range);
            } else {
                AbstractExtendedSet.this.retainAll(this.range);
            }
        }

        @Override
        public boolean contains(Object o) {
            return o != null && this.isInRange(o) && AbstractExtendedSet.this.contains(o);
        }

        @Override
        public boolean remove(Object o) {
            return o != null && this.isInRange(o) && AbstractExtendedSet.this.remove(o);
        }

        @Override
        public int size() {
            if (this.isInRange(AbstractExtendedSet.this)) {
                return AbstractExtendedSet.this.size();
            }
            if (this.max != null) {
                return AbstractExtendedSet.this.intersectionSize(this.range);
            }
            return AbstractExtendedSet.this.differenceSize(this.range);
        }

        @Override
        public void complement() {
            ExtendedSet c = this.complemented();
            this.clear();
            AbstractExtendedSet.this.addAll(c);
        }

        @Override
        public int complementSize() {
            return this.complemented().size();
        }

        @Override
        public ExtendedSet<T> complemented() {
            return this.filter(this.raw().complemented());
        }

        @Override
        public String debugInfo() {
            return String.format("min = %s, max = %s\nmask = %s\nelements = %s", this.min.toString(), this.max.toString(), this.range.debugInfo(), AbstractExtendedSet.this.toString());
        }

        @Override
        public void clear(T from, T to) {
            ExtendedSet toRemove = this.empty();
            toRemove.fill(from, to);
            this.removeAll(toRemove);
        }

        @Override
        public boolean containsAny(Collection<? extends T> other) {
            return AbstractExtendedSet.this.containsAny(this.filter(this.convert(other)));
        }

        @Override
        public boolean containsAtLeast(Collection<? extends T> other, int minElements) {
            return AbstractExtendedSet.this.containsAtLeast(this.filter(this.convert(other)), minElements);
        }

        @Override
        public Iterable<T> descending() {
            return new Iterable<T>(){

                @Override
                public Iterator<T> iterator() {
                    return ExtendedSubSet.this.descendingIterator();
                }
            };
        }

        @Override
        public void fill(T from, T to) {
            if (!this.isInRange(from) || !this.isInRange(to)) {
                throw new IllegalArgumentException();
            }
            AbstractExtendedSet.this.fill(from, to);
        }

        @Override
        public void flip(T e) {
            if (!this.isInRange(e)) {
                throw new IllegalArgumentException();
            }
            AbstractExtendedSet.this.flip(e);
        }

        @Override
        public T get(int i) {
            Object r;
            int minIndex = 0;
            if (this.min != null) {
                minIndex = AbstractExtendedSet.this.indexOf(this.min);
            }
            if (!this.isInRange(r = AbstractExtendedSet.this.get(minIndex + i))) {
                throw new IllegalArgumentException();
            }
            return r;
        }

        @Override
        public int indexOf(T e) {
            if (!this.isInRange(e)) {
                throw new IllegalArgumentException();
            }
            int minIndex = 0;
            if (this.min != null) {
                minIndex = AbstractExtendedSet.this.indexOf(this.min);
            }
            return AbstractExtendedSet.this.indexOf(e) - minIndex;
        }

        @Override
        public ExtendedSet<T> clone() {
            return this.raw();
        }
    }

    protected class UnmodifiableExtendedSet
    extends FilteredSet {
        private static final String UNSUPPORTED_MSG = "The class is read-only!";

        protected UnmodifiableExtendedSet() {
        }

        @Override
        public boolean add(T e) {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }

        @Override
        public boolean addAll(Collection<? extends T> c) {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }

        @Override
        public void clear(T from, T to) {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }

        @Override
        public void fill(T from, T to) {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }

        @Override
        public void complement() {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }

        @Override
        public void flip(T e) {
            throw new UnsupportedOperationException(UNSUPPORTED_MSG);
        }

        @Override
        public ExtendedSet.ExtendedIterator<T> iterator() {
            Iterator itr = AbstractExtendedSet.this.iterator();
            return new ExtendedSet.ExtendedIterator<T>((ExtendedSet.ExtendedIterator)itr){
                final /* synthetic */ ExtendedSet.ExtendedIterator val$itr;
                {
                    this.val$itr = extendedIterator;
                }

                @Override
                public boolean hasNext() {
                    return this.val$itr.hasNext();
                }

                @Override
                public T next() {
                    return this.val$itr.next();
                }

                @Override
                public void skipAllBefore(T element) {
                    this.val$itr.skipAllBefore(element);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException(UnmodifiableExtendedSet.UNSUPPORTED_MSG);
                }
            };
        }

        @Override
        public ExtendedSet.ExtendedIterator<T> descendingIterator() {
            final ExtendedSet.ExtendedIterator itr = AbstractExtendedSet.this.descendingIterator();
            return new ExtendedSet.ExtendedIterator<T>(){

                @Override
                public boolean hasNext() {
                    return itr.hasNext();
                }

                @Override
                public T next() {
                    return itr.next();
                }

                @Override
                public void skipAllBefore(T element) {
                    itr.skipAllBefore(element);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException(UnmodifiableExtendedSet.UNSUPPORTED_MSG);
                }
            };
        }

        private ExtendedSet<T> unmodifiableSubSet(T min, T max) {
            ExtendedSet res;
            ExtendedSet range = AbstractExtendedSet.this.empty();
            if (min != null && max != null) {
                range.fill(min, max);
                range.remove(max);
                res = AbstractExtendedSet.this.intersection(range).unmodifiable();
            } else if (max != null) {
                range.add(max);
                range.complement();
                res = AbstractExtendedSet.this.intersection(range).unmodifiable();
            } else {
                range.add(min);
                range.complement();
                res = AbstractExtendedSet.this.difference(range).unmodifiable();
            }
            return res;
        }

        @Override
        public ExtendedSet<T> headSet(T toElement) {
            return this.unmodifiableSubSet(null, toElement);
        }

        @Override
        public ExtendedSet<T> subSet(T fromElement, T toElement) {
            return this.unmodifiableSubSet(fromElement, toElement);
        }

        @Override
        public ExtendedSet<T> tailSet(T fromElement) {
            return this.unmodifiableSubSet(fromElement, null);
        }

        @Override
        public ExtendedSet<T> unmodifiable() {
            return this;
        }

        @Override
        protected ExtendedSet<T> raw() {
            return AbstractExtendedSet.this;
        }
    }

    protected abstract class FilteredSet
    implements ExtendedSet<T> {
        protected FilteredSet() {
        }

        protected abstract ExtendedSet<T> raw();

        @Override
        public ExtendedSet<T> convert(Collection<?> c) {
            if (c instanceof FilteredSet) {
                this.convert(((FilteredSet)c).raw());
            }
            return this.raw().convert(c);
        }

        @Override
        public ExtendedSet<T> convert(Object ... e) {
            return this.raw().convert(e);
        }

        @Override
        public ExtendedSet<T> clone() {
            return AbstractExtendedSet.this.clone();
        }

        @Override
        public ExtendedSet<T> empty() {
            return AbstractExtendedSet.this.empty();
        }

        @Override
        public Comparator<? super T> comparator() {
            return AbstractExtendedSet.this.comparator();
        }

        @Override
        public ExtendedSet<T> unmodifiable() {
            return this.raw().unmodifiable();
        }

        @Override
        public ExtendedSet.ExtendedIterator<T> iterator() {
            return this.raw().iterator();
        }

        @Override
        public ExtendedSet.ExtendedIterator<T> descendingIterator() {
            return this.raw().descendingIterator();
        }

        @Override
        public boolean isEmpty() {
            return this.raw().isEmpty();
        }

        @Override
        public boolean equals(Object o) {
            return this.raw().equals(o);
        }

        @Override
        public int hashCode() {
            return this.raw().hashCode();
        }

        @Override
        public int compareTo(ExtendedSet<T> o) {
            return this.raw().compareTo(o);
        }

        @Override
        public T first() {
            return this.raw().first();
        }

        @Override
        public T last() {
            return this.raw().last();
        }

        @Override
        public double bitmapCompressionRatio() {
            return this.raw().bitmapCompressionRatio();
        }

        @Override
        public double collectionCompressionRatio() {
            return this.raw().collectionCompressionRatio();
        }

        @Override
        public List<? extends ExtendedSet<T>> powerSet() {
            return this.raw().powerSet();
        }

        @Override
        public List<? extends ExtendedSet<T>> powerSet(int mins, int maxs) {
            return this.raw().powerSet(mins, maxs);
        }

        @Override
        public int powerSetSize() {
            return this.raw().powerSetSize();
        }

        @Override
        public int powerSetSize(int mins, int maxs) {
            return this.raw().powerSetSize(mins, maxs);
        }

        @Override
        public Object[] toArray() {
            return this.raw().toArray();
        }

        @Override
        public <X> X[] toArray(X[] a) {
            return this.raw().toArray(a);
        }

        public String toString() {
            return this.raw().toString();
        }

        @Override
        public ExtendedSet<T> complemented() {
            return this.raw().complemented();
        }

        @Override
        public int complementSize() {
            return this.raw().complementSize();
        }

        @Override
        public int size() {
            return this.raw().size();
        }

        @Override
        public boolean contains(Object o) {
            return this.raw().contains(o);
        }

        @Override
        public Iterable<T> descending() {
            return this.raw().descending();
        }

        @Override
        public String debugInfo() {
            return this.raw().debugInfo();
        }

        @Override
        public T get(int i) {
            return this.raw().get(i);
        }

        @Override
        public int indexOf(T e) {
            return this.raw().indexOf(e);
        }

        @Override
        public double jaccardDistance(ExtendedSet<T> other) {
            return this.raw().jaccardDistance(this.convert(other));
        }

        @Override
        public double jaccardSimilarity(ExtendedSet<T> other) {
            return this.raw().jaccardSimilarity(this.convert(other));
        }

        @Override
        public double weightedJaccardDistance(ExtendedSet<T> other) {
            return this.raw().weightedJaccardDistance(this.convert(other));
        }

        @Override
        public double weightedJaccardSimilarity(ExtendedSet<T> other) {
            return this.raw().weightedJaccardSimilarity(this.convert(other));
        }

        @Override
        public ExtendedSet<T> difference(Collection<? extends T> other) {
            return this.raw().difference(this.convert(other));
        }

        @Override
        public ExtendedSet<T> symmetricDifference(Collection<? extends T> other) {
            return this.raw().symmetricDifference(this.convert(other));
        }

        @Override
        public ExtendedSet<T> intersection(Collection<? extends T> other) {
            return this.raw().intersection(this.convert(other));
        }

        @Override
        public ExtendedSet<T> union(Collection<? extends T> other) {
            return this.raw().union(this.convert(other));
        }

        @Override
        public int intersectionSize(Collection<? extends T> other) {
            return this.raw().intersectionSize(this.convert(other));
        }

        @Override
        public int differenceSize(Collection<? extends T> other) {
            return this.raw().differenceSize(this.convert(other));
        }

        @Override
        public int unionSize(Collection<? extends T> other) {
            return this.raw().unionSize(this.convert(other));
        }

        @Override
        public int symmetricDifferenceSize(Collection<? extends T> other) {
            return this.raw().symmetricDifferenceSize(this.convert(other));
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.raw().containsAll(this.convert(c));
        }

        @Override
        public boolean containsAny(Collection<? extends T> other) {
            return this.raw().containsAny(this.convert(other));
        }

        @Override
        public boolean containsAtLeast(Collection<? extends T> other, int minElements) {
            return this.raw().containsAtLeast(this.convert(other), minElements);
        }
    }
}

