/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import org.skife.jdbi.com.fasterxml.classmate.members.ResolvedMethod;
import org.skife.jdbi.v2.ConcreteStatementContext;
import org.skife.jdbi.v2.GeneratedKeys;
import org.skife.jdbi.v2.Update;
import org.skife.jdbi.v2.exceptions.UnableToCreateStatementException;
import org.skife.jdbi.v2.sqlobject.CustomizingStatementHandler;
import org.skife.jdbi.v2.sqlobject.GetGeneratedKeys;
import org.skife.jdbi.v2.sqlobject.HandleDing;
import org.skife.jdbi.v2.sqlobject.ResultReturnThing;
import org.skife.jdbi.v2.sqlobject.SqlObject;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

class UpdateHandler
extends CustomizingStatementHandler {
    private final String sql;
    private final Returner returner;

    public UpdateHandler(Class<?> sqlObjectType, ResolvedMethod method) {
        super(sqlObjectType, method);
        this.sql = SqlObject.getSql(method.getRawMember().getAnnotation(SqlUpdate.class), method.getRawMember());
        if (method.getRawMember().isAnnotationPresent(GetGeneratedKeys.class)) {
            ResultSetMapper mapper;
            final ResultReturnThing magic = ResultReturnThing.forType(method);
            GetGeneratedKeys ggk = method.getRawMember().getAnnotation(GetGeneratedKeys.class);
            try {
                mapper = ggk.value().newInstance();
            }
            catch (Exception e) {
                throw new UnableToCreateStatementException("Unable to instantiate result set mapper for statement", e);
            }
            this.returner = new Returner(){

                @Override
                public Object value(Update update, HandleDing baton) {
                    GeneratedKeys o = update.executeAndReturnGeneratedKeys(mapper);
                    return magic.result(o, baton);
                }
            };
        } else {
            this.returner = new Returner(){

                @Override
                public Object value(Update update, HandleDing baton) {
                    return update.execute();
                }
            };
        }
    }

    @Override
    public Object invoke(HandleDing h, Object target, Object[] args) {
        Update q = h.getHandle().createStatement(this.sql);
        this.populateSqlObjectData((ConcreteStatementContext)q.getContext());
        this.applyCustomizers(q, args);
        this.applyBinders(q, args);
        return this.returner.value(q, h);
    }

    private static interface Returner {
        public Object value(Update var1, HandleDing var2);
    }
}

