/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.skife.jdbi.com.fasterxml.classmate.MemberResolver;
import org.skife.jdbi.com.fasterxml.classmate.ResolvedType;
import org.skife.jdbi.com.fasterxml.classmate.ResolvedTypeWithMembers;
import org.skife.jdbi.com.fasterxml.classmate.TypeResolver;
import org.skife.jdbi.com.fasterxml.classmate.members.ResolvedMethod;
import org.skife.jdbi.v2.sqlobject.BatchHandler;
import org.skife.jdbi.v2.sqlobject.CloseHandler;
import org.skife.jdbi.v2.sqlobject.CloseInternal;
import org.skife.jdbi.v2.sqlobject.EqualsHandler;
import org.skife.jdbi.v2.sqlobject.GetHandleHelper;
import org.skife.jdbi.v2.sqlobject.HandleDing;
import org.skife.jdbi.v2.sqlobject.Handler;
import org.skife.jdbi.v2.sqlobject.HashCodeHandler;
import org.skife.jdbi.v2.sqlobject.QueryHandler;
import org.skife.jdbi.v2.sqlobject.ResultReturnThing;
import org.skife.jdbi.v2.sqlobject.SqlBatch;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.ToStringHandler;
import org.skife.jdbi.v2.sqlobject.TransactionalHelper;
import org.skife.jdbi.v2.sqlobject.TransmogrifierHelper;
import org.skife.jdbi.v2.sqlobject.UpdateHandler;

class SqlObject
implements InvocationHandler {
    private static final TypeResolver typeResolver = new TypeResolver();
    private static final Map<Method, Handler> mixinHandlers = new HashMap<Method, Handler>();
    private static final ConcurrentMap<Class<?>, Map<Method, Handler>> handlersCache = new ConcurrentHashMap();
    private final Map<Method, Handler> handlers;
    private final HandleDing ding;

    static <T> T buildSqlObject(Class<T> sqlObjectType, HandleDing handle) {
        return (T)Proxy.newProxyInstance(sqlObjectType.getClassLoader(), new Class[]{sqlObjectType, CloseInternal.class}, (InvocationHandler)new SqlObject(SqlObject.buildHandlersFor(sqlObjectType), handle));
    }

    private static Map<Method, Handler> buildHandlersFor(Class<?> sqlObjectType) {
        if (handlersCache.containsKey(sqlObjectType)) {
            return (Map)handlersCache.get(sqlObjectType);
        }
        MemberResolver mr = new MemberResolver(typeResolver);
        ResolvedType sql_object_type = typeResolver.resolve(sqlObjectType);
        ResolvedTypeWithMembers d = mr.resolve(sql_object_type, null, null);
        HashMap<Method, Handler> handlers = new HashMap<Method, Handler>();
        for (ResolvedMethod method : d.getMemberMethods()) {
            Method raw_method = method.getRawMember();
            if (raw_method.isAnnotationPresent(SqlQuery.class)) {
                handlers.put(raw_method, new QueryHandler(sqlObjectType, method, ResultReturnThing.forType(method)));
                continue;
            }
            if (raw_method.isAnnotationPresent(SqlUpdate.class)) {
                handlers.put(raw_method, new UpdateHandler(sqlObjectType, method));
                continue;
            }
            if (raw_method.isAnnotationPresent(SqlBatch.class)) {
                handlers.put(raw_method, new BatchHandler(sqlObjectType, method));
                continue;
            }
            if (method.getName().equals("close") && method.getRawMember().getParameterTypes().length == 0) {
                handlers.put(raw_method, new CloseHandler());
                continue;
            }
            if (mixinHandlers.containsKey(raw_method)) {
                handlers.put(raw_method, mixinHandlers.get(raw_method));
                continue;
            }
            throw new UnsupportedOperationException("Not Yet Implemented!");
        }
        handlers.putAll(CloseInternal.Helper.handlers());
        handlers.putAll(EqualsHandler.handler());
        handlers.putAll(ToStringHandler.handler(sqlObjectType.getName()));
        handlers.putAll(HashCodeHandler.handler());
        handlersCache.putIfAbsent(sqlObjectType, handlers);
        return handlers;
    }

    public SqlObject(Map<Method, Handler> handlers, HandleDing ding) {
        this.handlers = handlers;
        this.ding = ding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            this.ding.retain("top-level");
            Object object = this.handlers.get(method).invoke(this.ding, proxy, args);
            return object;
        }
        finally {
            this.ding.release("top-level");
        }
    }

    public static void close(Object sqlObject) {
        if (!(sqlObject instanceof CloseInternal)) {
            throw new IllegalArgumentException(sqlObject + " is not a sql object");
        }
        CloseInternal closer = (CloseInternal)sqlObject;
        closer.___jdbi_close___();
    }

    static String getSql(SqlQuery q, Method m) {
        if ("  $#@!!@#%  ".equals(q.value())) {
            return m.getName();
        }
        return q.value();
    }

    static String getSql(SqlUpdate q, Method m) {
        if ("  $#@!!@#%  ".equals(q.value())) {
            return m.getName();
        }
        return q.value();
    }

    static String getSql(SqlBatch q, Method m) {
        if ("  $#@!!@#%  ".equals(q.value())) {
            return m.getName();
        }
        return q.value();
    }

    static {
        mixinHandlers.putAll(TransactionalHelper.handlers());
        mixinHandlers.putAll(GetHandleHelper.handlers());
        mixinHandlers.putAll(TransmogrifierHelper.handlers());
    }
}

