/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.skife.jdbi.v2.Cleanables;
import org.skife.jdbi.v2.ResultIterator;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.exceptions.ResultSetException;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

class ResultSetResultIterator<Type>
implements ResultIterator<Type> {
    private final ResultSetMapper<Type> mapper;
    private final SQLStatement jdbiStatement;
    private final ResultSet results;
    private final StatementContext context;
    private volatile boolean alreadyAdvanced = false;
    private volatile int count = 0;
    private volatile boolean hasNext = false;
    private volatile boolean closed = false;

    ResultSetResultIterator(ResultSetMapper<Type> mapper, SQLStatement jdbiStatement, Statement stmt, StatementContext context) throws SQLException {
        this.mapper = mapper;
        this.context = context;
        this.jdbiStatement = jdbiStatement;
        this.results = stmt.getResultSet();
        this.jdbiStatement.addCleanable(Cleanables.forResultSet(this.results));
    }

    @Override
    public void close() {
        this.closed = true;
        this.jdbiStatement.cleanup();
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            return false;
        }
        if (this.alreadyAdvanced) {
            return this.hasNext;
        }
        this.hasNext = this.safeNext();
        if (this.hasNext) {
            this.alreadyAdvanced = true;
        } else {
            this.close();
        }
        return this.hasNext;
    }

    @Override
    public Type next() {
        if (this.closed) {
            throw new IllegalStateException("iterator is closed");
        }
        if (!this.hasNext()) {
            this.close();
            throw new IllegalStateException("No element to advance to");
        }
        try {
            Type Type2 = this.mapper.map(this.count++, this.results, this.context);
            return Type2;
        }
        catch (SQLException e) {
            throw new ResultSetException("Error thrown mapping result set into return type", e, this.context);
        }
        finally {
            this.alreadyAdvanced = this.safeNext();
            if (!this.alreadyAdvanced) {
                this.close();
            }
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Deleting from a result set iterator is not yet supported");
    }

    private boolean safeNext() {
        try {
            return this.results.next();
        }
        catch (SQLException e) {
            throw new ResultSetException("Unable to advance result set", e, this.context);
        }
    }
}

