/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.metamx.common.ISE;
import io.druid.jackson.DefaultObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;

public class Utils {
    private static final ObjectMapper jsonMapper = new DefaultObjectMapper();

    public static <K, V> Map<K, V> zipMap(Iterable<K> keys, Iterable<V> values) {
        HashMap<K, V> retVal = new HashMap<K, V>();
        Iterator<K> keyIter = keys.iterator();
        Iterator<V> valsIter = values.iterator();
        while (keyIter.hasNext()) {
            K key = keyIter.next();
            Preconditions.checkArgument((boolean)valsIter.hasNext(), (String)"keys longer than vals, bad, bad vals.  Broke on key[%s]", (Object[])new Object[]{key});
            retVal.put(key, valsIter.next());
        }
        if (valsIter.hasNext()) {
            throw new ISE("More values[%d] than keys[%d]", new Object[]{retVal.size() + Iterators.size(valsIter), retVal.size()});
        }
        return retVal;
    }

    public static OutputStream makePathAndOutputStream(JobContext job, Path outputPath, boolean deleteExisting) throws IOException {
        FSDataOutputStream retVal;
        FileSystem fs = outputPath.getFileSystem(job.getConfiguration());
        if (fs.exists(outputPath)) {
            if (deleteExisting) {
                fs.delete(outputPath, false);
            } else {
                throw new ISE("outputPath[%s] must not exist.", new Object[]{outputPath});
            }
        }
        if (!FileOutputFormat.getCompressOutput((JobContext)job)) {
            retVal = fs.create(outputPath, false);
        } else {
            Class codecClass = FileOutputFormat.getOutputCompressorClass((JobContext)job, GzipCodec.class);
            CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)job.getConfiguration());
            outputPath = new Path(outputPath.toString() + codec.getDefaultExtension());
            retVal = codec.createOutputStream((OutputStream)fs.create(outputPath, false));
        }
        return retVal;
    }

    public static InputStream openInputStream(JobContext job, Path inputPath) throws IOException {
        return Utils.openInputStream(job, inputPath, inputPath.getFileSystem(job.getConfiguration()));
    }

    public static boolean exists(JobContext job, FileSystem fs, Path inputPath) throws IOException {
        if (!FileOutputFormat.getCompressOutput((JobContext)job)) {
            return fs.exists(inputPath);
        }
        Class codecClass = FileOutputFormat.getOutputCompressorClass((JobContext)job, GzipCodec.class);
        CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)job.getConfiguration());
        return fs.exists(new Path(inputPath.toString() + codec.getDefaultExtension()));
    }

    public static InputStream openInputStream(JobContext job, Path inputPath, FileSystem fileSystem) throws IOException {
        if (!FileOutputFormat.getCompressOutput((JobContext)job)) {
            return fileSystem.open(inputPath);
        }
        Class codecClass = FileOutputFormat.getOutputCompressorClass((JobContext)job, GzipCodec.class);
        CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)job.getConfiguration());
        inputPath = new Path(inputPath.toString() + codec.getDefaultExtension());
        return codec.createInputStream((InputStream)fileSystem.open(inputPath));
    }

    public static Map<String, Object> getStats(JobContext job, Path statsPath) throws IOException {
        FileSystem fs = statsPath.getFileSystem(job.getConfiguration());
        return (Map)jsonMapper.readValue((InputStream)fs.open(statsPath), (TypeReference)new TypeReference<Map<String, Object>>(){});
    }

    public static void storeStats(JobContext job, Path path, Map<String, Object> stats) throws IOException {
        jsonMapper.writeValue(Utils.makePathAndOutputStream(job, path, true), stats);
    }
}

