/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer;

import com.google.api.client.util.Sets;
import com.google.common.base.Throwables;
import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.io.OutputSupplier;
import com.metamx.common.ISE;
import com.metamx.common.logger.Logger;
import io.druid.indexer.HadoopDruidIndexerConfig;
import io.druid.indexer.Jobby;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;

public class JobHelper {
    private static final Logger log = new Logger(JobHelper.class);
    private static final Set<Path> existing = Sets.newHashSet();

    public static void setupClasspath(HadoopDruidIndexerConfig config, Job groupByJob) throws IOException {
        String classpathProperty = System.getProperty("druid.hadoop.internal.classpath");
        if (classpathProperty == null) {
            classpathProperty = System.getProperty("java.class.path");
        }
        String[] jarFiles = classpathProperty.split(File.pathSeparator);
        Configuration conf = groupByJob.getConfiguration();
        final FileSystem fs = FileSystem.get((Configuration)conf);
        Path distributedClassPath = new Path(config.getSchema().getTuningConfig().getWorkingPath(), "classpath");
        if (fs instanceof LocalFileSystem) {
            return;
        }
        for (String jarFilePath : jarFiles) {
            File jarFile = new File(jarFilePath);
            if (!jarFile.getName().endsWith(".jar")) continue;
            final Path hdfsPath = new Path(distributedClassPath, jarFile.getName());
            if (!existing.contains(hdfsPath)) {
                if (jarFile.getName().endsWith("SNAPSHOT.jar") || !fs.exists(hdfsPath)) {
                    log.info("Uploading jar to path[%s]", new Object[]{hdfsPath});
                    ByteStreams.copy((InputSupplier)Files.newInputStreamSupplier((File)jarFile), (OutputSupplier)new OutputSupplier<OutputStream>(){

                        public OutputStream getOutput() throws IOException {
                            return fs.create(hdfsPath);
                        }
                    });
                }
                existing.add(hdfsPath);
            }
            DistributedCache.addFileToClassPath((Path)hdfsPath, (Configuration)conf, (FileSystem)fs);
        }
    }

    public static void injectSystemProperties(Job job) {
        Configuration conf = job.getConfiguration();
        for (String propName : System.getProperties().stringPropertyNames()) {
            if (!propName.startsWith("hadoop.")) continue;
            conf.set(propName.substring("hadoop.".length()), System.getProperty(propName));
        }
    }

    public static void ensurePaths(HadoopDruidIndexerConfig config) {
        try {
            Job job = new Job(new Configuration(), String.format("%s-determine_partitions-%s", config.getDataSource(), config.getIntervals()));
            job.getConfiguration().set("io.sort.record.percent", "0.19");
            JobHelper.injectSystemProperties(job);
            config.addInputPaths(job);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static boolean runJobs(List<Jobby> jobs, HadoopDruidIndexerConfig config) {
        String failedMessage = null;
        for (Jobby job : jobs) {
            if (failedMessage != null || job.run()) continue;
            failedMessage = String.format("Job[%s] failed!", job.getClass());
        }
        if (!config.getSchema().getTuningConfig().isLeaveIntermediate() && (failedMessage == null || config.getSchema().getTuningConfig().isCleanupOnFailure().booleanValue())) {
            Path workingPath = config.makeIntermediatePath();
            log.info("Deleting path[%s]", new Object[]{workingPath});
            try {
                workingPath.getFileSystem(new Configuration()).delete(workingPath, true);
            }
            catch (IOException e) {
                log.error((Throwable)e, "Failed to cleanup path[%s]", new Object[]{workingPath});
            }
        }
        if (failedMessage != null) {
            throw new ISE(failedMessage, new Object[0]);
        }
        return true;
    }
}

