/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.Closeables;
import com.google.common.primitives.Longs;
import com.metamx.common.IAE;
import com.metamx.common.ISE;
import com.metamx.common.guava.CloseQuietly;
import com.metamx.common.logger.Logger;
import io.druid.data.input.InputRow;
import io.druid.data.input.impl.StringInputRowParser;
import io.druid.indexer.Bucket;
import io.druid.indexer.HadoopDruidIndexerConfig;
import io.druid.indexer.HadoopDruidIndexerMapper;
import io.druid.indexer.JobHelper;
import io.druid.indexer.Jobby;
import io.druid.indexer.SortableBytes;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.segment.IndexIO;
import io.druid.segment.IndexMerger;
import io.druid.segment.SegmentUtils;
import io.druid.segment.incremental.IncrementalIndex;
import io.druid.segment.incremental.IncrementalIndexSchema;
import io.druid.timeline.DataSegment;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.s3native.NativeS3FileSystem;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.CombineTextInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class IndexGeneratorJob
implements Jobby {
    private static final Logger log = new Logger(IndexGeneratorJob.class);
    private final HadoopDruidIndexerConfig config;
    private IndexGeneratorStats jobStats;

    public IndexGeneratorJob(HadoopDruidIndexerConfig config) {
        this.config = config;
        this.jobStats = new IndexGeneratorStats();
    }

    public static List<DataSegment> getPublishedSegments(HadoopDruidIndexerConfig config) {
        Configuration conf = new Configuration();
        ObjectMapper jsonMapper = HadoopDruidIndexerConfig.jsonMapper;
        ImmutableList.Builder publishedSegmentsBuilder = ImmutableList.builder();
        for (String propName : System.getProperties().stringPropertyNames()) {
            if (!propName.startsWith("hadoop.")) continue;
            conf.set(propName.substring("hadoop.".length()), System.getProperty(propName));
        }
        Path descriptorInfoDir = config.makeDescriptorInfoDir();
        try {
            FileSystem fs = descriptorInfoDir.getFileSystem(conf);
            for (FileStatus status : fs.listStatus(descriptorInfoDir)) {
                DataSegment segment = (DataSegment)jsonMapper.readValue((InputStream)fs.open(status.getPath()), DataSegment.class);
                publishedSegmentsBuilder.add((Object)segment);
                log.info("Adding segment %s to the list of published segments", new Object[]{segment.getIdentifier()});
            }
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        ImmutableList publishedSegments = publishedSegmentsBuilder.build();
        return publishedSegments;
    }

    public IndexGeneratorStats getJobStats() {
        return this.jobStats;
    }

    @Override
    public boolean run() {
        try {
            Job job = new Job(new Configuration(), String.format("%s-index-generator-%s", this.config.getDataSource(), this.config.getIntervals()));
            job.getConfiguration().set("io.sort.record.percent", "0.23");
            JobHelper.injectSystemProperties(job);
            if (this.config.isCombineText()) {
                job.setInputFormatClass(CombineTextInputFormat.class);
            } else {
                job.setInputFormatClass(TextInputFormat.class);
            }
            job.setMapperClass(IndexGeneratorMapper.class);
            job.setMapOutputValueClass(Text.class);
            SortableBytes.useSortableBytesAsMapOutputKey(job);
            job.setNumReduceTasks(Iterables.size((Iterable)((Iterable)this.config.getAllBuckets().get())));
            job.setPartitionerClass(IndexGeneratorPartitioner.class);
            job.setReducerClass(IndexGeneratorReducer.class);
            job.setOutputKeyClass(BytesWritable.class);
            job.setOutputValueClass(Text.class);
            job.setOutputFormatClass(IndexGeneratorOutputFormat.class);
            FileOutputFormat.setOutputPath((Job)job, (Path)this.config.makeIntermediatePath());
            this.config.addInputPaths(job);
            this.config.addJobProperties(job);
            this.config.intoConfiguration(job);
            JobHelper.setupClasspath(this.config, job);
            job.submit();
            log.info("Job %s submitted, status available at %s", new Object[]{job.getJobName(), job.getTrackingURL()});
            boolean success = job.waitForCompletion(true);
            Counter invalidRowCount = job.getCounters().findCounter((Enum)HadoopDruidIndexerConfig.IndexJobCounters.INVALID_ROW_COUNTER);
            this.jobStats.setInvalidRowCount(invalidRowCount.getValue());
            return success;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static class IndexGeneratorStats {
        private long invalidRowCount = 0L;

        public long getInvalidRowCount() {
            return this.invalidRowCount;
        }

        public void setInvalidRowCount(long invalidRowCount) {
            this.invalidRowCount = invalidRowCount;
        }
    }

    public static class IndexGeneratorOutputFormat
    extends TextOutputFormat {
        public void checkOutputSpecs(JobContext job) throws IOException {
            Path outDir = IndexGeneratorOutputFormat.getOutputPath((JobContext)job);
            if (outDir == null) {
                throw new InvalidJobConfException("Output directory not set.");
            }
        }
    }

    public static class IndexGeneratorReducer
    extends Reducer<BytesWritable, Text, BytesWritable, Text> {
        private HadoopDruidIndexerConfig config;
        private List<String> metricNames = Lists.newArrayList();
        private StringInputRowParser parser;

        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            this.config = HadoopDruidIndexerConfig.fromConfiguration(context.getConfiguration());
            for (AggregatorFactory factory : this.config.getSchema().getDataSchema().getAggregators()) {
                this.metricNames.add(factory.getName().toLowerCase());
            }
            this.parser = this.config.getParser();
        }

        protected void reduce(BytesWritable key, Iterable<Text> values, final Reducer.Context context) throws IOException, InterruptedException {
            File mergedBase;
            SortableBytes keyBytes = SortableBytes.fromBytesWritable(key);
            Bucket bucket = (Bucket)Bucket.fromGroupKey((byte[])keyBytes.getGroupKey()).lhs;
            Interval interval = (Interval)this.config.getGranularitySpec().bucketInterval(bucket.time).get();
            AggregatorFactory[] aggs = this.config.getSchema().getDataSchema().getAggregators();
            IncrementalIndex index = this.makeIncrementalIndex(bucket, aggs);
            File baseFlushFile = File.createTempFile("base", "flush");
            baseFlushFile.delete();
            baseFlushFile.mkdirs();
            TreeSet toMerge = Sets.newTreeSet();
            int indexCount = 0;
            int lineCount = 0;
            int runningTotalLineCount = 0;
            long startTime = System.currentTimeMillis();
            HashSet allDimensionNames = Sets.newHashSet();
            for (Text value : values) {
                context.progress();
                InputRow inputRow = index.getSpatialDimensionRowFormatter().formatRow(this.parser.parse(value.toString()));
                allDimensionNames.addAll(inputRow.getDimensions());
                int numRows = index.add(inputRow);
                ++lineCount;
                if (numRows < this.config.getSchema().getTuningConfig().getRowFlushBoundary()) continue;
                log.info("%,d lines to %,d rows in %,d millis", new Object[]{lineCount - runningTotalLineCount, numRows, System.currentTimeMillis() - startTime});
                runningTotalLineCount = lineCount;
                File file = new File(baseFlushFile, String.format("index%,05d", indexCount));
                toMerge.add(file);
                context.progress();
                IndexMerger.persist((IncrementalIndex)index, (Interval)interval, (File)file, (IndexMerger.ProgressIndicator)new IndexMerger.ProgressIndicator(){

                    public void progress() {
                        context.progress();
                    }
                });
                index = this.makeIncrementalIndex(bucket, aggs);
                startTime = System.currentTimeMillis();
                ++indexCount;
            }
            log.info("%,d lines completed.", new Object[]{lineCount});
            ArrayList indexes = Lists.newArrayListWithCapacity((int)indexCount);
            if (toMerge.size() == 0) {
                if (index.isEmpty()) {
                    throw new IAE("If you try to persist empty indexes you are going to have a bad time", new Object[0]);
                }
                mergedBase = new File(baseFlushFile, "merged");
                IndexMerger.persist((IncrementalIndex)index, (Interval)interval, (File)mergedBase, (IndexMerger.ProgressIndicator)new IndexMerger.ProgressIndicator(){

                    public void progress() {
                        context.progress();
                    }
                });
            } else {
                if (!index.isEmpty()) {
                    File finalFile = new File(baseFlushFile, "final");
                    IndexMerger.persist((IncrementalIndex)index, (Interval)interval, (File)finalFile, (IndexMerger.ProgressIndicator)new IndexMerger.ProgressIndicator(){

                        public void progress() {
                            context.progress();
                        }
                    });
                    toMerge.add(finalFile);
                }
                for (File file : toMerge) {
                    indexes.add(IndexIO.loadIndex((File)file));
                }
                mergedBase = IndexMerger.mergeQueryableIndex((List)indexes, (AggregatorFactory[])aggs, (File)new File(baseFlushFile, "merged"), (IndexMerger.ProgressIndicator)new IndexMerger.ProgressIndicator(){

                    public void progress() {
                        context.progress();
                    }
                });
            }
            this.serializeOutIndex(context, bucket, mergedBase, Lists.newArrayList((Iterable)allDimensionNames));
            for (File file : toMerge) {
                FileUtils.deleteDirectory((File)file);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void serializeOutIndex(Reducer.Context context, Bucket bucket, File mergedBase, List<String> dimensionNames) throws IOException {
            ImmutableMap loadSpec;
            long size;
            FileSystem outputFS;
            FileSystem infoFS;
            Path indexZipFilePath;
            Path indexBasePath;
            Interval interval;
            block23: {
                ZipOutputStream out;
                Exception caughtException;
                block22: {
                    interval = (Interval)this.config.getGranularitySpec().bucketInterval(bucket.time).get();
                    int attemptNumber = context.getTaskAttemptID().getId();
                    FileSystem fileSystem = FileSystem.get((Configuration)context.getConfiguration());
                    indexBasePath = this.config.makeSegmentOutputPath(fileSystem, bucket);
                    indexZipFilePath = new Path(indexBasePath, String.format("index.zip.%s", attemptNumber));
                    infoFS = this.config.makeDescriptorInfoDir().getFileSystem(context.getConfiguration());
                    outputFS = indexBasePath.getFileSystem(context.getConfiguration());
                    outputFS.mkdirs(indexBasePath);
                    caughtException = null;
                    out = null;
                    size = 0L;
                    try {
                        out = new ZipOutputStream(new BufferedOutputStream((OutputStream)outputFS.create(indexZipFilePath), 262144));
                        List<String> filesToCopy = Arrays.asList(mergedBase.list());
                        for (String file : filesToCopy) {
                            size += this.copyFile(context, out, mergedBase, file);
                        }
                        if (caughtException != null) break block22;
                    }
                    catch (Exception e) {
                        caughtException = e;
                        break block23;
                    }
                    finally {
                        if (caughtException != null) {
                            CloseQuietly.close(out);
                            throw Throwables.propagate((Throwable)caughtException);
                        }
                        Closeables.close(out, (boolean)false);
                    }
                    Closeables.close((Closeable)out, (boolean)false);
                    break block23;
                }
                CloseQuietly.close((Closeable)out);
                throw Throwables.propagate((Throwable)caughtException);
            }
            Path finalIndexZipFilePath = new Path(indexBasePath, "index.zip");
            URI indexOutURI = finalIndexZipFilePath.toUri();
            if (outputFS instanceof NativeS3FileSystem) {
                loadSpec = ImmutableMap.of((Object)"type", (Object)"s3_zip", (Object)"bucket", (Object)indexOutURI.getHost(), (Object)"key", (Object)indexOutURI.getPath().substring(1));
            } else if (outputFS instanceof LocalFileSystem) {
                loadSpec = ImmutableMap.of((Object)"type", (Object)"local", (Object)"path", (Object)indexOutURI.getPath());
            } else if (outputFS instanceof DistributedFileSystem) {
                loadSpec = ImmutableMap.of((Object)"type", (Object)"hdfs", (Object)"path", (Object)indexOutURI.getPath());
            } else {
                throw new ISE("Unknown file system[%s]", new Object[]{outputFS.getClass()});
            }
            DataSegment segment = new DataSegment(this.config.getDataSource(), interval, this.config.getSchema().getTuningConfig().getVersion(), (Map)loadSpec, dimensionNames, this.metricNames, this.config.getShardSpec(bucket).getActualSpec(), Integer.valueOf(SegmentUtils.getVersionFromDir((File)mergedBase)), size);
            boolean success = false;
            for (int i = 0; i < 6; ++i) {
                if (this.renameIndexFiles(infoFS, outputFS, indexBasePath, indexZipFilePath, finalIndexZipFilePath, segment)) {
                    log.info("Successfully renamed [%s] to [%s]", new Object[]{indexZipFilePath, finalIndexZipFilePath});
                    success = true;
                    break;
                }
                log.info("Failed to rename [%s] to [%s]", new Object[]{indexZipFilePath, finalIndexZipFilePath});
                try {
                    Thread.sleep(10000L);
                    context.progress();
                    continue;
                }
                catch (InterruptedException e) {
                    throw new ISE("Thread error in retry loop for renaming [%s] to [%s]", new Object[]{indexZipFilePath.toUri().getPath(), finalIndexZipFilePath.toUri().getPath()});
                }
            }
            if (!success) {
                if (!outputFS.exists(indexZipFilePath)) {
                    throw new ISE("File [%s] does not exist after retry loop.", new Object[]{indexZipFilePath.toUri().getPath()});
                }
                if (outputFS.getFileStatus(indexZipFilePath).getLen() == outputFS.getFileStatus(finalIndexZipFilePath).getLen()) {
                    outputFS.delete(indexZipFilePath, true);
                } else {
                    outputFS.delete(finalIndexZipFilePath, true);
                    if (!this.renameIndexFiles(infoFS, outputFS, indexBasePath, indexZipFilePath, finalIndexZipFilePath, segment)) {
                        throw new ISE("Files [%s] and [%s] are different, but still cannot rename after retry loop", new Object[]{indexZipFilePath.toUri().getPath(), finalIndexZipFilePath.toUri().getPath()});
                    }
                }
            }
        }

        private boolean renameIndexFiles(FileSystem intermediateFS, FileSystem outputFS, Path indexBasePath, Path indexZipFilePath, Path finalIndexZipFilePath, DataSegment segment) throws IOException {
            boolean needRename;
            if (outputFS.exists(finalIndexZipFilePath)) {
                FileStatus zipFile = outputFS.getFileStatus(indexZipFilePath);
                FileStatus finalIndexZipFile = outputFS.getFileStatus(finalIndexZipFilePath);
                if (zipFile.getModificationTime() >= finalIndexZipFile.getModificationTime() || zipFile.getLen() != finalIndexZipFile.getLen()) {
                    log.info("File[%s / %s / %sB] existed, but wasn't the same as [%s / %s / %sB]", new Object[]{finalIndexZipFile.getPath(), new DateTime(finalIndexZipFile.getModificationTime()), finalIndexZipFile.getLen(), zipFile.getPath(), new DateTime(zipFile.getModificationTime()), zipFile.getLen()});
                    outputFS.delete(finalIndexZipFilePath, false);
                    needRename = true;
                } else {
                    log.info("File[%s / %s / %sB] existed and will be kept", new Object[]{finalIndexZipFile.getPath(), new DateTime(finalIndexZipFile.getModificationTime()), finalIndexZipFile.getLen()});
                    needRename = false;
                }
            } else {
                needRename = true;
            }
            if (needRename && !outputFS.rename(indexZipFilePath, finalIndexZipFilePath)) {
                return false;
            }
            this.writeSegmentDescriptor(outputFS, segment, new Path(indexBasePath, "descriptor.json"));
            Path descriptorPath = this.config.makeDescriptorInfoPath(segment);
            log.info("Writing descriptor to path[%s]", new Object[]{descriptorPath});
            intermediateFS.mkdirs(descriptorPath.getParent());
            this.writeSegmentDescriptor(intermediateFS, segment, descriptorPath);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeSegmentDescriptor(FileSystem outputFS, DataSegment segment, Path descriptorPath) throws IOException {
            if (outputFS.exists(descriptorPath)) {
                outputFS.delete(descriptorPath, false);
            }
            try (FSDataOutputStream descriptorOut = outputFS.create(descriptorPath);){
                HadoopDruidIndexerConfig.jsonMapper.writeValue((OutputStream)descriptorOut, (Object)segment);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long copyFile(Reducer.Context context, ZipOutputStream out, File mergedBase, String filename) throws IOException {
            this.createNewZipEntry(out, filename);
            long numRead = 0L;
            FileInputStream in = null;
            try {
                int read;
                in = new FileInputStream(new File(mergedBase, filename));
                byte[] buf = new byte[65536];
                while ((read = ((InputStream)in).read(buf)) != -1) {
                    out.write(buf, 0, read);
                    numRead += (long)read;
                    context.progress();
                }
            }
            catch (Throwable throwable) {
                CloseQuietly.close(in);
                throw throwable;
            }
            CloseQuietly.close((Closeable)in);
            out.closeEntry();
            context.progress();
            return numRead;
        }

        private IncrementalIndex makeIncrementalIndex(Bucket theBucket, AggregatorFactory[] aggs) {
            return new IncrementalIndex(new IncrementalIndexSchema.Builder().withMinTimestamp(theBucket.time.getMillis()).withSpatialDimensions(this.config.getSchema().getDataSchema().getParser()).withQueryGranularity(this.config.getSchema().getDataSchema().getGranularitySpec().getQueryGranularity()).withMetrics(aggs).build());
        }

        private void createNewZipEntry(ZipOutputStream out, String name) throws IOException {
            log.info("Creating new ZipEntry[%s]", new Object[]{name});
            out.putNextEntry(new ZipEntry(name));
        }
    }

    public static class IndexGeneratorPartitioner
    extends Partitioner<BytesWritable, Text>
    implements Configurable {
        private Configuration config;

        public int getPartition(BytesWritable bytesWritable, Text text, int numPartitions) {
            ByteBuffer bytes = ByteBuffer.wrap(bytesWritable.getBytes());
            bytes.position(4);
            int shardNum = bytes.getInt();
            if (this.config.get("mapred.job.tracker").equals("local")) {
                return shardNum % numPartitions;
            }
            if (shardNum >= numPartitions) {
                throw new ISE("Not enough partitions, shard[%,d] >= numPartitions[%,d]", new Object[]{shardNum, numPartitions});
            }
            return shardNum;
        }

        public Configuration getConf() {
            return this.config;
        }

        public void setConf(Configuration config) {
            this.config = config;
        }
    }

    public static class IndexGeneratorMapper
    extends HadoopDruidIndexerMapper<BytesWritable, Text> {
        @Override
        protected void innerMap(InputRow inputRow, Text text, Mapper.Context context) throws IOException, InterruptedException {
            Optional<Bucket> bucket = this.getConfig().getBucket(inputRow);
            if (!bucket.isPresent()) {
                throw new ISE("WTF?! No bucket found for row: %s", new Object[]{inputRow});
            }
            context.write((Object)new SortableBytes(((Bucket)bucket.get()).toGroupKey(new byte[0][]), Longs.toByteArray((long)inputRow.getTimestampFromEpoch())).toBytesWritable(), (Object)text);
        }
    }
}

