/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.collect.ImmutableMap;
import io.druid.indexer.HadoopyShardSpec;
import io.druid.indexer.partitions.HashedPartitionsSpec;
import io.druid.indexer.partitions.PartitionsSpec;
import io.druid.segment.indexing.TuningConfig;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;

@JsonTypeName(value="hadoop")
public class HadoopTuningConfig
implements TuningConfig {
    private static final PartitionsSpec defaultPartitionsSpec = HashedPartitionsSpec.makeDefaultHashedPartitionsSpec();
    private static final Map<DateTime, List<HadoopyShardSpec>> defaultShardSpecs = ImmutableMap.of();
    private static final int defaultRowFlushBoundary = 80000;
    private final String workingPath;
    private final String version;
    private final PartitionsSpec partitionsSpec;
    private final Map<DateTime, List<HadoopyShardSpec>> shardSpecs;
    private final int rowFlushBoundary;
    private final boolean leaveIntermediate;
    private final Boolean cleanupOnFailure;
    private final boolean overwriteFiles;
    private final boolean ignoreInvalidRows;
    private final Map<String, String> jobProperties;
    private final boolean combineText;

    public static HadoopTuningConfig makeDefaultTuningConfig() {
        return new HadoopTuningConfig(null, new DateTime().toString(), defaultPartitionsSpec, defaultShardSpecs, 80000, false, true, false, false, null, false);
    }

    @JsonCreator
    public HadoopTuningConfig(@JsonProperty(value="workingPath") String workingPath, @JsonProperty(value="version") String version, @JsonProperty(value="partitionsSpec") PartitionsSpec partitionsSpec, @JsonProperty(value="shardSpecs") Map<DateTime, List<HadoopyShardSpec>> shardSpecs, @JsonProperty(value="rowFlushBoundary") Integer rowFlushBoundary, @JsonProperty(value="leaveIntermediate") boolean leaveIntermediate, @JsonProperty(value="cleanupOnFailure") Boolean cleanupOnFailure, @JsonProperty(value="overwriteFiles") boolean overwriteFiles, @JsonProperty(value="ignoreInvalidRows") boolean ignoreInvalidRows, @JsonProperty(value="jobProperties") Map<String, String> jobProperties, @JsonProperty(value="combineText") boolean combineText) {
        this.workingPath = workingPath == null ? null : workingPath;
        this.version = version == null ? new DateTime().toString() : version;
        this.partitionsSpec = partitionsSpec == null ? defaultPartitionsSpec : partitionsSpec;
        this.shardSpecs = shardSpecs == null ? defaultShardSpecs : shardSpecs;
        this.rowFlushBoundary = rowFlushBoundary == null ? 80000 : rowFlushBoundary;
        this.leaveIntermediate = leaveIntermediate;
        this.cleanupOnFailure = cleanupOnFailure == null ? true : cleanupOnFailure;
        this.overwriteFiles = overwriteFiles;
        this.ignoreInvalidRows = ignoreInvalidRows;
        this.jobProperties = jobProperties == null ? ImmutableMap.of() : ImmutableMap.copyOf(jobProperties);
        this.combineText = combineText;
    }

    @JsonProperty
    public String getWorkingPath() {
        return this.workingPath;
    }

    @JsonProperty
    public String getVersion() {
        return this.version;
    }

    @JsonProperty
    public PartitionsSpec getPartitionsSpec() {
        return this.partitionsSpec;
    }

    @JsonProperty
    public Map<DateTime, List<HadoopyShardSpec>> getShardSpecs() {
        return this.shardSpecs;
    }

    @JsonProperty
    public int getRowFlushBoundary() {
        return this.rowFlushBoundary;
    }

    @JsonProperty
    public boolean isLeaveIntermediate() {
        return this.leaveIntermediate;
    }

    @JsonProperty
    public Boolean isCleanupOnFailure() {
        return this.cleanupOnFailure;
    }

    @JsonProperty
    public boolean isOverwriteFiles() {
        return this.overwriteFiles;
    }

    @JsonProperty
    public boolean isIgnoreInvalidRows() {
        return this.ignoreInvalidRows;
    }

    @JsonProperty
    public Map<String, String> getJobProperties() {
        return this.jobProperties;
    }

    @JsonProperty
    public boolean isCombineText() {
        return this.combineText;
    }

    public HadoopTuningConfig withWorkingPath(String path) {
        return new HadoopTuningConfig(path, this.version, this.partitionsSpec, this.shardSpecs, this.rowFlushBoundary, this.leaveIntermediate, this.cleanupOnFailure, this.overwriteFiles, this.ignoreInvalidRows, this.jobProperties, this.combineText);
    }

    public HadoopTuningConfig withVersion(String ver) {
        return new HadoopTuningConfig(this.workingPath, ver, this.partitionsSpec, this.shardSpecs, this.rowFlushBoundary, this.leaveIntermediate, this.cleanupOnFailure, this.overwriteFiles, this.ignoreInvalidRows, this.jobProperties, this.combineText);
    }

    public HadoopTuningConfig withShardSpecs(Map<DateTime, List<HadoopyShardSpec>> specs) {
        return new HadoopTuningConfig(this.workingPath, this.version, this.partitionsSpec, specs, this.rowFlushBoundary, this.leaveIntermediate, this.cleanupOnFailure, this.overwriteFiles, this.ignoreInvalidRows, this.jobProperties, this.combineText);
    }
}

