/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.metamx.common.Granularity;
import io.druid.data.input.impl.DataSpec;
import io.druid.data.input.impl.InputRowParser;
import io.druid.data.input.impl.StringInputRowParser;
import io.druid.data.input.impl.TimestampSpec;
import io.druid.indexer.HadoopIOConfig;
import io.druid.indexer.HadoopTuningConfig;
import io.druid.indexer.HadoopyShardSpec;
import io.druid.indexer.partitions.PartitionsSpec;
import io.druid.indexer.partitions.SingleDimensionPartitionsSpec;
import io.druid.indexer.rollup.DataRollupSpec;
import io.druid.indexer.updater.DbUpdaterJobSpec;
import io.druid.query.aggregation.AggregatorFactory;
import io.druid.segment.indexing.DataSchema;
import io.druid.segment.indexing.IOConfig;
import io.druid.segment.indexing.IngestionSpec;
import io.druid.segment.indexing.TuningConfig;
import io.druid.segment.indexing.granularity.GranularitySpec;
import io.druid.segment.indexing.granularity.UniformGranularitySpec;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.joda.time.Interval;

public class HadoopIngestionSpec
extends IngestionSpec<HadoopIOConfig, HadoopTuningConfig> {
    private final DataSchema dataSchema;
    private final HadoopIOConfig ioConfig;
    private final HadoopTuningConfig tuningConfig;

    @JsonCreator
    public HadoopIngestionSpec(@JsonProperty(value="dataSchema") DataSchema dataSchema, @JsonProperty(value="ioConfig") HadoopIOConfig ioConfig, @JsonProperty(value="tuningConfig") HadoopTuningConfig tuningConfig, @JsonProperty(value="dataSource") String dataSource, @JsonProperty(value="timestampSpec") TimestampSpec timestampSpec, @JsonProperty(value="dataSpec") DataSpec dataSpec, @JsonProperty(value="granularitySpec") GranularitySpec granularitySpec, @JsonProperty(value="pathSpec") Map<String, Object> pathSpec, @JsonProperty(value="workingPath") String workingPath, @JsonProperty(value="segmentOutputPath") String segmentOutputPath, @JsonProperty(value="version") String version, @JsonProperty(value="partitionsSpec") PartitionsSpec partitionsSpec, @JsonProperty(value="leaveIntermediate") boolean leaveIntermediate, @JsonProperty(value="cleanupOnFailure") Boolean cleanupOnFailure, @JsonProperty(value="shardSpecs") Map<DateTime, List<HadoopyShardSpec>> shardSpecs, @JsonProperty(value="overwriteFiles") boolean overwriteFiles, @JsonProperty(value="rollupSpec") DataRollupSpec rollupSpec, @JsonProperty(value="updaterJobSpec") DbUpdaterJobSpec updaterJobSpec, @JsonProperty(value="ignoreInvalidRows") boolean ignoreInvalidRows, @JsonProperty(value="jobProperties") Map<String, String> jobProperties, @JsonProperty(value="combineText") boolean combineText, @JsonProperty(value="timestampColumn") String timestampColumn, @JsonProperty(value="timestampFormat") String timestampFormat, @JsonProperty(value="intervals") List<Interval> intervals, @JsonProperty(value="segmentGranularity") Granularity segmentGranularity, @JsonProperty(value="partitionDimension") String partitionDimension, @JsonProperty(value="targetPartitionSize") Long targetPartitionSize) {
        super(dataSchema, (IOConfig)ioConfig, (TuningConfig)tuningConfig);
        if (dataSchema != null) {
            this.dataSchema = dataSchema;
            this.ioConfig = ioConfig;
            this.tuningConfig = tuningConfig == null ? HadoopTuningConfig.makeDefaultTuningConfig() : tuningConfig;
        } else {
            PartitionsSpec thePartitionSpec;
            TimestampSpec theTimestampSpec = timestampSpec == null ? new TimestampSpec(timestampColumn, timestampFormat) : timestampSpec;
            ArrayList dimensionExclusions = Lists.newArrayList();
            dimensionExclusions.add(theTimestampSpec.getTimestampColumn());
            if (rollupSpec != null) {
                for (AggregatorFactory aggregatorFactory : rollupSpec.getAggs()) {
                    dimensionExclusions.add(aggregatorFactory.getName());
                }
            }
            if (partitionsSpec != null) {
                Preconditions.checkArgument((partitionDimension == null && targetPartitionSize == null ? 1 : 0) != 0, (Object)"Cannot mix partitionsSpec with partitionDimension/targetPartitionSize");
                thePartitionSpec = partitionsSpec;
            } else {
                thePartitionSpec = new SingleDimensionPartitionsSpec(partitionDimension, targetPartitionSize, null, false);
            }
            GranularitySpec theGranularitySpec = null;
            if (granularitySpec != null) {
                Preconditions.checkArgument((segmentGranularity == null && intervals == null ? 1 : 0) != 0, (Object)"Cannot mix granularitySpec with segmentGranularity/intervals");
                theGranularitySpec = granularitySpec;
                if (rollupSpec != null) {
                    theGranularitySpec = theGranularitySpec.withQueryGranularity(rollupSpec.rollupGranularity);
                }
            } else if (segmentGranularity != null && intervals != null) {
                theGranularitySpec = new UniformGranularitySpec(segmentGranularity, rollupSpec == null ? null : rollupSpec.rollupGranularity, intervals, segmentGranularity);
            }
            this.dataSchema = new DataSchema(dataSource, (InputRowParser)new StringInputRowParser(dataSpec == null ? null : dataSpec.toParseSpec(theTimestampSpec, (List)dimensionExclusions), null, null, null, null), rollupSpec == null ? new AggregatorFactory[]{} : rollupSpec.getAggs().toArray(new AggregatorFactory[rollupSpec.getAggs().size()]), theGranularitySpec);
            this.ioConfig = new HadoopIOConfig(pathSpec, updaterJobSpec, segmentOutputPath);
            this.tuningConfig = new HadoopTuningConfig(workingPath, version, thePartitionSpec, shardSpecs, rollupSpec == null ? 50000 : rollupSpec.rowFlushBoundary, leaveIntermediate, cleanupOnFailure, overwriteFiles, ignoreInvalidRows, jobProperties, combineText);
        }
    }

    @JsonProperty(value="dataSchema")
    public DataSchema getDataSchema() {
        return this.dataSchema;
    }

    @JsonProperty(value="ioConfig")
    public HadoopIOConfig getIOConfig() {
        return this.ioConfig;
    }

    @JsonProperty(value="tuningConfig")
    public HadoopTuningConfig getTuningConfig() {
        return this.tuningConfig;
    }

    public HadoopIngestionSpec withDataSchema(DataSchema schema) {
        return new HadoopIngestionSpec(schema, this.ioConfig, this.tuningConfig, null, null, null, null, null, null, null, null, null, false, null, null, false, null, null, false, null, false, null, null, null, null, null, null);
    }

    public HadoopIngestionSpec withIOConfig(HadoopIOConfig config) {
        return new HadoopIngestionSpec(this.dataSchema, config, this.tuningConfig, null, null, null, null, null, null, null, null, null, false, null, null, false, null, null, false, null, false, null, null, null, null, null, null);
    }

    public HadoopIngestionSpec withTuningConfig(HadoopTuningConfig config) {
        return new HadoopIngestionSpec(this.dataSchema, this.ioConfig, config, null, null, null, null, null, null, null, null, null, false, null, null, false, null, null, false, null, false, null, null, null, null, null, null);
    }
}

