/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.metamx.common.logger.Logger;
import io.druid.indexer.DbUpdaterJob;
import io.druid.indexer.HadoopDruidIndexerConfig;
import io.druid.indexer.IndexGeneratorJob;
import io.druid.indexer.JobHelper;
import io.druid.indexer.Jobby;
import io.druid.timeline.DataSegment;
import java.util.ArrayList;
import java.util.List;

public class HadoopDruidIndexerJob
implements Jobby {
    private static final Logger log = new Logger(HadoopDruidIndexerJob.class);
    private final HadoopDruidIndexerConfig config;
    private final DbUpdaterJob dbUpdaterJob;
    private IndexGeneratorJob indexJob;
    private volatile List<DataSegment> publishedSegments = null;

    @Inject
    public HadoopDruidIndexerJob(HadoopDruidIndexerConfig config) {
        config.verify();
        this.config = config;
        this.dbUpdaterJob = config.isUpdaterJobSpecSet() ? new DbUpdaterJob(config) : null;
    }

    @Override
    public boolean run() {
        ArrayList jobs = Lists.newArrayList();
        JobHelper.ensurePaths(this.config);
        this.indexJob = new IndexGeneratorJob(this.config);
        jobs.add(this.indexJob);
        if (this.dbUpdaterJob != null) {
            jobs.add(this.dbUpdaterJob);
        } else {
            log.info("No updaterJobSpec set, not uploading to database", new Object[0]);
        }
        jobs.add(new Jobby(){

            @Override
            public boolean run() {
                HadoopDruidIndexerJob.this.publishedSegments = IndexGeneratorJob.getPublishedSegments(HadoopDruidIndexerJob.this.config);
                return true;
            }
        });
        JobHelper.runJobs(jobs, this.config);
        return true;
    }

    public List<DataSegment> getPublishedSegments() {
        if (this.publishedSegments == null) {
            throw new IllegalStateException("Job hasn't run yet. No segments have been published yet.");
        }
        return this.publishedSegments;
    }

    public IndexGeneratorJob.IndexGeneratorStats getIndexJobStats() {
        return this.indexJob.getJobStats();
    }
}

