/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.util.Maps;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.inject.Binder;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.metamx.common.guava.FunctionalIterable;
import com.metamx.common.logger.Logger;
import io.druid.common.utils.JodaUtils;
import io.druid.data.input.InputRow;
import io.druid.data.input.impl.StringInputRowParser;
import io.druid.guice.GuiceInjectors;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.annotations.Self;
import io.druid.indexer.Bucket;
import io.druid.indexer.HadoopIngestionSpec;
import io.druid.indexer.HadoopyShardSpec;
import io.druid.indexer.partitions.PartitionsSpec;
import io.druid.indexer.path.PathSpec;
import io.druid.initialization.Initialization;
import io.druid.segment.column.ColumnConfig;
import io.druid.segment.indexing.granularity.GranularitySpec;
import io.druid.server.DruidNode;
import io.druid.timeline.DataSegment;
import io.druid.timeline.partition.ShardSpec;
import io.druid.timeline.partition.ShardSpecLookup;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.mapreduce.Job;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;
import org.joda.time.format.ISODateTimeFormat;

public class HadoopDruidIndexerConfig {
    private static final Logger log = new Logger(HadoopDruidIndexerConfig.class);
    private static final Injector injector;
    public static final String CONFIG_PROPERTY = "druid.indexer.config";
    public static final Charset javaNativeCharset;
    public static final Splitter tabSplitter;
    public static final Joiner tabJoiner;
    public static final ObjectMapper jsonMapper;
    private volatile HadoopIngestionSpec schema;
    private volatile PathSpec pathSpec;
    private volatile ColumnConfig columnConfig;
    private volatile Map<DateTime, ShardSpecLookup> shardSpecLookups = Maps.newHashMap();
    private volatile Map<ShardSpec, HadoopyShardSpec> hadoopShardSpecLookup = Maps.newHashMap();

    public static HadoopDruidIndexerConfig fromSchema(HadoopIngestionSpec schema) {
        return new HadoopDruidIndexerConfig(schema);
    }

    public static HadoopDruidIndexerConfig fromMap(Map<String, Object> argSpec) {
        if (argSpec.containsKey("schema")) {
            return (HadoopDruidIndexerConfig)jsonMapper.convertValue(argSpec, HadoopDruidIndexerConfig.class);
        }
        return new HadoopDruidIndexerConfig((HadoopIngestionSpec)((Object)jsonMapper.convertValue(argSpec, HadoopIngestionSpec.class)));
    }

    public static HadoopDruidIndexerConfig fromFile(File file) {
        try {
            return HadoopDruidIndexerConfig.fromMap((Map)jsonMapper.readValue(file, (TypeReference)new TypeReference<Map<String, Object>>(){}));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static HadoopDruidIndexerConfig fromString(String str) {
        try {
            return HadoopDruidIndexerConfig.fromMap((Map)jsonMapper.readValue(str, (TypeReference)new TypeReference<Map<String, Object>>(){}));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static HadoopDruidIndexerConfig fromConfiguration(Configuration conf) {
        HadoopDruidIndexerConfig retVal = HadoopDruidIndexerConfig.fromString(conf.get(CONFIG_PROPERTY));
        retVal.verify();
        return retVal;
    }

    @JsonCreator
    public HadoopDruidIndexerConfig(@JsonProperty(value="schema") HadoopIngestionSpec schema) {
        this.columnConfig = this.columnConfig;
        this.schema = schema;
        this.pathSpec = (PathSpec)jsonMapper.convertValue(schema.getIOConfig().getPathSpec(), PathSpec.class);
        for (Map.Entry<DateTime, List<HadoopyShardSpec>> entry : schema.getTuningConfig().getShardSpecs().entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
            ShardSpec actualSpec = entry.getValue().get(0).getActualSpec();
            this.shardSpecLookups.put(entry.getKey(), actualSpec.getLookup(Lists.transform(entry.getValue(), (Function)new Function<HadoopyShardSpec, ShardSpec>(){

                public ShardSpec apply(HadoopyShardSpec input) {
                    return input.getActualSpec();
                }
            })));
            for (HadoopyShardSpec hadoopyShardSpec : entry.getValue()) {
                this.hadoopShardSpecLookup.put(hadoopyShardSpec.getActualSpec(), hadoopyShardSpec);
            }
        }
    }

    @JsonProperty
    public HadoopIngestionSpec getSchema() {
        return this.schema;
    }

    public ColumnConfig getColumnConfig() {
        return this.columnConfig;
    }

    public String getDataSource() {
        return this.schema.getDataSchema().getDataSource();
    }

    public GranularitySpec getGranularitySpec() {
        return this.schema.getDataSchema().getGranularitySpec();
    }

    public void setGranularitySpec(GranularitySpec granularitySpec) {
        this.schema = this.schema.withDataSchema(this.schema.getDataSchema().withGranularitySpec(granularitySpec));
        this.pathSpec = (PathSpec)jsonMapper.convertValue(this.schema.getIOConfig().getPathSpec(), PathSpec.class);
    }

    public PartitionsSpec getPartitionsSpec() {
        return this.schema.getTuningConfig().getPartitionsSpec();
    }

    public boolean isOverwriteFiles() {
        return this.schema.getTuningConfig().isOverwriteFiles();
    }

    public boolean isIgnoreInvalidRows() {
        return this.schema.getTuningConfig().isIgnoreInvalidRows();
    }

    public void setVersion(String version) {
        this.schema = this.schema.withTuningConfig(this.schema.getTuningConfig().withVersion(version));
        this.pathSpec = (PathSpec)jsonMapper.convertValue(this.schema.getIOConfig().getPathSpec(), PathSpec.class);
    }

    public void setShardSpecs(Map<DateTime, List<HadoopyShardSpec>> shardSpecs) {
        this.schema = this.schema.withTuningConfig(this.schema.getTuningConfig().withShardSpecs(shardSpecs));
        this.pathSpec = (PathSpec)jsonMapper.convertValue(this.schema.getIOConfig().getPathSpec(), PathSpec.class);
    }

    public Optional<List<Interval>> getIntervals() {
        Optional setOptional = this.schema.getDataSchema().getGranularitySpec().bucketIntervals();
        if (setOptional.isPresent()) {
            return Optional.of((Object)JodaUtils.condenseIntervals((Iterable)((Iterable)setOptional.get())));
        }
        return Optional.absent();
    }

    public boolean isDeterminingPartitions() {
        return this.schema.getTuningConfig().getPartitionsSpec().isDeterminingPartitions();
    }

    public Long getTargetPartitionSize() {
        return this.schema.getTuningConfig().getPartitionsSpec().getTargetPartitionSize();
    }

    public long getMaxPartitionSize() {
        return this.schema.getTuningConfig().getPartitionsSpec().getMaxPartitionSize();
    }

    public boolean isUpdaterJobSpecSet() {
        return this.schema.getIOConfig().getMetadataUpdateSpec() != null;
    }

    public boolean isCombineText() {
        return this.schema.getTuningConfig().isCombineText();
    }

    public StringInputRowParser getParser() {
        return (StringInputRowParser)this.schema.getDataSchema().getParser();
    }

    public HadoopyShardSpec getShardSpec(Bucket bucket) {
        return this.schema.getTuningConfig().getShardSpecs().get(bucket.time).get(bucket.partitionNum);
    }

    public Job addInputPaths(Job job) throws IOException {
        return this.pathSpec.addInputPaths(this, job);
    }

    public Optional<Bucket> getBucket(InputRow inputRow) {
        Optional timeBucket = this.schema.getDataSchema().getGranularitySpec().bucketInterval(new DateTime(inputRow.getTimestampFromEpoch()));
        if (!timeBucket.isPresent()) {
            return Optional.absent();
        }
        ShardSpec actualSpec = this.shardSpecLookups.get(((Interval)timeBucket.get()).getStart()).getShardSpec(inputRow);
        HadoopyShardSpec hadoopyShardSpec = this.hadoopShardSpecLookup.get(actualSpec);
        return Optional.of((Object)new Bucket(hadoopyShardSpec.getShardNum(), ((Interval)timeBucket.get()).getStart(), actualSpec.getPartitionNum()));
    }

    public Optional<Set<Interval>> getSegmentGranularIntervals() {
        return Optional.fromNullable((Object)((Set)this.schema.getDataSchema().getGranularitySpec().bucketIntervals().orNull()));
    }

    public Optional<Iterable<Bucket>> getAllBuckets() {
        Optional<Set<Interval>> intervals = this.getSegmentGranularIntervals();
        if (intervals.isPresent()) {
            return Optional.of((Object)FunctionalIterable.create((Iterable)((Iterable)intervals.get())).transformCat((Function)new Function<Interval, Iterable<Bucket>>(){

                public Iterable<Bucket> apply(Interval input) {
                    final DateTime bucketTime = input.getStart();
                    List<HadoopyShardSpec> specs = HadoopDruidIndexerConfig.this.schema.getTuningConfig().getShardSpecs().get(bucketTime);
                    if (specs == null) {
                        return ImmutableList.of();
                    }
                    return FunctionalIterable.create(specs).transform((Function)new Function<HadoopyShardSpec, Bucket>(){
                        int i = 0;

                        public Bucket apply(HadoopyShardSpec input) {
                            return new Bucket(input.getShardNum(), bucketTime, this.i++);
                        }
                    });
                }
            }));
        }
        return Optional.absent();
    }

    public Path makeIntermediatePath() {
        return new Path(String.format("%s/%s/%s", this.schema.getTuningConfig().getWorkingPath(), this.schema.getDataSchema().getDataSource(), this.schema.getTuningConfig().getVersion().replace(":", "")));
    }

    public Path makeSegmentPartitionInfoPath(Interval bucketInterval) {
        return new Path(String.format("%s/%s_%s/partitions.json", this.makeIntermediatePath(), ISODateTimeFormat.basicDateTime().print((ReadableInstant)bucketInterval.getStart()), ISODateTimeFormat.basicDateTime().print((ReadableInstant)bucketInterval.getEnd())));
    }

    public Path makeIntervalInfoPath() {
        return new Path(String.format("%s/intervals.json", this.makeIntermediatePath()));
    }

    public Path makeDescriptorInfoDir() {
        return new Path(this.makeIntermediatePath(), "segmentDescriptorInfo");
    }

    public Path makeGroupedDataDir() {
        return new Path(this.makeIntermediatePath(), "groupedData");
    }

    public Path makeDescriptorInfoPath(DataSegment segment) {
        return new Path(this.makeDescriptorInfoDir(), String.format("%s.json", segment.getIdentifier().replace(":", "")));
    }

    public Path makeSegmentOutputPath(FileSystem fileSystem, Bucket bucket) {
        Interval bucketInterval = (Interval)this.schema.getDataSchema().getGranularitySpec().bucketInterval(bucket.time).get();
        if (fileSystem instanceof DistributedFileSystem) {
            return new Path(String.format("%s/%s/%s_%s/%s/%s", this.schema.getIOConfig().getSegmentOutputPath(), this.schema.getDataSchema().getDataSource(), bucketInterval.getStart().toString(ISODateTimeFormat.basicDateTime()), bucketInterval.getEnd().toString(ISODateTimeFormat.basicDateTime()), this.schema.getTuningConfig().getVersion().replace(":", "_"), bucket.partitionNum));
        }
        return new Path(String.format("%s/%s/%s_%s/%s/%s", this.schema.getIOConfig().getSegmentOutputPath(), this.schema.getDataSchema().getDataSource(), bucketInterval.getStart().toString(), bucketInterval.getEnd().toString(), this.schema.getTuningConfig().getVersion(), bucket.partitionNum));
    }

    public void addJobProperties(Job job) {
        Configuration conf = job.getConfiguration();
        for (Map.Entry<String, String> entry : this.schema.getTuningConfig().getJobProperties().entrySet()) {
            conf.set(entry.getKey(), entry.getValue());
        }
    }

    public void intoConfiguration(Job job) {
        Configuration conf = job.getConfiguration();
        try {
            conf.set(CONFIG_PROPERTY, jsonMapper.writeValueAsString((Object)this));
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void verify() {
        try {
            log.info("Running with config:%n%s", new Object[]{jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)this)});
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
        Preconditions.checkNotNull((Object)this.schema.getDataSchema().getDataSource(), (Object)"dataSource");
        Preconditions.checkNotNull((Object)this.schema.getDataSchema().getParser().getParseSpec(), (Object)"parseSpec");
        Preconditions.checkNotNull((Object)this.schema.getDataSchema().getParser().getParseSpec().getTimestampSpec(), (Object)"timestampSpec");
        Preconditions.checkNotNull((Object)this.schema.getDataSchema().getGranularitySpec(), (Object)"granularitySpec");
        Preconditions.checkNotNull((Object)this.pathSpec, (Object)"pathSpec");
        Preconditions.checkNotNull((Object)this.schema.getTuningConfig().getWorkingPath(), (Object)"workingPath");
        Preconditions.checkNotNull((Object)this.schema.getIOConfig().getSegmentOutputPath(), (Object)"segmentOutputPath");
        Preconditions.checkNotNull((Object)this.schema.getTuningConfig().getVersion(), (Object)"version");
    }

    static {
        javaNativeCharset = Charset.forName("Unicode");
        tabSplitter = Splitter.on((String)"\t");
        tabJoiner = Joiner.on((String)"\t");
        injector = Initialization.makeInjectorWithModules((Injector)GuiceInjectors.makeStartupInjector(), (Iterable)ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                JsonConfigProvider.bindInstance((Binder)binder, (Key)Key.get(DruidNode.class, Self.class), (Object)new DruidNode("hadoop-indexer", "localhost", Integer.valueOf(-1)));
            }
        }));
        jsonMapper = (ObjectMapper)injector.getInstance(ObjectMapper.class);
    }

    public static enum IndexJobCounters {
        INVALID_ROW_COUNTER;

    }
}

