/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.PeekingIterator;
import com.google.common.io.Closeables;
import com.metamx.common.ISE;
import com.metamx.common.guava.nary.BinaryFn;
import com.metamx.common.logger.Logger;
import io.druid.collections.CombiningIterable;
import io.druid.data.input.InputRow;
import io.druid.data.input.Rows;
import io.druid.granularity.QueryGranularity;
import io.druid.indexer.HadoopDruidIndexerConfig;
import io.druid.indexer.HadoopDruidIndexerMapper;
import io.druid.indexer.HadoopyShardSpec;
import io.druid.indexer.JobHelper;
import io.druid.indexer.Jobby;
import io.druid.indexer.SortableBytes;
import io.druid.indexer.Utils;
import io.druid.indexer.partitions.SingleDimensionPartitionsSpec;
import io.druid.timeline.partition.NoneShardSpec;
import io.druid.timeline.partition.ShardSpec;
import io.druid.timeline.partition.SingleDimensionShardSpec;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.InvalidJobConfException;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskInputOutputContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.joda.time.DateTime;
import org.joda.time.DateTimeComparator;
import org.joda.time.Interval;

public class DeterminePartitionsJob
implements Jobby {
    private static final Logger log = new Logger(DeterminePartitionsJob.class);
    private static final Joiner tabJoiner = HadoopDruidIndexerConfig.tabJoiner;
    private static final Splitter tabSplitter = HadoopDruidIndexerConfig.tabSplitter;
    private final HadoopDruidIndexerConfig config;

    public DeterminePartitionsJob(HadoopDruidIndexerConfig config) {
        this.config = config;
    }

    @Override
    public boolean run() {
        try {
            if (!(this.config.getPartitionsSpec() instanceof SingleDimensionPartitionsSpec)) {
                throw new ISE("DeterminePartitionsJob can only be run for SingleDimensionPartitionsSpec, partitionSpec found [%s]", new Object[]{this.config.getPartitionsSpec()});
            }
            if (!this.config.getPartitionsSpec().isAssumeGrouped()) {
                Job groupByJob = new Job(new Configuration(), String.format("%s-determine_partitions_groupby-%s", this.config.getDataSource(), this.config.getIntervals()));
                JobHelper.injectSystemProperties(groupByJob);
                groupByJob.setInputFormatClass(TextInputFormat.class);
                groupByJob.setMapperClass(DeterminePartitionsGroupByMapper.class);
                groupByJob.setMapOutputKeyClass(BytesWritable.class);
                groupByJob.setMapOutputValueClass(NullWritable.class);
                groupByJob.setCombinerClass(DeterminePartitionsGroupByReducer.class);
                groupByJob.setReducerClass(DeterminePartitionsGroupByReducer.class);
                groupByJob.setOutputKeyClass(BytesWritable.class);
                groupByJob.setOutputValueClass(NullWritable.class);
                groupByJob.setOutputFormatClass(SequenceFileOutputFormat.class);
                JobHelper.setupClasspath(this.config, groupByJob);
                this.config.addInputPaths(groupByJob);
                this.config.addJobProperties(groupByJob);
                this.config.intoConfiguration(groupByJob);
                FileOutputFormat.setOutputPath((Job)groupByJob, (Path)this.config.makeGroupedDataDir());
                groupByJob.submit();
                log.info("Job %s submitted, status available at: %s", new Object[]{groupByJob.getJobName(), groupByJob.getTrackingURL()});
                if (!groupByJob.waitForCompletion(true)) {
                    log.error("Job failed: %s", new Object[]{groupByJob.getJobID()});
                    return false;
                }
            } else {
                log.info("Skipping group-by job.", new Object[0]);
            }
            Job dimSelectionJob = new Job(new Configuration(), String.format("%s-determine_partitions_dimselection-%s", this.config.getDataSource(), this.config.getIntervals()));
            dimSelectionJob.getConfiguration().set("io.sort.record.percent", "0.19");
            JobHelper.injectSystemProperties(dimSelectionJob);
            if (!this.config.getPartitionsSpec().isAssumeGrouped()) {
                dimSelectionJob.setMapperClass(DeterminePartitionsDimSelectionPostGroupByMapper.class);
                dimSelectionJob.setInputFormatClass(SequenceFileInputFormat.class);
                FileInputFormat.addInputPath((Job)dimSelectionJob, (Path)this.config.makeGroupedDataDir());
            } else {
                dimSelectionJob.setMapperClass(DeterminePartitionsDimSelectionAssumeGroupedMapper.class);
                dimSelectionJob.setInputFormatClass(TextInputFormat.class);
                this.config.addInputPaths(dimSelectionJob);
            }
            SortableBytes.useSortableBytesAsMapOutputKey(dimSelectionJob);
            dimSelectionJob.setMapOutputValueClass(Text.class);
            dimSelectionJob.setCombinerClass(DeterminePartitionsDimSelectionCombiner.class);
            dimSelectionJob.setReducerClass(DeterminePartitionsDimSelectionReducer.class);
            dimSelectionJob.setOutputKeyClass(BytesWritable.class);
            dimSelectionJob.setOutputValueClass(Text.class);
            dimSelectionJob.setOutputFormatClass(DeterminePartitionsDimSelectionOutputFormat.class);
            dimSelectionJob.setPartitionerClass(DeterminePartitionsDimSelectionPartitioner.class);
            dimSelectionJob.setNumReduceTasks(((SortedSet)this.config.getGranularitySpec().bucketIntervals().get()).size());
            JobHelper.setupClasspath(this.config, dimSelectionJob);
            this.config.addJobProperties(dimSelectionJob);
            this.config.intoConfiguration(dimSelectionJob);
            FileOutputFormat.setOutputPath((Job)dimSelectionJob, (Path)this.config.makeIntermediatePath());
            dimSelectionJob.submit();
            log.info("Job %s submitted, status available at: %s", new Object[]{dimSelectionJob.getJobName(), dimSelectionJob.getTrackingURL()});
            if (!dimSelectionJob.waitForCompletion(true)) {
                log.error("Job failed: %s", new Object[]{dimSelectionJob.getJobID().toString()});
                return false;
            }
            log.info("Job completed, loading up partitions for intervals[%s].", new Object[]{this.config.getSegmentGranularIntervals()});
            FileSystem fileSystem = null;
            TreeMap shardSpecs = Maps.newTreeMap((Comparator)DateTimeComparator.getInstance());
            int shardCount = 0;
            for (Interval segmentGranularity : (Set)this.config.getSegmentGranularIntervals().get()) {
                Path partitionInfoPath = this.config.makeSegmentPartitionInfoPath(segmentGranularity);
                if (fileSystem == null) {
                    fileSystem = partitionInfoPath.getFileSystem(dimSelectionJob.getConfiguration());
                }
                if (Utils.exists((JobContext)dimSelectionJob, fileSystem, partitionInfoPath)) {
                    List specs = (List)HadoopDruidIndexerConfig.jsonMapper.readValue(Utils.openInputStream((JobContext)dimSelectionJob, partitionInfoPath), (TypeReference)new TypeReference<List<ShardSpec>>(){});
                    ArrayList actualSpecs = Lists.newArrayListWithExpectedSize((int)specs.size());
                    for (int i = 0; i < specs.size(); ++i) {
                        actualSpecs.add(new HadoopyShardSpec((ShardSpec)specs.get(i), shardCount++));
                        log.info("DateTime[%s], partition[%d], spec[%s]", new Object[]{segmentGranularity, i, actualSpecs.get(i)});
                    }
                    shardSpecs.put(segmentGranularity.getStart(), actualSpecs);
                    continue;
                }
                log.info("Path[%s] didn't exist!?", new Object[]{partitionInfoPath});
            }
            this.config.setShardSpecs(shardSpecs);
            return true;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static void write(TaskInputOutputContext<? extends Writable, ? extends Writable, BytesWritable, Text> context, byte[] groupKey, DimValueCount dimValueCount) throws IOException, InterruptedException {
        context.write((Object)new SortableBytes(groupKey, tabJoiner.join((Object)dimValueCount.dim, (Object)dimValueCount.value, new Object[0]).getBytes(HadoopDruidIndexerConfig.javaNativeCharset)).toBytesWritable(), (Object)dimValueCount.toText());
    }

    private static class DimValueCount {
        public final String dim;
        public final String value;
        public final int numRows;

        private DimValueCount(String dim, String value, int numRows) {
            this.dim = dim;
            this.value = value;
            this.numRows = numRows;
        }

        public Text toText() {
            return new Text(tabJoiner.join((Object)this.dim, (Object)String.valueOf(this.numRows), new Object[]{this.value}));
        }

        public static DimValueCount fromText(Text text) {
            Iterator splits = tabSplitter.limit(3).split((CharSequence)text.toString()).iterator();
            String dim = (String)splits.next();
            int numRows = Integer.parseInt((String)splits.next());
            String value = (String)splits.next();
            return new DimValueCount(dim, value, numRows);
        }
    }

    private static class DimPartition {
        public ShardSpec shardSpec = null;
        public int cardinality = 0;
        public int rows = 0;

        private DimPartition() {
        }
    }

    private static class DimPartitions {
        public final String dim;
        public final List<DimPartition> partitions = Lists.newArrayList();

        private DimPartitions(String dim) {
            this.dim = dim;
        }

        public int getCardinality() {
            int sum = 0;
            for (DimPartition dimPartition : this.partitions) {
                sum += dimPartition.cardinality;
            }
            return sum;
        }

        public long getDistanceSquaredFromTarget(long target) {
            long distance = 0L;
            for (DimPartition dimPartition : this.partitions) {
                distance += ((long)dimPartition.rows - target) * ((long)dimPartition.rows - target);
            }
            return distance /= (long)this.partitions.size();
        }

        public int getRows() {
            int sum = 0;
            for (DimPartition dimPartition : this.partitions) {
                sum += dimPartition.rows;
            }
            return sum;
        }
    }

    public static class DeterminePartitionsDimSelectionOutputFormat
    extends FileOutputFormat {
        public RecordWriter getRecordWriter(TaskAttemptContext job) throws IOException, InterruptedException {
            return new RecordWriter<SortableBytes, List<ShardSpec>>(){

                public void write(SortableBytes keyBytes, List<ShardSpec> partitions) throws IOException, InterruptedException {
                }

                public void close(TaskAttemptContext context) throws IOException, InterruptedException {
                }
            };
        }

        public void checkOutputSpecs(JobContext job) throws IOException {
            Path outDir = DeterminePartitionsDimSelectionOutputFormat.getOutputPath((JobContext)job);
            if (outDir == null) {
                throw new InvalidJobConfException("Output directory not set.");
            }
        }
    }

    public static class DeterminePartitionsDimSelectionReducer
    extends DeterminePartitionsDimSelectionBaseReducer {
        private static final double SHARD_COMBINE_THRESHOLD = 0.25;
        private static final int HIGH_CARDINALITY_THRESHOLD = 3000000;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void innerReduce(Reducer.Context context, SortableBytes keyBytes, Iterable<DimValueCount> combinedIterable) throws IOException, InterruptedException {
            ByteBuffer groupKey = ByteBuffer.wrap(keyBytes.getGroupKey());
            groupKey.position(4);
            DateTime bucket = new DateTime(groupKey.getLong());
            PeekingIterator iterator = Iterators.peekingIterator(combinedIterable.iterator());
            log.info("Determining partitions for interval: %s", new Object[]{config.getGranularitySpec().bucketInterval(bucket).orNull()});
            DimValueCount firstDvc = (DimValueCount)iterator.next();
            int totalRows = firstDvc.numRows;
            if (!firstDvc.dim.equals("") || !firstDvc.value.equals("")) {
                throw new IllegalStateException("WTF?! Expected total row indicator on first k/v pair!");
            }
            DimPartitions currentDimPartitions = null;
            DimPartition currentDimPartition = null;
            String currentDimPartitionStart = null;
            boolean currentDimSkip = false;
            HashMap dimPartitionss = Maps.newHashMap();
            while (iterator.hasNext()) {
                SingleDimensionShardSpec shardSpec;
                DimValueCount dvc = (DimValueCount)iterator.next();
                if (currentDimPartitions == null || !currentDimPartitions.dim.equals(dvc.dim)) {
                    currentDimPartitions = new DimPartitions(dvc.dim);
                    currentDimPartition = new DimPartition();
                    currentDimPartitionStart = null;
                    currentDimSkip = false;
                }
                if (!currentDimSkip && dvc.numRows < 0) {
                    log.info("Cannot partition on multi-valued dimension: %s", new Object[]{dvc.dim});
                    currentDimSkip = true;
                }
                if (currentDimSkip) continue;
                if (currentDimPartition.rows > 0 && (long)(currentDimPartition.rows + dvc.numRows) >= config.getTargetPartitionSize()) {
                    shardSpec = new SingleDimensionShardSpec(currentDimPartitions.dim, currentDimPartitionStart, dvc.value, currentDimPartitions.partitions.size());
                    log.info("Adding possible shard with %,d rows and %,d unique values: %s", new Object[]{currentDimPartition.rows, currentDimPartition.cardinality, shardSpec});
                    currentDimPartition.shardSpec = shardSpec;
                    currentDimPartitions.partitions.add(currentDimPartition);
                    currentDimPartition = new DimPartition();
                    currentDimPartitionStart = dvc.value;
                }
                ++currentDimPartition.cardinality;
                currentDimPartition.rows += dvc.numRows;
                if (iterator.hasNext() && currentDimPartitions.dim.equals(((DimValueCount)iterator.peek()).dim)) continue;
                if (currentDimPartition.rows > 0) {
                    if (currentDimPartitions.partitions.isEmpty()) {
                        shardSpec = new NoneShardSpec();
                    } else if ((double)currentDimPartition.rows < (double)config.getTargetPartitionSize().longValue() * 0.25) {
                        DimPartition previousDimPartition = currentDimPartitions.partitions.remove(currentDimPartitions.partitions.size() - 1);
                        SingleDimensionShardSpec previousShardSpec = (SingleDimensionShardSpec)previousDimPartition.shardSpec;
                        shardSpec = new SingleDimensionShardSpec(currentDimPartitions.dim, previousShardSpec.getStart(), null, previousShardSpec.getPartitionNum());
                        log.info("Removing possible shard: %s", new Object[]{previousShardSpec});
                        currentDimPartition.rows += previousDimPartition.rows;
                        currentDimPartition.cardinality += previousDimPartition.cardinality;
                    } else {
                        shardSpec = new SingleDimensionShardSpec(currentDimPartitions.dim, currentDimPartitionStart, null, currentDimPartitions.partitions.size());
                    }
                    log.info("Adding possible shard with %,d rows and %,d unique values: %s", new Object[]{currentDimPartition.rows, currentDimPartition.cardinality, shardSpec});
                    currentDimPartition.shardSpec = shardSpec;
                    currentDimPartitions.partitions.add(currentDimPartition);
                }
                log.info("Completed dimension[%s]: %,d possible shards with %,d unique values", new Object[]{currentDimPartitions.dim, currentDimPartitions.partitions.size(), currentDimPartitions.getCardinality()});
                dimPartitionss.put(currentDimPartitions.dim, currentDimPartitions);
            }
            if (dimPartitionss.isEmpty()) {
                throw new ISE("No suitable partitioning dimension found!", new Object[0]);
            }
            int maxCardinality = Integer.MIN_VALUE;
            long minDistance = Long.MAX_VALUE;
            DimPartitions minDistancePartitions = null;
            DimPartitions maxCardinalityPartitions = null;
            for (DimPartitions dimPartitions : dimPartitionss.values()) {
                if (dimPartitions.getRows() != totalRows) {
                    log.info("Dimension[%s] is not present in all rows (row count %,d != expected row count %,d)", new Object[]{dimPartitions.dim, dimPartitions.getRows(), totalRows});
                    continue;
                }
                boolean oversized = false;
                for (DimPartition partition : dimPartitions.partitions) {
                    if ((long)partition.rows <= config.getMaxPartitionSize()) continue;
                    log.info("Dimension[%s] has an oversized shard: %s", new Object[]{dimPartitions.dim, partition.shardSpec});
                    oversized = true;
                }
                if (oversized) continue;
                int cardinality = dimPartitions.getCardinality();
                long distance = dimPartitions.getDistanceSquaredFromTarget(config.getTargetPartitionSize());
                if (cardinality > maxCardinality) {
                    maxCardinality = cardinality;
                    maxCardinalityPartitions = dimPartitions;
                }
                if (distance >= minDistance) continue;
                minDistance = distance;
                minDistancePartitions = dimPartitions;
            }
            if (maxCardinalityPartitions == null) {
                throw new ISE("No suitable partitioning dimension found!", new Object[0]);
            }
            OutputStream out = Utils.makePathAndOutputStream((JobContext)context, config.makeSegmentPartitionInfoPath((Interval)config.getGranularitySpec().bucketInterval(bucket).get()), config.isOverwriteFiles());
            DimPartitions chosenPartitions = maxCardinality > 3000000 ? maxCardinalityPartitions : minDistancePartitions;
            List chosenShardSpecs = Lists.transform(chosenPartitions.partitions, (Function)new Function<DimPartition, ShardSpec>(){

                public ShardSpec apply(DimPartition dimPartition) {
                    return dimPartition.shardSpec;
                }
            });
            log.info("Chosen partitions:", new Object[0]);
            for (ShardSpec shardSpec : chosenShardSpecs) {
                log.info("  %s", new Object[]{HadoopDruidIndexerConfig.jsonMapper.writeValueAsString((Object)shardSpec)});
            }
            try {
                HadoopDruidIndexerConfig.jsonMapper.writerWithType((TypeReference)new TypeReference<List<ShardSpec>>(){}).writeValue(out, (Object)chosenShardSpecs);
            }
            finally {
                Closeables.close((Closeable)out, (boolean)false);
            }
        }
    }

    public static class DeterminePartitionsDimSelectionCombiner
    extends DeterminePartitionsDimSelectionBaseReducer {
        @Override
        protected void innerReduce(Reducer.Context context, SortableBytes keyBytes, Iterable<DimValueCount> combinedIterable) throws IOException, InterruptedException {
            for (DimValueCount dvc : combinedIterable) {
                DeterminePartitionsJob.write((TaskInputOutputContext<? extends Writable, ? extends Writable, BytesWritable, Text>)((TaskInputOutputContext)context), keyBytes.getGroupKey(), dvc);
            }
        }
    }

    private static abstract class DeterminePartitionsDimSelectionBaseReducer
    extends Reducer<BytesWritable, Text, BytesWritable, Text> {
        protected static volatile HadoopDruidIndexerConfig config = null;

        private DeterminePartitionsDimSelectionBaseReducer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void setup(Reducer.Context context) throws IOException, InterruptedException {
            if (config != null) return;
            Class<DeterminePartitionsDimSelectionBaseReducer> clazz = DeterminePartitionsDimSelectionBaseReducer.class;
            synchronized (DeterminePartitionsDimSelectionBaseReducer.class) {
                if (config != null) return;
                config = HadoopDruidIndexerConfig.fromConfiguration(context.getConfiguration());
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        protected void reduce(BytesWritable key, Iterable<Text> values, Reducer.Context context) throws IOException, InterruptedException {
            SortableBytes keyBytes = SortableBytes.fromBytesWritable(key);
            Iterable<DimValueCount> combinedIterable = this.combineRows(values);
            this.innerReduce(context, keyBytes, combinedIterable);
        }

        protected abstract void innerReduce(Reducer.Context var1, SortableBytes var2, Iterable<DimValueCount> var3) throws IOException, InterruptedException;

        private Iterable<DimValueCount> combineRows(Iterable<Text> input) {
            return new CombiningIterable(Iterables.transform(input, (Function)new Function<Text, DimValueCount>(){

                public DimValueCount apply(Text input) {
                    return DimValueCount.fromText(input);
                }
            }), (Comparator)new Comparator<DimValueCount>(){

                @Override
                public int compare(DimValueCount o1, DimValueCount o2) {
                    return ComparisonChain.start().compare((Comparable)((Object)o1.dim), (Comparable)((Object)o2.dim)).compare((Comparable)((Object)o1.value), (Comparable)((Object)o2.value)).result();
                }
            }, (BinaryFn)new BinaryFn<DimValueCount, DimValueCount, DimValueCount>(){

                public DimValueCount apply(DimValueCount arg1, DimValueCount arg2) {
                    if (arg2 == null) {
                        return arg1;
                    }
                    int newNumRows = arg1.numRows >= 0 && arg2.numRows >= 0 ? arg1.numRows + arg2.numRows : -1;
                    return new DimValueCount(arg1.dim, arg1.value, newNumRows);
                }
            });
        }
    }

    public static class DeterminePartitionsDimSelectionPartitioner
    extends Partitioner<BytesWritable, Text>
    implements Configurable {
        private Configuration config;

        public int getPartition(BytesWritable bytesWritable, Text text, int numPartitions) {
            ByteBuffer bytes = ByteBuffer.wrap(bytesWritable.getBytes());
            bytes.position(4);
            int index = bytes.getInt();
            if (this.config.get("mapred.job.tracker").equals("local")) {
                return index % numPartitions;
            }
            if (index >= numPartitions) {
                throw new ISE("Not enough partitions, index[%,d] >= numPartitions[%,d]. Please increase the number of reducers to the index size or check your config & settings!", new Object[]{index, numPartitions});
            }
            return index;
        }

        public Configuration getConf() {
            return this.config;
        }

        public void setConf(Configuration config) {
            this.config = config;
        }
    }

    public static class DeterminePartitionsDimSelectionMapperHelper {
        private final HadoopDruidIndexerConfig config;
        private final String partitionDimension;
        private final Map<DateTime, Integer> intervalIndexes;

        public DeterminePartitionsDimSelectionMapperHelper(HadoopDruidIndexerConfig config, String partitionDimension) {
            this.config = config;
            this.partitionDimension = partitionDimension;
            ImmutableMap.Builder timeIndexBuilder = ImmutableMap.builder();
            int idx = 0;
            for (Interval bucketInterval : (SortedSet)config.getGranularitySpec().bucketIntervals().get()) {
                timeIndexBuilder.put((Object)bucketInterval.getStart(), (Object)idx);
                ++idx;
            }
            this.intervalIndexes = timeIndexBuilder.build();
        }

        public void emitDimValueCounts(TaskInputOutputContext<? extends Writable, ? extends Writable, BytesWritable, Text> context, DateTime timestamp, Map<String, Iterable<String>> dims) throws IOException, InterruptedException {
            Optional maybeInterval = this.config.getGranularitySpec().bucketInterval(timestamp);
            if (!maybeInterval.isPresent()) {
                throw new ISE("WTF?! No bucket found for timestamp: %s", new Object[]{timestamp});
            }
            Interval interval = (Interval)maybeInterval.get();
            int intervalIndex = this.intervalIndexes.get(interval.getStart());
            ByteBuffer buf = ByteBuffer.allocate(12);
            buf.putInt(intervalIndex);
            buf.putLong(interval.getStartMillis());
            byte[] groupKey = buf.array();
            DeterminePartitionsJob.write((TaskInputOutputContext<? extends Writable, ? extends Writable, BytesWritable, Text>)context, groupKey, new DimValueCount("", "", 1));
            for (Map.Entry<String, Iterable<String>> dimAndValues : dims.entrySet()) {
                String dim = dimAndValues.getKey();
                if (this.partitionDimension != null && !this.partitionDimension.equals(dim)) continue;
                Iterable<String> dimValues = dimAndValues.getValue();
                if (Iterables.size(dimValues) == 1) {
                    DeterminePartitionsJob.write((TaskInputOutputContext<? extends Writable, ? extends Writable, BytesWritable, Text>)context, groupKey, new DimValueCount(dim, (String)Iterables.getOnlyElement(dimValues), 1));
                    continue;
                }
                DeterminePartitionsJob.write((TaskInputOutputContext<? extends Writable, ? extends Writable, BytesWritable, Text>)context, groupKey, new DimValueCount(dim, "", -1));
            }
        }
    }

    public static class DeterminePartitionsDimSelectionAssumeGroupedMapper
    extends HadoopDruidIndexerMapper<BytesWritable, Text> {
        private DeterminePartitionsDimSelectionMapperHelper helper;

        @Override
        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            HadoopDruidIndexerConfig config = HadoopDruidIndexerConfig.fromConfiguration(context.getConfiguration());
            SingleDimensionPartitionsSpec spec = (SingleDimensionPartitionsSpec)config.getPartitionsSpec();
            this.helper = new DeterminePartitionsDimSelectionMapperHelper(config, spec.getPartitionDimension());
        }

        @Override
        protected void innerMap(InputRow inputRow, Text text, Mapper.Context context) throws IOException, InterruptedException {
            HashMap dims = Maps.newHashMap();
            for (String dim : inputRow.getDimensions()) {
                dims.put(dim, inputRow.getDimension(dim));
            }
            this.helper.emitDimValueCounts((TaskInputOutputContext<? extends Writable, ? extends Writable, BytesWritable, Text>)context, new DateTime(inputRow.getTimestampFromEpoch()), dims);
        }
    }

    public static class DeterminePartitionsDimSelectionPostGroupByMapper
    extends Mapper<BytesWritable, NullWritable, BytesWritable, Text> {
        private DeterminePartitionsDimSelectionMapperHelper helper;

        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            HadoopDruidIndexerConfig config = HadoopDruidIndexerConfig.fromConfiguration(context.getConfiguration());
            SingleDimensionPartitionsSpec spec = (SingleDimensionPartitionsSpec)config.getPartitionsSpec();
            this.helper = new DeterminePartitionsDimSelectionMapperHelper(config, spec.getPartitionDimension());
        }

        protected void map(BytesWritable key, NullWritable value, Mapper.Context context) throws IOException, InterruptedException {
            List timeAndDims = (List)HadoopDruidIndexerConfig.jsonMapper.readValue(key.getBytes(), List.class);
            DateTime timestamp = new DateTime(timeAndDims.get(0));
            Map dims = (Map)timeAndDims.get(1);
            this.helper.emitDimValueCounts((TaskInputOutputContext<? extends Writable, ? extends Writable, BytesWritable, Text>)context, timestamp, dims);
        }
    }

    public static class DeterminePartitionsGroupByReducer
    extends Reducer<BytesWritable, NullWritable, BytesWritable, NullWritable> {
        protected void reduce(BytesWritable key, Iterable<NullWritable> values, Reducer.Context context) throws IOException, InterruptedException {
            context.write((Object)key, (Object)NullWritable.get());
        }
    }

    public static class DeterminePartitionsGroupByMapper
    extends HadoopDruidIndexerMapper<BytesWritable, NullWritable> {
        private QueryGranularity rollupGranularity = null;

        @Override
        protected void setup(Mapper.Context context) throws IOException, InterruptedException {
            super.setup(context);
            this.rollupGranularity = this.getConfig().getGranularitySpec().getQueryGranularity();
        }

        @Override
        protected void innerMap(InputRow inputRow, Text text, Mapper.Context context) throws IOException, InterruptedException {
            List groupKey = Rows.toGroupKey((long)this.rollupGranularity.truncate(inputRow.getTimestampFromEpoch()), (InputRow)inputRow);
            context.write((Object)new BytesWritable(HadoopDruidIndexerConfig.jsonMapper.writeValueAsBytes((Object)groupKey)), (Object)NullWritable.get());
        }
    }
}

