/*
 * Decompiled with CFR 0.152.
 */
package io.druid.indexer;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.metamx.common.logger.Logger;
import io.druid.db.DbConnector;
import io.druid.indexer.HadoopDruidIndexerConfig;
import io.druid.indexer.IndexGeneratorJob;
import io.druid.indexer.Jobby;
import io.druid.timeline.DataSegment;
import io.druid.timeline.partition.NoneShardSpec;
import java.util.List;
import java.util.Map;
import org.joda.time.DateTime;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.PreparedBatch;
import org.skife.jdbi.v2.tweak.HandleCallback;

public class DbUpdaterJob
implements Jobby {
    private static final Logger log = new Logger(DbUpdaterJob.class);
    private final HadoopDruidIndexerConfig config;
    private final IDBI dbi;
    private final DbConnector dbConnector;

    public DbUpdaterJob(HadoopDruidIndexerConfig config) {
        this.config = config;
        this.dbConnector = new DbConnector((Supplier)config.getSchema().getIOConfig().getMetadataUpdateSpec(), null);
        this.dbi = this.dbConnector.getDBI();
    }

    @Override
    public boolean run() {
        final List<DataSegment> segments = IndexGeneratorJob.getPublishedSegments(this.config);
        this.dbi.withHandle((HandleCallback)new HandleCallback<Void>(){

            public Void withHandle(Handle handle) throws Exception {
                PreparedBatch batch = handle.prepareBatch(String.format(DbUpdaterJob.this.dbConnector.isPostgreSQL() ? "INSERT INTO %s (id, dataSource, created_date, start, \"end\", partitioned, version, used, payload) VALUES (:id, :dataSource, :created_date, :start, :end, :partitioned, :version, :used, :payload)" : "INSERT INTO %s (id, dataSource, created_date, start, end, partitioned, version, used, payload) VALUES (:id, :dataSource, :created_date, :start, :end, :partitioned, :version, :used, :payload)", DbUpdaterJob.this.config.getSchema().getIOConfig().getMetadataUpdateSpec().getSegmentTable()));
                for (DataSegment segment : segments) {
                    batch.add((Map)new ImmutableMap.Builder().put((Object)"id", (Object)segment.getIdentifier()).put((Object)"dataSource", (Object)segment.getDataSource()).put((Object)"created_date", (Object)new DateTime().toString()).put((Object)"start", (Object)segment.getInterval().getStart().toString()).put((Object)"end", (Object)segment.getInterval().getEnd().toString()).put((Object)"partitioned", (Object)(segment.getShardSpec() instanceof NoneShardSpec ? 0 : 1)).put((Object)"version", (Object)segment.getVersion()).put((Object)"used", (Object)true).put((Object)"payload", (Object)HadoopDruidIndexerConfig.jsonMapper.writeValueAsString((Object)segment)).build());
                    log.info("Published %s", new Object[]{segment.getIdentifier()});
                }
                batch.execute();
                return null;
            }
        });
        return true;
    }
}

