/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli.validate;

import com.google.api.client.repackaged.com.google.common.base.Throwables;
import com.metamx.common.UOE;
import io.airlift.command.Command;
import io.airlift.command.Option;
import io.druid.indexer.HadoopDruidIndexerConfig;
import io.druid.indexing.common.task.Task;
import io.druid.jackson.DefaultObjectMapper;
import io.druid.query.Query;
import io.druid.segment.realtime.Schema;
import java.io.File;

@Command(name="validator", description="Validates that a given Druid JSON object is correctly formatted")
public class DruidJsonValidator
implements Runnable {
    @Option(name={"-f"}, title="file", description="file to validate", required=true)
    public String jsonFile;
    @Option(name={"-t"}, title="type", description="the type of schema to validate", required=true)
    public String type;

    @Override
    public void run() {
        block7: {
            File file = new File(this.jsonFile);
            if (!file.exists()) {
                System.out.printf("File[%s] does not exist.%n", file);
            }
            DefaultObjectMapper jsonMapper = new DefaultObjectMapper();
            try {
                if (this.type.equalsIgnoreCase("query")) {
                    jsonMapper.readValue(file, Query.class);
                    break block7;
                }
                if (this.type.equalsIgnoreCase("hadoopConfig")) {
                    jsonMapper.readValue(file, HadoopDruidIndexerConfig.class);
                    break block7;
                }
                if (this.type.equalsIgnoreCase("task")) {
                    jsonMapper.readValue(file, Task.class);
                    break block7;
                }
                if (this.type.equalsIgnoreCase("realtimeSchema")) {
                    jsonMapper.readValue(file, Schema.class);
                    break block7;
                }
                throw new UOE("Unknown type[%s]", new Object[]{this.type});
            }
            catch (Exception e) {
                System.out.println("INVALID JSON!");
                throw Throwables.propagate((Throwable)e);
            }
        }
    }
}

