/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.servlet.GuiceFilter;
import com.metamx.emitter.service.ServiceEmitter;
import io.druid.guice.annotations.Json;
import io.druid.guice.annotations.Smile;
import io.druid.server.AsyncQueryForwardingServlet;
import io.druid.server.initialization.JettyServerInitializer;
import io.druid.server.log.RequestLogger;
import io.druid.server.router.QueryHostFinder;
import io.druid.server.router.Router;
import javax.servlet.Servlet;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.DefaultHandler;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.servlets.AsyncGzipFilter;

public class RouterJettyServerInitializer
implements JettyServerInitializer {
    private final ObjectMapper jsonMapper;
    private final ObjectMapper smileMapper;
    private final QueryHostFinder hostFinder;
    private final HttpClient httpClient;
    private final ServiceEmitter emitter;
    private final RequestLogger requestLogger;

    @Inject
    public RouterJettyServerInitializer(@Json ObjectMapper jsonMapper, @Smile ObjectMapper smileMapper, QueryHostFinder hostFinder, @Router HttpClient httpClient, ServiceEmitter emitter, RequestLogger requestLogger) {
        this.jsonMapper = jsonMapper;
        this.smileMapper = smileMapper;
        this.hostFinder = hostFinder;
        this.httpClient = httpClient;
        this.emitter = emitter;
        this.requestLogger = requestLogger;
    }

    public void initialize(Server server, Injector injector) {
        ServletContextHandler queries = new ServletContextHandler(1);
        queries.addServlet(new ServletHolder((Servlet)new AsyncQueryForwardingServlet(this.jsonMapper, this.smileMapper, this.hostFinder, this.httpClient, this.emitter, this.requestLogger)), "/druid/v2/*");
        queries.addFilter(AsyncGzipFilter.class, "/druid/v2/*", null);
        queries.addFilter(GuiceFilter.class, "/status/*", null);
        ServletContextHandler root = new ServletContextHandler(1);
        root.addServlet(new ServletHolder((Servlet)new DefaultServlet()), "/*");
        root.addFilter(GuiceFilter.class, "/*", null);
        HandlerList handlerList = new HandlerList();
        handlerList.setHandlers(new Handler[]{queries, root, new DefaultHandler()});
        server.setHandler((Handler)handlerList);
    }
}

