/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.google.api.client.util.Lists;
import com.google.common.base.Throwables;
import com.google.inject.Inject;
import io.airlift.command.Command;
import io.airlift.command.Option;
import io.druid.guice.ExtensionsConfig;
import io.druid.indexing.common.config.TaskConfig;
import io.druid.initialization.Initialization;
import io.tesla.aether.TeslaAether;
import io.tesla.aether.internal.DefaultTeslaAether;
import java.util.ArrayList;
import java.util.List;

@Command(name="pull-deps", description="Pull down dependencies to the local repository specified by druid.extensions.localRepository")
public class PullDependencies
implements Runnable {
    @Option(name={"-c"}, title="coordinate", description="extra dependencies to pull down (e.g. hadoop coordinates)", required=false)
    public List<String> coordinates;
    @Option(name={"--no-default-hadoop"}, description="don't pull down the default HadoopIndexTask dependencies", required=false)
    public boolean noDefaultHadoop;
    @Inject
    public ExtensionsConfig extensionsConfig = null;

    @Override
    public void run() {
        ArrayList allCoordinates = Lists.newArrayList();
        if (this.coordinates != null) {
            allCoordinates.addAll(this.coordinates);
        }
        if (!this.noDefaultHadoop) {
            allCoordinates.addAll(TaskConfig.DEFAULT_DEFAULT_HADOOP_COORDINATES);
        }
        try {
            DefaultTeslaAether aetherClient = Initialization.getAetherClient((ExtensionsConfig)this.extensionsConfig);
            for (String coordinate : allCoordinates) {
                Initialization.getClassLoaderForCoordinates((TeslaAether)aetherClient, (String)coordinate);
            }
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

