/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.google.common.base.Throwables;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.metamx.common.lifecycle.Lifecycle;
import com.metamx.common.logger.Logger;
import io.druid.initialization.Initialization;
import io.druid.initialization.LogLevelAdjuster;
import java.util.List;

public abstract class GuiceRunnable
implements Runnable {
    private final Logger log;
    private Injector baseInjector;

    public GuiceRunnable(Logger log) {
        this.log = log;
    }

    @Inject
    public void configure(Injector injector) {
        this.baseInjector = injector;
    }

    protected abstract List<Object> getModules();

    public Injector makeInjector() {
        try {
            return Initialization.makeInjectorWithModules((Injector)this.baseInjector, this.getModules());
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Lifecycle initLifecycle(Injector injector) {
        try {
            LogLevelAdjuster.register();
            Lifecycle lifecycle = (Lifecycle)injector.getInstance(Lifecycle.class);
            try {
                lifecycle.start();
            }
            catch (Throwable t) {
                this.log.error(t, "Error when starting up.  Failing.", new Object[0]);
                System.exit(1);
            }
            return lifecycle;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

