/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.TypeLiteral;
import com.metamx.common.logger.Logger;
import io.airlift.command.Command;
import io.druid.cli.RouterJettyServerInitializer;
import io.druid.cli.ServerRunnable;
import io.druid.curator.discovery.DiscoveryModule;
import io.druid.curator.discovery.ServerDiscoveryFactory;
import io.druid.curator.discovery.ServerDiscoverySelector;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.LifecycleModule;
import io.druid.guice.ManageLifecycle;
import io.druid.guice.annotations.Self;
import io.druid.guice.http.JettyHttpClientModule;
import io.druid.server.initialization.JettyServerInitializer;
import io.druid.server.router.CoordinatorRuleManager;
import io.druid.server.router.QueryHostFinder;
import io.druid.server.router.Router;
import io.druid.server.router.TieredBrokerConfig;
import io.druid.server.router.TieredBrokerHostSelector;
import io.druid.server.router.TieredBrokerSelectorStrategiesProvider;
import io.druid.server.router.TieredBrokerSelectorStrategy;
import java.util.List;
import org.eclipse.jetty.server.Server;

@Command(name="router", description="Experimental! Understands tiers and routes things to different brokers")
public class CliRouter
extends ServerRunnable {
    private static final Logger log = new Logger(CliRouter.class);

    public CliRouter() {
        super(log);
    }

    @Override
    protected List<Object> getModules() {
        return ImmutableList.of((Object)new JettyHttpClientModule("druid.router.http", Router.class), (Object)new Module(){

            public void configure(Binder binder) {
                JsonConfigProvider.bind((Binder)binder, (String)"druid.router", TieredBrokerConfig.class);
                binder.bind(CoordinatorRuleManager.class);
                LifecycleModule.register((Binder)binder, CoordinatorRuleManager.class);
                binder.bind(TieredBrokerHostSelector.class).in(ManageLifecycle.class);
                binder.bind(QueryHostFinder.class).in(LazySingleton.class);
                binder.bind((TypeLiteral)new TypeLiteral<List<TieredBrokerSelectorStrategy>>(){}).toProvider(TieredBrokerSelectorStrategiesProvider.class).in(LazySingleton.class);
                binder.bind(JettyServerInitializer.class).to(RouterJettyServerInitializer.class).in(LazySingleton.class);
                LifecycleModule.register((Binder)binder, Server.class);
                DiscoveryModule.register((Binder)binder, Self.class);
            }

            @Provides
            @ManageLifecycle
            public ServerDiscoverySelector getCoordinatorServerDiscoverySelector(TieredBrokerConfig config, ServerDiscoveryFactory factory) {
                return factory.createSelector(config.getCoordinatorServiceName());
            }
        });
    }
}

