/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.util.Providers;
import com.metamx.common.logger.Logger;
import io.airlift.command.Command;
import io.druid.cli.MiddleManagerJettyServerInitializer;
import io.druid.cli.ServerRunnable;
import io.druid.guice.IndexingServiceFirehoseModule;
import io.druid.guice.IndexingServiceModuleHelper;
import io.druid.guice.IndexingServiceTaskLogsModule;
import io.druid.guice.Jerseys;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.LifecycleModule;
import io.druid.guice.ManageLifecycle;
import io.druid.guice.annotations.Self;
import io.druid.indexing.common.config.TaskConfig;
import io.druid.indexing.overlord.ForkingTaskRunner;
import io.druid.indexing.overlord.TaskRunner;
import io.druid.indexing.worker.Worker;
import io.druid.indexing.worker.WorkerCuratorCoordinator;
import io.druid.indexing.worker.WorkerTaskMonitor;
import io.druid.indexing.worker.config.WorkerConfig;
import io.druid.indexing.worker.http.WorkerResource;
import io.druid.segment.realtime.firehose.ChatHandlerProvider;
import io.druid.server.DruidNode;
import io.druid.server.initialization.JettyServerInitializer;
import java.util.List;
import org.eclipse.jetty.server.Server;

@Command(name="middleManager", description="Runs a Middle Manager, this is a \"task\" node used as part of the remote indexing service.")
public class CliMiddleManager
extends ServerRunnable {
    private static final Logger log = new Logger(CliMiddleManager.class);

    public CliMiddleManager() {
        super(log);
    }

    @Override
    protected List<Object> getModules() {
        return ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                IndexingServiceModuleHelper.configureTaskRunnerConfigs((Binder)binder);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.indexer.task", TaskConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.worker", WorkerConfig.class);
                binder.bind(TaskRunner.class).to(ForkingTaskRunner.class);
                binder.bind(ForkingTaskRunner.class).in(LazySingleton.class);
                binder.bind(ChatHandlerProvider.class).toProvider(Providers.of(null));
                binder.bind(WorkerTaskMonitor.class).in(ManageLifecycle.class);
                binder.bind(WorkerCuratorCoordinator.class).in(ManageLifecycle.class);
                LifecycleModule.register((Binder)binder, WorkerTaskMonitor.class);
                binder.bind(JettyServerInitializer.class).toInstance((Object)new MiddleManagerJettyServerInitializer());
                Jerseys.addResource((Binder)binder, WorkerResource.class);
                LifecycleModule.register((Binder)binder, Server.class);
            }

            @Provides
            @LazySingleton
            public Worker getWorker(@Self DruidNode node, WorkerConfig config) {
                return new Worker(node.getHost(), config.getIp(), config.getCapacity(), config.getVersion());
            }
        }, (Object)new IndexingServiceFirehoseModule(), (Object)new IndexingServiceTaskLogsModule());
    }
}

