/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.google.api.client.repackaged.com.google.common.base.Throwables;
import com.google.api.client.util.Lists;
import com.metamx.common.logger.Logger;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.druid.cli.CliHadoopIndexer;
import io.druid.indexer.HadoopDruidDetermineConfigurationJob;
import io.druid.indexer.HadoopDruidIndexerConfig;
import io.druid.indexer.HadoopDruidIndexerJob;
import io.druid.indexer.JobHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

@Command(name="hadoop-indexer", description="Runs the batch Hadoop Druid Indexer, see http://druid.io/docs/latest/Batch-ingestion.html for a description.")
public class CliInternalHadoopIndexer
implements Runnable {
    private static final Logger log = new Logger(CliHadoopIndexer.class);
    @Arguments(description="A JSON object or the path to a file that contains a JSON object", required=true)
    private String argumentSpec;

    @Override
    public void run() {
        try {
            HadoopDruidIndexerConfig config = this.getHadoopDruidIndexerConfig();
            ArrayList jobs = Lists.newArrayList();
            jobs.add(new HadoopDruidDetermineConfigurationJob(config));
            jobs.add(new HadoopDruidIndexerJob(config));
            JobHelper.runJobs((List)jobs, (HadoopDruidIndexerConfig)config);
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public HadoopDruidIndexerConfig getHadoopDruidIndexerConfig() {
        try {
            if (this.argumentSpec.startsWith("{")) {
                return HadoopDruidIndexerConfig.fromString((String)this.argumentSpec);
            }
            return HadoopDruidIndexerConfig.fromFile((File)new File(this.argumentSpec));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

