/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.metamx.common.logger.Logger;
import io.airlift.command.Arguments;
import io.airlift.command.Command;
import io.airlift.command.Option;
import io.druid.cli.Main;
import io.druid.guice.ExtensionsConfig;
import io.druid.initialization.Initialization;
import io.tesla.aether.TeslaAether;
import io.tesla.aether.internal.DefaultTeslaAether;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Command(name="hadoop", description="Runs the batch Hadoop Druid Indexer, see http://druid.io/docs/latest/Batch-ingestion.html for a description.")
public class CliHadoopIndexer
implements Runnable {
    private static String defaultHadoopCoordinates = "org.apache.hadoop:hadoop-client:2.3.0";
    private static final Logger log = new Logger(CliHadoopIndexer.class);
    @Arguments(description="A JSON object or the path to a file that contains a JSON object", required=true)
    private String argumentSpec;
    @Option(name={"hadoop"}, description="The maven coordinates to the version of hadoop to run with. Defaults to org.apache.hadoop:hadoop-client:2.3.0")
    private String hadoopCoordinates = defaultHadoopCoordinates;
    @Option(name={"hadoopDependencies"}, description="The maven coordinates to the version of hadoop and all dependencies to run with. Defaults to using org.apache.hadoop:hadoop-client:2.3.0")
    private List<String> hadoopDependencyCoordinates = Arrays.asList(defaultHadoopCoordinates);
    @Inject
    private ExtensionsConfig extensionsConfig = null;

    @Override
    public void run() {
        try {
            DefaultTeslaAether aetherClient = Initialization.getAetherClient((ExtensionsConfig)this.extensionsConfig);
            ArrayList extensionURLs = Lists.newArrayList();
            for (String coordinate : this.extensionsConfig.getCoordinates()) {
                URLClassLoader coordinateLoader = Initialization.getClassLoaderForCoordinates((TeslaAether)aetherClient, (String)coordinate);
                extensionURLs.addAll(Arrays.asList(coordinateLoader.getURLs()));
            }
            ArrayList nonHadoopURLs = Lists.newArrayList();
            nonHadoopURLs.addAll(Arrays.asList(((URLClassLoader)CliHadoopIndexer.class.getClassLoader()).getURLs()));
            ArrayList driverURLs = Lists.newArrayList();
            driverURLs.addAll(nonHadoopURLs);
            for (String coordinate : this.hadoopDependencyCoordinates) {
                URLClassLoader hadoopLoader = Initialization.getClassLoaderForCoordinates((TeslaAether)aetherClient, (String)coordinate);
                driverURLs.addAll(Arrays.asList(hadoopLoader.getURLs()));
            }
            URLClassLoader loader = new URLClassLoader(driverURLs.toArray(new URL[driverURLs.size()]), null);
            Thread.currentThread().setContextClassLoader(loader);
            ArrayList jobUrls = Lists.newArrayList();
            jobUrls.addAll(nonHadoopURLs);
            jobUrls.addAll(extensionURLs);
            System.setProperty("druid.hadoop.internal.classpath", Joiner.on((String)File.pathSeparator).join((Iterable)jobUrls));
            Class<?> mainClass = loader.loadClass(Main.class.getName());
            Method mainMethod = mainClass.getMethod("main", String[].class);
            String[] args = new String[]{"internal", "hadoop-indexer", this.argumentSpec};
            mainMethod.invoke(null, new Object[]{args});
        }
        catch (Exception e) {
            log.error((Throwable)e, "failure!!!!", new Object[0]);
            System.exit(1);
        }
    }
}

