/*
 * Decompiled with CFR 0.152.
 */
package io.druid.cli;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.metamx.common.concurrent.ScheduledExecutorFactory;
import com.metamx.common.logger.Logger;
import io.airlift.command.Command;
import io.druid.cli.CoordinatorJettyServerInitializer;
import io.druid.cli.ServerRunnable;
import io.druid.client.indexing.IndexingServiceClient;
import io.druid.db.DatabaseRuleManager;
import io.druid.db.DatabaseRuleManagerConfig;
import io.druid.db.DatabaseRuleManagerProvider;
import io.druid.db.DatabaseSegmentManager;
import io.druid.db.DatabaseSegmentManagerConfig;
import io.druid.db.DatabaseSegmentManagerProvider;
import io.druid.guice.ConfigProvider;
import io.druid.guice.Jerseys;
import io.druid.guice.JsonConfigProvider;
import io.druid.guice.LazySingleton;
import io.druid.guice.LifecycleModule;
import io.druid.guice.ManageLifecycle;
import io.druid.server.coordinator.DruidCoordinator;
import io.druid.server.coordinator.DruidCoordinatorConfig;
import io.druid.server.coordinator.LoadQueueTaskMaster;
import io.druid.server.http.BackwardsCompatibleCoordinatorResource;
import io.druid.server.http.BackwardsCompatibleInfoResource;
import io.druid.server.http.CoordinatorDynamicConfigsResource;
import io.druid.server.http.CoordinatorRedirectInfo;
import io.druid.server.http.CoordinatorResource;
import io.druid.server.http.DBResource;
import io.druid.server.http.DatasourcesResource;
import io.druid.server.http.InfoResource;
import io.druid.server.http.RedirectFilter;
import io.druid.server.http.RedirectInfo;
import io.druid.server.http.RulesResource;
import io.druid.server.http.ServersResource;
import io.druid.server.http.TiersResource;
import io.druid.server.initialization.JettyServerInitializer;
import java.util.List;
import java.util.concurrent.Executors;
import org.apache.curator.framework.CuratorFramework;
import org.eclipse.jetty.server.Server;

@Command(name="coordinator", description="Runs the Coordinator, see http://druid.io/docs/latest/Coordinator.html for a description.")
public class CliCoordinator
extends ServerRunnable {
    private static final Logger log = new Logger(CliCoordinator.class);

    public CliCoordinator() {
        super(log);
    }

    @Override
    protected List<Object> getModules() {
        return ImmutableList.of((Object)new Module(){

            public void configure(Binder binder) {
                ConfigProvider.bind((Binder)binder, DruidCoordinatorConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.manager.segments", DatabaseSegmentManagerConfig.class);
                JsonConfigProvider.bind((Binder)binder, (String)"druid.manager.rules", DatabaseRuleManagerConfig.class);
                binder.bind(RedirectFilter.class).in(LazySingleton.class);
                binder.bind(RedirectInfo.class).to(CoordinatorRedirectInfo.class).in(LazySingleton.class);
                binder.bind(DatabaseSegmentManager.class).toProvider(DatabaseSegmentManagerProvider.class).in(ManageLifecycle.class);
                binder.bind(DatabaseRuleManager.class).toProvider(DatabaseRuleManagerProvider.class).in(ManageLifecycle.class);
                binder.bind(IndexingServiceClient.class).in(LazySingleton.class);
                binder.bind(DruidCoordinator.class);
                LifecycleModule.register((Binder)binder, DruidCoordinator.class);
                binder.bind(JettyServerInitializer.class).to(CoordinatorJettyServerInitializer.class);
                Jerseys.addResource((Binder)binder, BackwardsCompatibleInfoResource.class);
                Jerseys.addResource((Binder)binder, InfoResource.class);
                Jerseys.addResource((Binder)binder, BackwardsCompatibleCoordinatorResource.class);
                Jerseys.addResource((Binder)binder, CoordinatorResource.class);
                Jerseys.addResource((Binder)binder, CoordinatorDynamicConfigsResource.class);
                Jerseys.addResource((Binder)binder, TiersResource.class);
                Jerseys.addResource((Binder)binder, RulesResource.class);
                Jerseys.addResource((Binder)binder, ServersResource.class);
                Jerseys.addResource((Binder)binder, DatasourcesResource.class);
                Jerseys.addResource((Binder)binder, DBResource.class);
                LifecycleModule.register((Binder)binder, Server.class);
            }

            @Provides
            @LazySingleton
            public LoadQueueTaskMaster getLoadQueueTaskMaster(CuratorFramework curator, ObjectMapper jsonMapper, ScheduledExecutorFactory factory, DruidCoordinatorConfig config) {
                return new LoadQueueTaskMaster(curator, jsonMapper, factory.create(1, "Master-PeonExec--%d"), Executors.newSingleThreadExecutor(), config);
            }
        });
    }
}

